/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.ide.ChooseWorkspaceData;
import org.eclipse.ui.internal.ide.ChooseWorkspaceDialog;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.ide.StatusUtil;
import org.eclipse.ui.preferences.SettingsTransfer;

public class ChooseWorkspaceWithSettingsDialog
extends ChooseWorkspaceDialog {
    private static final String WORKBENCH_SETTINGS = "WORKBENCH_SETTINGS";
    private static final String ENABLED_TRANSFERS = "ENABLED_TRANSFERS";
    private static final String ATT_CLASS = "class";
    private static final String ATT_NAME = "name";
    private static final String ATT_ID = "id";
    private static final String ATT_HELP_CONTEXT = "helpContext";
    private Collection selectedSettings = new HashSet();

    public ChooseWorkspaceWithSettingsDialog(Shell parentShell, ChooseWorkspaceData launchData, boolean suppressAskAgain, boolean centerOnMonitor) {
        super(parentShell, launchData, suppressAskAgain, centerOnMonitor);
    }

    protected Control createDialogArea(Composite parent) {
        Control top = super.createDialogArea(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.ui.ide.switch_workspace_dialog_context");
        this.createSettingsControls((Composite)top);
        ChooseWorkspaceWithSettingsDialog.applyDialogFont((Control)parent);
        return top;
    }

    private void createSettingsControls(Composite workArea) {
        final FormToolkit toolkit = new FormToolkit(workArea.getDisplay());
        workArea.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                toolkit.dispose();
            }
        });
        final ScrolledForm form = toolkit.createScrolledForm(workArea);
        form.setBackground(workArea.getBackground());
        form.getBody().setLayout((Layout)new GridLayout());
        GridData layoutData = new GridData(4, 4, true, true);
        form.setLayoutData((Object)layoutData);
        ExpandableComposite expandable = toolkit.createExpandableComposite(form.getBody(), 2);
        expandable.setText(IDEWorkbenchMessages.ChooseWorkspaceWithSettingsDialog_SettingsGroupName);
        expandable.setBackground(workArea.getBackground());
        expandable.setLayout((Layout)new GridLayout());
        expandable.setLayoutData((Object)new GridData(4, 4, true, true));
        expandable.addExpansionListener(new IExpansionListener(){
            boolean notExpanded = true;

            public void expansionStateChanged(ExpansionEvent e) {
                form.reflow(true);
                if (e.getState() && this.notExpanded) {
                    ChooseWorkspaceWithSettingsDialog.this.getShell().setRedraw(false);
                    Rectangle shellBounds = ChooseWorkspaceWithSettingsDialog.this.getShell().getBounds();
                    int entriesToShow = Math.min(4, SettingsTransfer.getSettingsTransfers().length);
                    shellBounds.height += ChooseWorkspaceWithSettingsDialog.this.convertHeightInCharsToPixels(entriesToShow) + 4;
                    ChooseWorkspaceWithSettingsDialog.this.getShell().setBounds(shellBounds);
                    ChooseWorkspaceWithSettingsDialog.this.getShell().setRedraw(true);
                    this.notExpanded = false;
                }
            }

            public void expansionStateChanging(ExpansionEvent e) {
            }
        });
        Composite sectionClient = toolkit.createComposite((Composite)expandable);
        sectionClient.setLayout((Layout)new GridLayout());
        sectionClient.setBackground(workArea.getBackground());
        if (this.createButtons(toolkit, sectionClient)) {
            expandable.setExpanded(true);
        }
        expandable.setClient((Control)sectionClient);
    }

    private boolean createButtons(FormToolkit toolkit, Composite sectionClient) {
        IConfigurationElement[] settings = SettingsTransfer.getSettingsTransfers();
        String[] enabledSettings = this.getEnabledSettings(IDEWorkbenchPlugin.getDefault().getDialogSettings().getSection(WORKBENCH_SETTINGS));
        int i = 0;
        while (i < settings.length) {
            final IConfigurationElement settingsTransfer = settings[i];
            final Button button = toolkit.createButton(sectionClient, settings[i].getAttribute(ATT_NAME), 32);
            String helpId = settings[i].getAttribute(ATT_HELP_CONTEXT);
            if (helpId != null) {
                PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)button, helpId);
            }
            if (enabledSettings != null && enabledSettings.length > 0) {
                String id = settings[i].getAttribute(ATT_ID);
                int j = 0;
                while (j < enabledSettings.length) {
                    if (enabledSettings[j].equals(id)) {
                        button.setSelection(true);
                        this.selectedSettings.add(settingsTransfer);
                        break;
                    }
                    ++j;
                }
            }
            button.setBackground(sectionClient.getBackground());
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (button.getSelection()) {
                        ChooseWorkspaceWithSettingsDialog.this.selectedSettings.add(settingsTransfer);
                    } else {
                        ChooseWorkspaceWithSettingsDialog.this.selectedSettings.remove(settingsTransfer);
                    }
                }
            });
            ++i;
        }
        return enabledSettings != null && enabledSettings.length > 0;
    }

    private String[] getEnabledSettings(IDialogSettings section) {
        if (section == null) {
            return null;
        }
        return section.getArray(ENABLED_TRANSFERS);
    }

    protected void okPressed() {
        Iterator settingsIterator = this.selectedSettings.iterator();
        MultiStatus result = new MultiStatus("org.eclipse.ui", 0, IDEWorkbenchMessages.ChooseWorkspaceWithSettingsDialog_ProblemsTransferTitle, null);
        Path path = new Path(this.getWorkspaceLocation());
        String[] selectionIDs = new String[this.selectedSettings.size()];
        int index = 0;
        while (settingsIterator.hasNext()) {
            IConfigurationElement elem = (IConfigurationElement)settingsIterator.next();
            result.add(this.transferSettings(elem, (IPath)path));
            selectionIDs[index] = elem.getAttribute(ATT_ID);
        }
        if (result.getSeverity() != 0) {
            ErrorDialog.openError((Shell)this.getShell(), (String)IDEWorkbenchMessages.ChooseWorkspaceWithSettingsDialog_TransferFailedMessage, (String)IDEWorkbenchMessages.ChooseWorkspaceWithSettingsDialog_SaveSettingsFailed, (IStatus)result);
            return;
        }
        this.saveSettings(selectionIDs);
        super.okPressed();
    }

    private void saveSettings(String[] selectionIDs) {
        IDialogSettings settings = IDEWorkbenchPlugin.getDefault().getDialogSettings().getSection(WORKBENCH_SETTINGS);
        if (settings == null) {
            settings = IDEWorkbenchPlugin.getDefault().getDialogSettings().addNewSection(WORKBENCH_SETTINGS);
        }
        settings.put(ENABLED_TRANSFERS, selectionIDs);
    }

    private IStatus transferSettings(final IConfigurationElement element, final IPath path) {
        final IStatus[] exceptions = new IStatus[1];
        SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

            public void run() throws Exception {
                try {
                    SettingsTransfer transfer = (SettingsTransfer)WorkbenchPlugin.createExtension((IConfigurationElement)element, (String)ChooseWorkspaceWithSettingsDialog.ATT_CLASS);
                    transfer.transferSettings(path);
                }
                catch (CoreException exception) {
                    exceptions[0] = exception.getStatus();
                }
            }

            public void handleException(Throwable exception) {
                exceptions[0] = StatusUtil.newStatus(4, NLS.bind((String)IDEWorkbenchMessages.ChooseWorkspaceWithSettingsDialog_ClassCreationFailed, (Object)element.getAttribute(ChooseWorkspaceWithSettingsDialog.ATT_CLASS)), exception);
            }
        });
        if (exceptions[0] != null) {
            return exceptions[0];
        }
        return Status.OK_STATUS;
    }

    protected int getDialogBoundsStrategy() {
        return 1;
    }
}

