/*
 * Decompiled with CFR 0.152.
 */
package ru.ssa.artixadmin.action.connect;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import ru.ssa.artixadmin.view.connect.ConnectTableViewer;
import ru.ssa.cashadmin.domain.DomainCollections;
import ru.ssa.cashadmin.domain.utils.JaxbUtil;
import su.artix.yuki.images.ArtixAdminImages;

public class ExportConnectAction
extends Action {
    private ConnectTableViewer connectTableViewer;

    public ExportConnectAction(ConnectTableViewer connectTableViewer) {
        super("\u042d&\u043a\u0441\u043f\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u0435", ArtixAdminImages.getDefault().getImageDescriptor("plane/16x16/export"));
        this.connectTableViewer = connectTableViewer;
    }

    public void run() {
        Object conns = this.connectTableViewer.getInput();
        if (conns != null && conns instanceof List) {
            List connections = (List)conns;
            if (!connections.isEmpty()) {
                FileDialog dialog = new FileDialog(Display.getCurrent().getActiveShell());
                String[] extensions = new String[]{"*.xml", "*.*"};
                dialog.setFilterExtensions(extensions);
                dialog.setFileName("yukiConnections.xml");
                String exportFilePath = dialog.open();
                if (exportFilePath != null && !exportFilePath.isEmpty()) {
                    File file;
                    if (!exportFilePath.endsWith(".xml")) {
                        exportFilePath = String.valueOf(exportFilePath) + ".xml";
                    }
                    if (!(file = new File(exportFilePath)).exists()) {
                        try {
                            file.createNewFile();
                        }
                        catch (IOException ex) {
                            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"\u041e\u0448\u0438\u0431\u043a\u0430", (String)("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0441\u043e\u0437\u0434\u0430\u0442\u044c \u0444\u0430\u0439\u043b:\n" + ex.getMessage()));
                            return;
                        }
                    }
                    DomainCollections domainCollections = new DomainCollections();
                    domainCollections.setDomainCollection(connections);
                    JaxbUtil.INSTANCE.exportToXML(exportFilePath, domainCollections);
                    MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)"\u0423\u0441\u043f\u0435\u0445", (String)("\u042d\u043a\u0441\u043f\u043e\u0440\u0442 \u0432 \u0444\u0430\u0439\u043b \u043f\u0440\u043e\u0448\u0435\u043b \u0443\u0441\u043f\u0435\u0448\u043d\u043e\n" + exportFilePath));
                }
            } else {
                MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)"\u0412\u043d\u0438\u043c\u0430\u043d\u0438\u0435", (String)"\u041e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u044e\u0442 \u0434\u0430\u043d\u043d\u044b\u0435 \u0434\u043b\u044f \u044d\u043a\u0441\u043f\u043e\u0440\u0442\u0430");
            }
        }
    }
}

