/*
 * Decompiled with CFR 0.152.
 */
package ru.ssa.artixadmin.provider.goods;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import ru.ssa.cashadmin.LibActivator;
import ru.ssa.cashadmin.domain.Catalogrestrict;
import ru.ssa.cashadmin.domain.Timerestrict;
import su.artix.yuki.model.ModelActivator;
import su.artix.yuki.model.directory.DirectoryAction;
import su.artix.yuki.provider.IOrderedContentProvider;

public class CatalogrestrictContentProvider
implements IStructuredContentProvider,
IOrderedContentProvider {
    private final Map<Catalogrestrict, String> map = new HashMap<Catalogrestrict, String>();
    private boolean ascending = true;
    private String sortBy;
    private final TableViewer tableViewer;

    public CatalogrestrictContentProvider(Timerestrict model, TableViewer tableViewer) {
        this.tableViewer = tableViewer;
        this.sortBy = "catalogid";
        if (model.getTimerestrictid() != null) {
            Catalogrestrict state = (Catalogrestrict)LibActivator.getDefault().getActualClassResolver().getInstance(Catalogrestrict.class);
            state.setRestrictid(model.getTimerestrictid());
            List objects = ModelActivator.getDefault().getModelProvider().getDirectoryModel(Catalogrestrict.class).getList(this.sortBy, this.ascending, (Object)state);
            for (Catalogrestrict object : objects) {
                this.map.put(object, DirectoryAction.NONE.toString());
            }
        }
    }

    public Map<Catalogrestrict, String> getMap() {
        return this.map;
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public Object[] getElements(Object inputElement) {
        ArrayList<Catalogrestrict> catalogrestricts = new ArrayList<Catalogrestrict>();
        for (Catalogrestrict key : this.map.keySet()) {
            if (this.map.get(key).equals(DirectoryAction.REMOVE.toString())) continue;
            catalogrestricts.add(key);
        }
        Collections.sort(catalogrestricts, new Comparator<Catalogrestrict>(){

            @Override
            public int compare(Catalogrestrict o1, Catalogrestrict o2) {
                int result = 0;
                if (o1.getCatalog() != null && o2.getCatalog() != null) {
                    if (CatalogrestrictContentProvider.this.sortBy.equals("catalogid")) {
                        result = o1.getCatalogid().compareTo(o2.getCatalogid());
                    } else if (CatalogrestrictContentProvider.this.sortBy.equals("deptcode")) {
                        result = o1.getDeptcode().compareTo(o2.getDeptcode());
                    }
                }
                return CatalogrestrictContentProvider.this.ascending ? result : result * -1;
            }
        });
        return catalogrestricts.toArray();
    }

    public String getSortProperty() {
        return this.sortBy;
    }

    public void setSortProperty(String sortby) {
        this.sortBy = sortby;
        this.tableViewer.setInput(null);
    }

    public boolean isAscending() {
        return this.ascending;
    }

    public void setAscending(boolean ascending) {
        this.ascending = ascending;
    }
}

