/*
 * Decompiled with CFR 0.152.
 */
package org.dozer.factory;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.dozer.BeanFactory;
import org.dozer.factory.BeanCreationDirective;
import org.dozer.factory.BeanCreationStrategy;
import org.dozer.factory.ConstructionStrategies;

public final class DestBeanCreator {
    static final List<BeanCreationStrategy> pluggedStrategies = new ArrayList<BeanCreationStrategy>();
    static final BeanCreationStrategy[] availableStrategies = new BeanCreationStrategy[]{ConstructionStrategies.byCreateMethod(), ConstructionStrategies.byGetInstance(), ConstructionStrategies.xmlGregorianCalendar(), ConstructionStrategies.byInterface(), ConstructionStrategies.xmlBeansBased(), ConstructionStrategies.byFactory(), ConstructionStrategies.byConstructor()};

    private DestBeanCreator() {
    }

    public static <T> T create(Class<T> targetClass) {
        return (T)DestBeanCreator.create(targetClass, null);
    }

    public static Object create(Class<?> targetClass, Class<?> alternateClass) {
        return DestBeanCreator.create(new BeanCreationDirective(null, null, targetClass, alternateClass, null, null, null));
    }

    public static Object create(BeanCreationDirective directive) {
        Object result = DestBeanCreator.applyStrategies(directive, pluggedStrategies);
        if (result == null) {
            result = DestBeanCreator.applyStrategies(directive, Arrays.asList(availableStrategies));
        }
        return result;
    }

    private static Object applyStrategies(BeanCreationDirective directive, List<BeanCreationStrategy> strategies) {
        for (BeanCreationStrategy strategy : new CopyOnWriteArrayList<BeanCreationStrategy>(strategies)) {
            if (!strategy.isApplicable(directive)) continue;
            return strategy.create(directive);
        }
        return null;
    }

    public static void setStoredFactories(Map<String, BeanFactory> factories) {
        ConstructionStrategies.byFactory().setStoredFactories(factories);
    }

    public static void addPluggedStrategy(BeanCreationStrategy strategy) {
        pluggedStrategies.add(strategy);
    }
}

