/*
 * Decompiled with CFR 0.152.
 */
package ru.ssa.cashadmin.domain;

import java.math.BigDecimal;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.MappedSuperclass;
import javax.persistence.Table;
import javax.validation.constraints.Digits;
import javax.validation.constraints.Min;
import org.hibernate.annotations.NotFound;
import org.hibernate.annotations.NotFoundAction;
import org.hibernate.annotations.Target;
import ru.ssa.cashadmin.domain.Aspectvalueset;
import ru.ssa.cashadmin.domain.BarcodesServerV10;
import ru.ssa.cashadmin.domain.Units;

@Entity
@Table(name="barcodes")
@MappedSuperclass
public class BarcodesServerV17
extends BarcodesServerV10 {
    private static final long serialVersionUID = 1L;
    @Min(value=0L)
    @Digits(integer=13, fraction=3)
    private BigDecimal quantdefault;
    @Min(value=0L)
    @Digits(integer=15, fraction=2)
    private BigDecimal packingprice;
    @ManyToOne
    @JoinColumn(name="packingmeasure")
    @NotFound(action=NotFoundAction.IGNORE)
    private Units packingmeasure;
    @Column(name="packingmeasure", insertable=false, updatable=false)
    private Integer packingmeasurecode;
    @ManyToOne
    @JoinColumn(name="aspectvaluesetcode")
    @NotFound(action=NotFoundAction.IGNORE)
    @Target(value=Aspectvalueset.class)
    private Aspectvalueset aspectvalueset;

    protected BarcodesServerV17() {
    }

    public BigDecimal getQuantdefault() {
        return this.quantdefault;
    }

    public void setQuantdefault(BigDecimal quantdefault) {
        this.quantdefault = quantdefault;
    }

    public BigDecimal getPackingprice() {
        return this.packingprice;
    }

    public void setPackingprice(BigDecimal packingprice) {
        this.packingprice = packingprice;
    }

    public Units getPackingmeasure() {
        return this.packingmeasure;
    }

    public void setPackingmeasure(Units packingmeasure) {
        this.packingmeasure = packingmeasure;
        this.packingmeasurecode = packingmeasure != null ? packingmeasure.getCode() : null;
    }

    public Integer getPackingmeasurecode() {
        return this.packingmeasurecode;
    }

    public void setPackingmeasurecode(Integer packingmeasurecode) {
        this.packingmeasurecode = packingmeasurecode;
    }

    public Aspectvalueset getAspectvalueset() {
        return this.aspectvalueset;
    }

    public void setAspectvalueset(Aspectvalueset aspectvalueset) {
        this.aspectvalueset = aspectvalueset;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.aspectvalueset == null ? 0 : this.aspectvalueset.hashCode());
        result = 31 * result + (this.packingmeasure == null ? 0 : this.packingmeasure.hashCode());
        result = 31 * result + (this.packingmeasurecode == null ? 0 : this.packingmeasurecode.hashCode());
        result = 31 * result + (this.packingprice == null ? 0 : this.packingprice.hashCode());
        result = 31 * result + (this.quantdefault == null ? 0 : this.quantdefault.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BarcodesServerV17 other = (BarcodesServerV17)obj;
        if (this.aspectvalueset == null ? other.aspectvalueset != null : !this.aspectvalueset.equals(other.aspectvalueset)) {
            return false;
        }
        if (this.packingmeasure == null ? other.packingmeasure != null : !this.packingmeasure.equals(other.packingmeasure)) {
            return false;
        }
        if (this.packingmeasurecode == null ? other.packingmeasurecode != null : !this.packingmeasurecode.equals(other.packingmeasurecode)) {
            return false;
        }
        if (this.packingprice == null ? other.packingprice != null : !this.packingprice.equals(other.packingprice)) {
            return false;
        }
        return !(this.quantdefault == null ? other.quantdefault != null : !this.quantdefault.equals(other.quantdefault));
    }
}

