/*
 * Decompiled with CFR 0.152.
 */
package su.artix.discountmanager.dialogs.discountsystem.controls;

import com.richclientgui.toolbox.validation.ValidatingField;
import com.richclientgui.toolbox.validation.string.StringValidationToolkit;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import su.artix.discountmanager.dialogs.discountsystem.controls.DiscountConditionControl;
import su.artix.discountmanager.dialogs.discountsystem.controls.DiscountConditionControlListener;
import su.artix.discountmanager.utils.StringResultGetter;
import su.artix.discountmanager.utils.ValidatorFactory;

public class DiscountConditionOptionsControl
implements DiscountConditionControl {
    private Text text;
    private ValidatingField<?> validator;

    public DiscountConditionOptionsControl(Composite parent, String labelName, String defaultValue) {
        Label label = new Label(parent, 0);
        label.setText(labelName);
        GridDataFactory.fillDefaults().applyTo((Control)label);
        StringValidationToolkit stringValidationToolkit = new StringValidationToolkit(131200, 1, true);
        this.validator = stringValidationToolkit.createTextField(parent, ValidatorFactory.NotNullStringValidator, false, (Object)"");
        this.text = (Text)this.validator.getControl();
        if (defaultValue != null) {
            if (defaultValue.startsWith("[") && defaultValue.endsWith("]")) {
                String def = StringUtils.substringBetween((String)defaultValue, (String)"[", (String)"]");
                if (def.startsWith("u\"") && def.endsWith("\"")) {
                    String[] mass = StringUtils.split((String)def, (String)",");
                    StringBuilder sb = new StringBuilder();
                    String[] stringArray = mass;
                    int n = mass.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String mas = stringArray[n2];
                        sb.append(StringUtils.substringBetween((String)mas, (String)"u\"", (String)"\""));
                        sb.append(",");
                        ++n2;
                    }
                    this.text.setText(sb.toString().substring(0, sb.length() - 1));
                } else {
                    this.text.setText(def);
                }
            } else {
                this.text.setText(defaultValue);
            }
        }
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.text);
    }

    @Override
    public String getText() {
        String[] items = StringUtils.split((String)this.text.getText(), (String)",");
        StringResultGetter rg = new StringResultGetter(",", "\"", "[", "]", "u");
        String str = rg.getStringFromList(items);
        return str;
    }

    @Override
    public String getDesc() {
        return this.getText();
    }

    @Override
    public boolean isValid() {
        return this.validator != null && this.validator.isValid();
    }

    @Override
    public void addListener(final DiscountConditionControlListener listener) {
        this.text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                listener.exec();
            }
        });
    }
}

