/*
 * Decompiled with CFR 0.152.
 */
package org.mihalis.opal.heapManager;

import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;
import org.mihalis.opal.utils.ResourceManager;
import org.mihalis.opal.utils.SWTGraphicUtil;

public class HeapManager
extends Composite {
    private Canvas bar;
    private Button button;
    private int heapMaxSize;
    private int heapSize;
    private Color barBorderColor;
    private Color barInnerColor;
    private Color barTextColor;
    private Color barGradientColorTopStart;
    private Color barGradientColorTopEnd;
    private Color barGradientColorMiddleStart;

    public HeapManager(Composite composite, int n) {
        super(composite, n);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 0;
        this.setLayout((Layout)gridLayout);
        this.createBar();
        this.createButton();
        this.updateContent();
        this.createDefaultColors();
    }

    private void createBar() {
        this.bar = new Canvas((Composite)this, 0);
        GridData gridData = new GridData(4, 4, true, false);
        gridData.minimumWidth = 100;
        gridData.heightHint = 30;
        this.bar.setLayoutData((Object)gridData);
        this.heapMaxSize = (int)(Runtime.getRuntime().maxMemory() / 0x100000L);
        this.bar.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent paintEvent) {
                HeapManager.this.drawBar(paintEvent);
            }
        });
    }

    private void drawBar(PaintEvent paintEvent) {
        GC gC = paintEvent.gc;
        Rectangle rectangle = this.bar.getClientArea();
        gC.setForeground(this.barBorderColor);
        gC.setBackground(this.barInnerColor);
        gC.fillRectangle(rectangle);
        gC.drawRectangle(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height - 1);
        float f = ((float)rectangle.width - 2.0f) * (float)this.heapSize / (float)this.heapMaxSize;
        gC.setForeground(this.barGradientColorTopStart);
        gC.setBackground(this.barGradientColorTopEnd);
        gC.fillGradientRectangle(rectangle.x + 1, rectangle.y + 1, (int)f, rectangle.height / 2, true);
        gC.setForeground(this.barGradientColorMiddleStart);
        gC.setBackground(this.barBorderColor);
        gC.fillGradientRectangle(rectangle.x + 1, rectangle.height / 2, (int)f, rectangle.height / 2, true);
        String string = this.heapSize + " " + ResourceManager.getLabel("megabytes") + "/" + this.heapMaxSize + " " + ResourceManager.getLabel("megabytes");
        Point point = gC.stringExtent(string);
        gC.setForeground(this.barTextColor);
        gC.setFont(this.getFont());
        gC.drawText(string, (rectangle.width - point.x) / 2, (rectangle.height - point.y) / 2, true);
        gC.dispose();
    }

    private void createButton() {
        this.button = new Button((Composite)this, 8);
        Image image = SWTGraphicUtil.createImageFromFile("images/trash.png");
        this.button.setImage(image);
        SWTGraphicUtil.addDisposer((Widget)this.button, (Resource)image);
        this.button.setLayoutData((Object)new GridData(4, 4, false, false));
        this.button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                System.gc();
            }
        });
        this.button.setToolTipText(ResourceManager.getLabel("performGC"));
        this.button.pack();
    }

    private void updateContent() {
        this.getDisplay().timerExec(500, new Runnable(){

            @Override
            public void run() {
                HeapManager.this.heapSize = (int)(Runtime.getRuntime().totalMemory() / 0x100000L);
                if (!HeapManager.this.isDisposed()) {
                    HeapManager.this.bar.redraw();
                    if (!HeapManager.this.getDisplay().isDisposed()) {
                        HeapManager.this.getDisplay().timerExec(500, (Runnable)this);
                    }
                }
            }
        });
    }

    private void createDefaultColors() {
        this.barTextColor = SWTGraphicUtil.getDefaultColor((Control)this, 57, 98, 149);
        this.barInnerColor = SWTGraphicUtil.getDefaultColor((Control)this, 219, 230, 243);
        this.barBorderColor = SWTGraphicUtil.getDefaultColor((Control)this, 101, 148, 207);
        this.barGradientColorTopStart = SWTGraphicUtil.getDefaultColor((Control)this, 175, 202, 237);
        this.barGradientColorTopEnd = SWTGraphicUtil.getDefaultColor((Control)this, 136, 177, 229);
        this.barGradientColorMiddleStart = SWTGraphicUtil.getDefaultColor((Control)this, 112, 161, 223);
    }

    public Color getBarBorderColor() {
        return this.barBorderColor;
    }

    public void setBarBorderColor(Color color) {
        this.barBorderColor = color;
    }

    public Color getBarInnerColor() {
        return this.barInnerColor;
    }

    public void setBarInnerColor(Color color) {
        this.barInnerColor = color;
    }

    public Color getBarTextColor() {
        return this.barTextColor;
    }

    public void setBarTextColor(Color color) {
        this.barTextColor = color;
    }

    public Color getBarGradientColorTopStart() {
        return this.barGradientColorTopStart;
    }

    public void setBarGradientColorTopStart(Color color) {
        this.barGradientColorTopStart = color;
    }

    public Color getBarGradientColorTopEnd() {
        return this.barGradientColorTopEnd;
    }

    public void setBarGradientColorTopEnd(Color color) {
        this.barGradientColorTopEnd = color;
    }

    public Color getBarGradientColorMiddleStart() {
        return this.barGradientColorMiddleStart;
    }

    public void setBarGradientColorMiddleStart(Color color) {
        this.barGradientColorMiddleStart = color;
    }
}

