/*
 * Decompiled with CFR 0.152.
 */
package org.mihalis.opal.propertyTable.editor;

import java.awt.Dimension;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TreeItem;
import org.mihalis.opal.propertyTable.PTProperty;
import org.mihalis.opal.propertyTable.editor.PTWindowEditor;
import org.mihalis.opal.utils.ResourceManager;

public class PTDimensionEditor
extends PTWindowEditor {
    private Text width;
    private Text height;

    @Override
    protected void createContent(Shell shell, PTProperty pTProperty) {
        Dimension dimension;
        Label label = new Label((Composite)shell, 0);
        label.setLayoutData((Object)new GridData(3, 1, false, false));
        label.setText(ResourceManager.getLabel("width"));
        this.width = new Text((Composite)shell, 2048);
        this.width.setLayoutData((Object)new GridData(4, 1, true, false));
        if (pTProperty.getValue() != null) {
            dimension = (Dimension)pTProperty.getValue();
            this.width.setText(String.valueOf(dimension.width));
        }
        this.addVerifyListeners(this.width);
        dimension = new Label((Composite)shell, 0);
        dimension.setLayoutData(new GridData(3, 1, false, false));
        dimension.setText(ResourceManager.getLabel("height"));
        this.height = new Text((Composite)shell, 2048);
        this.height.setLayoutData((Object)new GridData(4, 1, true, false));
        if (pTProperty.getValue() != null) {
            Dimension dimension2 = (Dimension)pTProperty.getValue();
            this.height.setText(String.valueOf(dimension2.height));
        }
        this.addVerifyListeners(this.height);
    }

    @Override
    protected void fillProperty(Item item, PTProperty pTProperty) {
        Dimension dimension = new Dimension();
        dimension.width = this.getIntValue(this.width);
        dimension.height = this.getIntValue(this.height);
        pTProperty.setValue(dimension);
        if (item instanceof TableItem) {
            ((TableItem)item).setText(1, this.getTextFor(pTProperty));
        } else {
            ((TreeItem)item).setText(1, this.getTextFor(pTProperty));
        }
    }

    @Override
    protected String getTextFor(PTProperty pTProperty) {
        if (pTProperty.getValue() == null) {
            return "(null)";
        }
        Dimension dimension = (Dimension)pTProperty.getValue();
        return "[" + dimension.width + "," + dimension.height + "]";
    }
}

