/*
 * Decompiled with CFR 0.152.
 */
package su.artix.yuki.model.directory;

import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.ssa.cashadmin.LibActivator;
import ru.ssa.cashadmin.dao.DaoFactory;
import ru.ssa.cashadmin.dao.DaoInterface;
import ru.ssa.cashadmin.domain.Barcodes;
import ru.ssa.cashadmin.domain.InventPrice;
import ru.ssa.cashadmin.domain.RemainBarcode;
import ru.ssa.cashadmin.excep.ExecuteQueryException;
import su.artix.yuki.model.directory.DirectoryModel;

public class DirectoryBarcodesModel
extends DirectoryModel<Barcodes> {
    private static final Logger log = LoggerFactory.getLogger(DirectoryBarcodesModel.class);

    public DirectoryBarcodesModel() {
        super(Barcodes.class);
    }

    @Override
    public void delete(Barcodes barcodes) throws ExecuteQueryException {
        this.removeInventPrices(barcodes);
        this.removeRemainBarcodes(barcodes);
        super.delete(barcodes);
    }

    private void removeInventPrices(Barcodes barcodes) throws ExecuteQueryException {
        DaoInterface dao = DaoFactory.getDAO(InventPrice.class);
        InventPrice state = (InventPrice)LibActivator.getDefault().getActualClassResolver().getInstance(InventPrice.class);
        state.setBcode(barcodes.getBarcode());
        dao.deleteAll((Collection)dao.getList((Object)state));
    }

    private void removeRemainBarcodes(Barcodes barcodes) throws ExecuteQueryException {
        DaoInterface dao = DaoFactory.getDAO(RemainBarcode.class);
        try {
            dao.deleteById((Object)barcodes.getBarcode());
        }
        catch (ExecuteQueryException executeQueryException) {
            log.info("Can't remove remainBarcode by barcode = {}", (Object)barcodes.getBarcode());
        }
    }
}

