/*
 * Decompiled with CFR 0.152.
 */
package su.artix.yuki.model.menutree;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.eclipse.core.runtime.PlatformObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.ssa.cashadmin.domain.advanced.HierarchicalMenu;
import ru.ssa.cashadmin.domain.advanced.HierarchicalMenuItem;
import ru.ssa.cashadmin.excep.ExecuteQueryException;
import ru.ssa.cashadmin.excep.MenuNotFoundException;
import ru.ssa.cashadmin.excep.SubMenuNotFoundException;
import su.artix.yuki.model.directory.DirectoryAction;

public class MenuTreeModel
extends PlatformObject {
    private static final Logger log = LoggerFactory.getLogger(MenuTreeModel.class);
    protected transient PropertyChangeSupport listeners = new PropertyChangeSupport((Object)this);
    private HierarchicalMenu hierarchicalMenu = new HierarchicalMenu();
    private HierarchicalMenuItem currentModel;
    private HierarchicalMenuItem defaultModel;

    public HierarchicalMenu getHierarchicalMenu() {
        return this.hierarchicalMenu;
    }

    public void setHierarchicalMenu(HierarchicalMenu hierarchicalMenu) {
        this.hierarchicalMenu = hierarchicalMenu;
    }

    public HierarchicalMenuItem getCurrentModel() {
        return this.currentModel;
    }

    public void setCurrentModel(HierarchicalMenuItem currentModel) {
        this.currentModel = currentModel;
    }

    public HierarchicalMenuItem getDefaultModel() {
        return this.defaultModel;
    }

    public void setDefaultModel(HierarchicalMenuItem defaultModel) {
        this.defaultModel = defaultModel;
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        if (l == null) {
            throw new IllegalArgumentException();
        }
        this.listeners.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.listeners.removePropertyChangeListener(l);
    }

    protected void firePropertyChange(DirectoryAction prop, Object old, Object newValue) {
        if (this.listeners.hasListeners(prop.toString())) {
            this.listeners.firePropertyChange(prop.toString(), old, newValue);
        }
    }

    private void add(HierarchicalMenuItem parent, HierarchicalMenuItem element, boolean action) throws ExecuteQueryException {
        this.hierarchicalMenu.add(parent, element, action);
    }

    public void update(HierarchicalMenuItem element, boolean action) throws ExecuteQueryException {
        this.hierarchicalMenu.update(element, action);
    }

    private void delete(HierarchicalMenuItem parent, HierarchicalMenuItem element, boolean action) throws ExecuteQueryException {
        this.hierarchicalMenu.delete(parent, element, action);
    }

    private void importRoot(HierarchicalMenuItem parent, HierarchicalMenuItem element, boolean action) throws ExecuteQueryException {
        this.hierarchicalMenu.importRoot(parent, element, action);
    }

    public void doAdd(HierarchicalMenuItem obj, boolean action) {
        try {
            this.add(obj.getParent(), obj, action);
            this.firePropertyChange(DirectoryAction.ADD, null, obj);
        }
        catch (ExecuteQueryException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public void doUpdate(HierarchicalMenuItem obj, boolean action) {
        try {
            this.update(obj, action);
            this.firePropertyChange(DirectoryAction.ADD, null, obj);
        }
        catch (ExecuteQueryException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public void doRemove(HierarchicalMenuItem obj, boolean action) {
        try {
            this.delete(obj.getParent(), obj, action);
            this.firePropertyChange(DirectoryAction.REMOVE, null, obj);
        }
        catch (ExecuteQueryException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public void doImport(HierarchicalMenuItem obj, boolean action) throws ExecuteQueryException {
        this.importRoot(obj.getParent(), obj, action);
        this.firePropertyChange(DirectoryAction.ADD, null, obj);
    }

    public void doRefresh(boolean action) throws MenuNotFoundException, SubMenuNotFoundException {
        if (action) {
            this.firePropertyChange(DirectoryAction.REFRESH, action, null);
        } else {
            this.hierarchicalMenu.loadData();
            this.firePropertyChange(DirectoryAction.REFRESH, action, null);
        }
    }
}

