/*
 * Decompiled with CFR 0.152.
 */
package su.artix.yuki.model.mongo;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.security.acl.Group;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.beanutils.BeanComparator;
import org.apache.commons.collections.comparators.ComparableComparator;
import org.apache.commons.collections.comparators.ReverseComparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.repository.PagingAndSortingRepository;
import ru.ssa.cashadmin.dao.DomainUtils;
import ru.ssa.cashadmin.excep.ExecuteQueryException;
import su.artix.cashserver.core.cashregistry.domain.Dept;
import su.artix.cashserver.core.cashregistry.domain.Property;
import su.artix.cashserver.core.cashregistry.domain.SecurityObject;
import su.artix.cashserver.core.cashregistry.domain.SecurityPermission;
import su.artix.cashserver.core.cashregistry.domain.SecurityRole;
import su.artix.cashserver.core.cashregistry.domain.Shop;
import su.artix.cashserver.core.cashregistry.domain.ShopGroupLabel;
import su.artix.cashserver.core.cashregistry.domain.ShopLabel;
import su.artix.cashserver.core.cashregistry.domain.Tag;
import su.artix.cashserver.core.cashregistry.domain.WebUser;
import su.artix.cashserver.core.cashregistry.repository.DeptRepository;
import su.artix.cashserver.core.cashregistry.repository.GroupRepository;
import su.artix.cashserver.core.cashregistry.repository.PropertyRepository;
import su.artix.cashserver.core.cashregistry.repository.SecurityObjectRepository;
import su.artix.cashserver.core.cashregistry.repository.SecurityPermissionRepository;
import su.artix.cashserver.core.cashregistry.repository.SecurityRoleRepository;
import su.artix.cashserver.core.cashregistry.repository.ShopGroupLabelRepository;
import su.artix.cashserver.core.cashregistry.repository.ShopLabelRepository;
import su.artix.cashserver.core.cashregistry.repository.ShopRepository;
import su.artix.cashserver.core.cashregistry.repository.TagRepository;
import su.artix.cashserver.core.cashregistry.repository.WebUserRepository;
import su.artix.yuki.model.ChangeIdValueException;
import su.artix.yuki.model.DuplicateValueException;
import su.artix.yuki.model.ModelActivator;
import su.artix.yuki.model.directory.DirectoryAction;
import su.artix.yuki.model.directory.DirectoryEditModelAdapter;

public class MongoModel<T>
extends DirectoryEditModelAdapter<T> {
    private transient PropertyChangeSupport listeners = new PropertyChangeSupport(this);
    private static final Logger log = LoggerFactory.getLogger(MongoModel.class);
    private Class<T> clazz;

    public MongoModel(Class<T> clazz) {
        this.clazz = clazz;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener l) {
        if (l == null) {
            throw new IllegalArgumentException();
        }
        this.listeners.addPropertyChangeListener(l);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.listeners.removePropertyChangeListener(l);
    }

    @Override
    public void firePropertyChange(DirectoryAction prop, Object old, Object newValue) {
        if (this.listeners.hasListeners(prop.toString())) {
            this.listeners.firePropertyChange(prop.toString(), old, newValue);
        }
    }

    private <ID extends Serializable> PagingAndSortingRepository<T, ID> getDaoRepository(Class<T> cl) {
        if (cl.equals(WebUser.class)) {
            return (PagingAndSortingRepository)ModelActivator.getDefault().getBeanByClass(WebUserRepository.class);
        }
        if (cl.equals(Group.class)) {
            return (PagingAndSortingRepository)ModelActivator.getDefault().getBeanByClass(GroupRepository.class);
        }
        if (cl.equals(Property.class)) {
            return (PagingAndSortingRepository)ModelActivator.getDefault().getBeanByClass(PropertyRepository.class);
        }
        if (cl.equals(Shop.class)) {
            return (PagingAndSortingRepository)ModelActivator.getDefault().getBeanByClass(ShopRepository.class);
        }
        if (cl.equals(Tag.class)) {
            return (PagingAndSortingRepository)ModelActivator.getDefault().getBeanByClass(TagRepository.class);
        }
        if (cl.equals(SecurityRole.class)) {
            return (PagingAndSortingRepository)ModelActivator.getDefault().getBeanByClass(SecurityRoleRepository.class);
        }
        if (cl.equals(SecurityObject.class)) {
            return (PagingAndSortingRepository)ModelActivator.getDefault().getBeanByClass(SecurityObjectRepository.class);
        }
        if (cl.equals(SecurityPermission.class)) {
            return (PagingAndSortingRepository)ModelActivator.getDefault().getBeanByClass(SecurityPermissionRepository.class);
        }
        if (cl.equals(ShopLabel.class)) {
            return (PagingAndSortingRepository)ModelActivator.getDefault().getBeanByClass(ShopLabelRepository.class);
        }
        if (cl.equals(ShopGroupLabel.class)) {
            return (PagingAndSortingRepository)ModelActivator.getDefault().getBeanByClass(ShopGroupLabelRepository.class);
        }
        if (cl.equals(Dept.class)) {
            return (PagingAndSortingRepository)ModelActivator.getDefault().getBeanByClass(DeptRepository.class);
        }
        log.error("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u044f \u043c\u043e\u0434\u0435\u043b\u0438 \u0434\u043b\u044f \u0440\u0430\u0431\u043e\u0442\u044b \u0441 \u0411\u0414 \u041c\u043e\u043d\u0433\u043e");
        return null;
    }

    @Override
    public void doAdd(T obj) throws DuplicateValueException {
        String id = DomainUtils.getIdValue(obj).toString();
        if (this.getDaoRepository(this.clazz).exists((Serializable)((Object)id))) {
            throw new DuplicateValueException(id);
        }
        this.getDaoRepository(this.clazz).save(obj);
        this.firePropertyChange(DirectoryAction.ADD, null, obj);
        this.cascadeRefresh();
    }

    @Override
    public void doRemove(T obj) {
        Object id = DomainUtils.getIdValue(obj);
        if (id != null) {
            this.getDaoRepository(this.clazz).delete((Serializable)((Object)id.toString()));
        } else {
            this.getDaoRepository(this.clazz).delete(obj);
        }
        this.firePropertyChange(DirectoryAction.REMOVE, null, obj);
        this.cascadeRefresh();
    }

    @Override
    public void doSave(T obj, Object oldId, T old, String ... idField) throws DuplicateValueException, ChangeIdValueException, ExecuteQueryException {
        String newId = null;
        newId = DomainUtils.getIdValue(obj).toString();
        if (!oldId.equals(newId)) {
            if (this.getDaoRepository(this.clazz).exists((Serializable)((Object)newId))) {
                throw new DuplicateValueException(newId);
            }
            this.doRemove(this.getDaoRepository(this.clazz).findOne((Serializable)((Object)((String)oldId))));
        }
        this.getDaoRepository(this.clazz).save(obj);
        this.firePropertyChange(DirectoryAction.UPDATE, null, obj);
        this.cascadeRefresh();
    }

    @Override
    public T getById(Object id) {
        return (T)this.getDaoRepository(this.clazz).findOne((Serializable)((Object)((String)id)));
    }

    @Override
    public List<T> getList() {
        return (List)this.getDaoRepository(this.clazz).findAll();
    }

    @Override
    public List<T> getList(T state) {
        return this.getList();
    }

    @Override
    public List<T> getList(String sortby, boolean sortAsc, Object state) {
        return this.getList(sortby, sortAsc);
    }

    @Override
    public List<T> getList(String sortby, boolean sortAsc, Object state, Integer firstResult, Integer maxResults) {
        return this.getList(sortby, sortAsc);
    }

    @Override
    public Long getItemCount(Object state) {
        return this.getDaoRepository(this.clazz).count();
    }

    @Override
    public List<T> getList(String sortby, boolean sortAsc) {
        List<T> list = this.getList();
        log.info("sort={}", (Object)sortby);
        if (sortby != null) {
            BeanComparator comparator = new BeanComparator(sortby);
            if (sortAsc) {
                comparator = new BeanComparator(sortby, (Comparator)new ReverseComparator((Comparator)new ComparableComparator()));
            }
            Collections.sort(list, comparator);
        }
        return list;
    }

    @Override
    public void setClazz(Class<T> clazz) {
        this.clazz = clazz;
    }

    @Override
    public void doRefresh() {
        this.firePropertyChange(DirectoryAction.REFRESH, null, null);
        this.cascadeRefresh();
    }
}

