/*
 * Decompiled with CFR 0.152.
 */
package ru.ssa.artixadmin.action.menutree;

import com.rits.cloning.Cloner;
import java.util.Map;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.ssa.artixadmin.action.menutree.MenuActionRights;
import ru.ssa.artixadmin.editors.menutree.ParameterContentProvider;
import ru.ssa.artixadmin.editors.menutree.ParameterEditDialog;
import ru.ssa.cashadmin.domain.Actionparameter;
import su.artix.yuki.images.ArtixAdminImages;
import su.artix.yuki.model.directory.DirectoryAction;

public class EditParameterAction
extends MenuActionRights
implements ActionFactory.IWorkbenchAction {
    public static final String ID = "ru.ssa.artixadmin.action.menutree.EditParameterAction";
    private static final Logger log = LoggerFactory.getLogger(EditParameterAction.class);
    private IWorkbenchWindow window;
    private TableViewer tableViewer;

    public EditParameterAction() {
        this(PlatformUI.getWorkbench().getActiveWorkbenchWindow());
    }

    public EditParameterAction(IWorkbenchWindow window) {
        super("&\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430");
        this.setId(ID);
        if (window == null) {
            throw new IllegalArgumentException();
        }
        this.window = window;
        this.setImageDescriptor(ArtixAdminImages.getDefault().getImageDescriptor("plane/16x16/edit"));
        this.setToolTipText("\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430");
    }

    public EditParameterAction(TableViewer tableViewer) {
        this();
        this.tableViewer = tableViewer;
    }

    public void run() {
        StructuredSelection selection = (StructuredSelection)this.tableViewer.getSelection();
        Actionparameter oldModel = (Actionparameter)selection.getFirstElement();
        Actionparameter model = this.getCloneModel(oldModel);
        if (model != null) {
            ParameterEditDialog dialog = new ParameterEditDialog(this.window.getShell(), model, false);
            if (dialog.open() == 0) {
                model.setActionparametercode(null);
                model.setParameterorder(dialog.getModel().getParameterorder());
                model.setParametername(dialog.getModel().getParametername());
                model.setParametervalue(dialog.getModel().getParametervalue());
                Map<Actionparameter, String> map = ((ParameterContentProvider)this.tableViewer.getContentProvider()).getMap();
                map.remove(oldModel);
                map.put(oldModel, DirectoryAction.REMOVE.toString());
                map.put(model, DirectoryAction.ADD.toString());
                this.tableViewer.refresh();
            }
        } else {
            this.setEnabled(false);
        }
    }

    private Actionparameter getCloneModel(Actionparameter model) {
        try {
            return (Actionparameter)new Cloner().deepClone((Object)model);
        }
        catch (Exception exception) {
            log.error("Couldn't clone.");
            return model;
        }
    }

    public void dispose() {
    }
}

