/*
 * Decompiled with CFR 0.152.
 */
package ru.ssa.artixadmin.editors.directory.notes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import ru.ssa.artixadmin.editors.directory.notes.DialogChoiceListDataEditDialog;
import ru.ssa.artixadmin.editors.directory.notes.DialogChoiceListDataModel;
import ru.ssa.cashadmin.domain.dict.notes.DialogParamContainer;
import su.artix.cashserver.security.SecurityKey;
import su.artix.widgets.BitCheckGroup;
import su.artix.yuki.directory.Directory;
import su.artix.yuki.editors.EditorComposite;
import su.artix.yuki.images.ArtixAdminImages;

@SecurityKey(title="\u0414\u0438\u0430\u043b\u043e\u0433 \u0432\u044b\u0431\u043e\u0440\u0430. \u0422\u0430\u0431\u043b\u0438\u0447\u043d\u043e\u0435 \u043f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0435")
public class DialogChoiceListEditPanel
extends EditorComposite<DialogParamContainer> {
    @SecurityKey(title="\u0417\u0430\u0433\u043e\u043b\u043e\u0432\u043e\u043a", id="dialogChoiceList.title")
    private Label titleLabel;
    @SecurityKey(id="dialogChoiceList.title")
    private Text titleField;
    @SecurityKey(title="\u0420\u0430\u0437\u0440\u0435\u0448\u0435\u043d\u043d\u044b\u0435 \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u0430 \u0434\u043b\u044f \u0432\u0432\u043e\u0434\u0430", id="dialogChoiceList.allowDevices")
    private BitCheckGroup allowDevices;
    private List<String> listHeaders = new ArrayList<String>(5);
    private TableViewer tableViewer;
    private ToolBar toolbar;
    private List<DialogChoiceListDataModel> data = new ArrayList<DialogChoiceListDataModel>();
    private Action addValueAction;

    public DialogChoiceListEditPanel(Composite parent, int style, DialogParamContainer model) {
        super(parent, style, DialogParamContainer.class, (Object)model);
        if (model.getDialogChoiceList() != null) {
            if (model.getDialogChoiceList().getHeaders() != null) {
                this.listHeaders = model.getDialogChoiceList().getHeaders();
            }
            if (model.getDialogChoiceList().getData() != null) {
                for (List dataItem : model.getDialogChoiceList().getData()) {
                    if (dataItem != null) {
                        DialogChoiceListDataModel dataModel = new DialogChoiceListDataModel();
                        int i = 0;
                        while (i < dataItem.size()) {
                            dataModel.setField(i, (String)dataItem.get(i));
                            ++i;
                        }
                        this.data.add(dataModel);
                    }
                    this.listHeaders = model.getDialogChoiceList().getHeaders();
                }
            }
        }
    }

    public void initialize() {
        GridLayoutFactory.swtDefaults().margins(0, 0).numColumns(2).applyTo((Composite)this);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)this);
        this.titleLabel = new Label((Composite)this, 0);
        this.titleLabel.setText("\u0417\u0430\u0433\u043e\u043b\u043e\u0432\u043e\u043a:");
        this.titleField = new Text((Composite)this, 2048);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)this.titleField);
        Group allowDevicesGroup = new Group((Composite)this, 0);
        allowDevicesGroup.setText("\u0420\u0430\u0437\u0440\u0435\u0448\u0435\u043d\u043d\u044b\u0435 \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u0430 \u0434\u043b\u044f \u0432\u0432\u043e\u0434\u0430");
        GridLayoutFactory.swtDefaults().applyTo((Composite)allowDevicesGroup);
        GridDataFactory.fillDefaults().span(2, 1).grab(true, false).applyTo((Control)allowDevicesGroup);
        this.allowDevices = new BitCheckGroup((Composite)allowDevicesGroup, 0, Directory.noteAllowDevices);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.allowDevices);
        Text headerField1 = this.createHeaderField(0);
        Text headerField2 = this.createHeaderField(1);
        Text headerField3 = this.createHeaderField(2);
        Text headerField4 = this.createHeaderField(3);
        Text headerField5 = this.createHeaderField(4);
        Group choicesGroup = new Group((Composite)this, 0);
        choicesGroup.setText("\u0412\u0430\u0440\u0438\u0430\u043d\u0442\u044b \u0432\u044b\u0431\u043e\u0440\u0430");
        GridLayoutFactory.swtDefaults().applyTo((Composite)choicesGroup);
        GridDataFactory.fillDefaults().span(2, 1).grab(true, true).applyTo((Control)choicesGroup);
        this.toolbar = new ToolBar((Composite)choicesGroup, 0x800000);
        ToolBarManager toolBarManager = new ToolBarManager(this.toolbar);
        this.addValueAction = new AddValueAction();
        toolBarManager.add((IAction)this.addValueAction);
        final EditValueAction editValueAction = new EditValueAction();
        toolBarManager.add((IAction)editValueAction);
        final RemoveValueAction removeValueAction = new RemoveValueAction();
        toolBarManager.add((IAction)removeValueAction);
        final DownValueAction downValueAction = new DownValueAction();
        toolBarManager.add((IAction)downValueAction);
        final UpValueAction upValueAction = new UpValueAction();
        toolBarManager.add((IAction)upValueAction);
        toolBarManager.update(true);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.toolbar);
        this.tableViewer = new TableViewer((Composite)choicesGroup, 68352);
        this.tableViewer.setContentProvider((IContentProvider)new ListContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new ListLabelProvider());
        this.tableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                new EditValueAction().run();
            }
        });
        TableLayout tableLayout = new TableLayout();
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(70, 100, true));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(70, 100, true));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(70, 100, true));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(70, 100, true));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(70, 100, true));
        this.tableViewer.getTable().setLayout((Layout)tableLayout);
        this.tableViewer.getTable().setLinesVisible(true);
        this.tableViewer.getTable().setHeaderVisible(true);
        this.addValueAction.setEnabled(!this.isEmptyListHeaders());
        boolean enableEditAndRemove = !this.tableViewer.getSelection().isEmpty();
        editValueAction.setEnabled(enableEditAndRemove);
        removeValueAction.setEnabled(enableEditAndRemove);
        downValueAction.setEnabled(enableEditAndRemove);
        upValueAction.setEnabled(enableEditAndRemove);
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                boolean enableEditAndRemove = !event.getSelection().isEmpty();
                editValueAction.setEnabled(enableEditAndRemove);
                removeValueAction.setEnabled(enableEditAndRemove);
                downValueAction.setEnabled(enableEditAndRemove);
                upValueAction.setEnabled(enableEditAndRemove);
            }
        });
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.tableViewer.getTable());
        TableColumn valueColumn1 = new TableColumn(this.tableViewer.getTable(), 16384);
        valueColumn1.setText(StringUtils.isEmpty((String)headerField1.getText()) ? "1" : headerField1.getText());
        TableColumn valueColumn2 = new TableColumn(this.tableViewer.getTable(), 16384);
        valueColumn2.setText(StringUtils.isEmpty((String)headerField2.getText()) ? "2" : headerField2.getText());
        TableColumn valueColumn3 = new TableColumn(this.tableViewer.getTable(), 16384);
        valueColumn3.setText(StringUtils.isEmpty((String)headerField3.getText()) ? "3" : headerField3.getText());
        TableColumn valueColumn4 = new TableColumn(this.tableViewer.getTable(), 16384);
        valueColumn4.setText(StringUtils.isEmpty((String)headerField4.getText()) ? "4" : headerField4.getText());
        TableColumn valueColumn5 = new TableColumn(this.tableViewer.getTable(), 16384);
        valueColumn5.setText(StringUtils.isEmpty((String)headerField5.getText()) ? "5" : headerField5.getText());
        this.tableViewer.setInput(this.data);
    }

    private boolean isEmptyListHeaders() {
        if (this.listHeaders != null) {
            for (String s : this.listHeaders) {
                if (!StringUtils.isNotBlank((String)s)) continue;
                return false;
            }
        }
        return true;
    }

    private Text createHeaderField(int index) {
        Label headerLabel = new Label((Composite)this, 0);
        headerLabel.setText("\u0417\u0430\u0433\u043e\u043b\u043e\u0432\u043e\u043a \u0441\u0442\u043e\u043b\u0431\u0446\u0430 " + (index + 1) + ":");
        Text headerField = new Text((Composite)this, 2048);
        headerField.setText(this.listHeaders.size() > index ? this.listHeaders.get(index) : "");
        headerField.addModifyListener((ModifyListener)new HeaderFieldChangeListener(index, headerField));
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)headerField);
        return headerField;
    }

    protected DialogParamContainer getActualModel(DialogParamContainer model) {
        return model;
    }

    public void bindValues() {
        this.initDefaulBinding();
    }

    public DialogParamContainer getModel() {
        return (DialogParamContainer)super.getModel();
    }

    private class AddValueAction
    extends Action {
        public AddValueAction() {
            super("\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u0432\u0430\u0440\u0438\u0430\u043d\u0442 \u0432\u044b\u0431\u043e\u0440\u0430", ArtixAdminImages.getDefault().getImageDescriptor("plane/16x16/add"));
        }

        public void run() {
            DialogChoiceListDataEditDialog dialog = new DialogChoiceListDataEditDialog(DialogChoiceListEditPanel.this.listHeaders, new DialogChoiceListDataModel());
            if (dialog.open() == 0) {
                DialogChoiceListEditPanel.this.data.add(dialog.getDialogChoiceListDataModel());
                DialogChoiceListEditPanel.this.tableViewer.refresh();
            }
        }
    }

    class DownValueAction
    extends Action {
        public DownValueAction() {
            super("\u041f\u0435\u0440\u0435\u043c\u0435\u0441\u0442\u0438\u0442\u044c \u0432\u043d\u0438\u0437", ArtixAdminImages.getDefault().getImageDescriptor("plane/16x16/down"));
        }

        public void run() {
            StructuredSelection structuredSelection = (StructuredSelection)DialogChoiceListEditPanel.this.tableViewer.getSelection();
            DialogChoiceListDataModel entry = (DialogChoiceListDataModel)structuredSelection.getFirstElement();
            int index = DialogChoiceListEditPanel.this.data.indexOf(entry);
            if (index < DialogChoiceListEditPanel.this.data.size()) {
                Collections.swap(DialogChoiceListEditPanel.this.data, index, index + 1);
                DialogChoiceListEditPanel.this.tableViewer.refresh();
            }
        }
    }

    private class EditValueAction
    extends Action {
        public EditValueAction() {
            super("\u0418\u0437\u043c\u0435\u043d\u0438\u0442\u044c \u0432\u0430\u0440\u0438\u0430\u043d\u0442 \u0432\u044b\u0431\u043e\u0440\u0430", ArtixAdminImages.getDefault().getImageDescriptor("plane/16x16/edit"));
        }

        public void run() {
            StructuredSelection structuredSelection = (StructuredSelection)DialogChoiceListEditPanel.this.tableViewer.getSelection();
            DialogChoiceListDataModel entry = (DialogChoiceListDataModel)structuredSelection.getFirstElement();
            DialogChoiceListDataEditDialog dialog = new DialogChoiceListDataEditDialog(DialogChoiceListEditPanel.this.listHeaders, entry);
            if (dialog.open() == 0) {
                int index = DialogChoiceListEditPanel.this.data.indexOf(entry);
                DialogChoiceListEditPanel.this.data.set(index, dialog.getDialogChoiceListDataModel());
                DialogChoiceListEditPanel.this.tableViewer.refresh();
            }
        }
    }

    private class HeaderFieldChangeListener
    implements ModifyListener {
        private int headerIndex;
        private Text headerField;

        public HeaderFieldChangeListener(int index, Text textField) {
            this.headerIndex = index;
            this.headerField = textField;
        }

        public void modifyText(ModifyEvent arg0) {
            DialogChoiceListEditPanel.this.tableViewer.getTable().getColumn(this.headerIndex).setText(this.headerField.getText());
            if (DialogChoiceListEditPanel.this.listHeaders.size() > this.headerIndex) {
                DialogChoiceListEditPanel.this.listHeaders.set(this.headerIndex, this.headerField.getText());
            } else {
                DialogChoiceListEditPanel.this.listHeaders.add(this.headerField.getText());
            }
            DialogChoiceListEditPanel.this.getModel().getDialogChoiceList().setHeaders(DialogChoiceListEditPanel.this.listHeaders);
            DialogChoiceListEditPanel.this.addValueAction.setEnabled(!DialogChoiceListEditPanel.this.isEmptyListHeaders());
            DialogChoiceListEditPanel.this.tableViewer.refresh();
        }
    }

    class ListContentProvider
    implements IStructuredContentProvider {
        ListContentProvider() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            viewer.refresh();
        }

        public Object[] getElements(Object inputElement) {
            ArrayList result = new ArrayList();
            for (DialogChoiceListDataModel entry : DialogChoiceListEditPanel.this.data) {
                ArrayList<String> entryList = new ArrayList<String>();
                int i = 0;
                while (i < DialogChoiceListEditPanel.this.listHeaders.size()) {
                    if (StringUtils.isNotBlank((String)((String)DialogChoiceListEditPanel.this.listHeaders.get(i)))) {
                        entryList.add(StringUtils.defaultString((String)entry.getField(i)));
                    }
                    ++i;
                }
                result.add(entryList);
            }
            DialogChoiceListEditPanel.this.getModel().getDialogChoiceList().setData(result);
            ArrayList<String> resultListHeaders = new ArrayList<String>();
            int i = 0;
            while (i < DialogChoiceListEditPanel.this.listHeaders.size()) {
                if (StringUtils.isNotBlank((String)((String)DialogChoiceListEditPanel.this.listHeaders.get(i)))) {
                    resultListHeaders.add((String)DialogChoiceListEditPanel.this.listHeaders.get(i));
                }
                ++i;
            }
            DialogChoiceListEditPanel.this.getModel().getDialogChoiceList().setHeaders(resultListHeaders);
            return ((List)inputElement).toArray();
        }

        public void dispose() {
        }
    }

    class ListLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        ListLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            DialogChoiceListDataModel entry = (DialogChoiceListDataModel)element;
            if (DialogChoiceListEditPanel.this.listHeaders.size() > columnIndex && StringUtils.isNotBlank((String)((String)DialogChoiceListEditPanel.this.listHeaders.get(columnIndex)))) {
                return entry.getField(columnIndex);
            }
            return null;
        }
    }

    class RemoveValueAction
    extends Action {
        public RemoveValueAction() {
            super("\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0432\u0430\u0440\u0438\u0430\u043d\u0442 \u0432\u044b\u0431\u043e\u0440\u0430", ArtixAdminImages.getDefault().getImageDescriptor("plane/16x16/delete"));
        }

        public void run() {
            StructuredSelection structuredSelection = (StructuredSelection)DialogChoiceListEditPanel.this.tableViewer.getSelection();
            DialogChoiceListDataModel entry = (DialogChoiceListDataModel)structuredSelection.getFirstElement();
            DialogChoiceListEditPanel.this.data.remove(entry);
            DialogChoiceListEditPanel.this.tableViewer.refresh();
        }
    }

    class UpValueAction
    extends Action {
        public UpValueAction() {
            super("\u041f\u0435\u0440\u0435\u043c\u0435\u0441\u0442\u0438\u0442\u044c \u0432\u0432\u0435\u0440\u0445", ArtixAdminImages.getDefault().getImageDescriptor("plane/16x16/up"));
        }

        public void run() {
            StructuredSelection structuredSelection = (StructuredSelection)DialogChoiceListEditPanel.this.tableViewer.getSelection();
            DialogChoiceListDataModel entry = (DialogChoiceListDataModel)structuredSelection.getFirstElement();
            int index = DialogChoiceListEditPanel.this.data.indexOf(entry);
            if (index > 0) {
                Collections.swap(DialogChoiceListEditPanel.this.data, index - 1, index);
                DialogChoiceListEditPanel.this.tableViewer.refresh();
            }
        }
    }
}

