/*
 * Decompiled with CFR 0.152.
 */
package ru.ssa.artixadmin.editors.directory.notes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import ru.ssa.artixadmin.editors.directory.notes.DialogInputMultiTextFieldEditDialog;
import ru.ssa.cashadmin.domain.dict.notes.DialogInputMultiTextField;
import ru.ssa.cashadmin.domain.dict.notes.DialogParamContainer;
import su.artix.cashserver.security.SecurityKey;
import su.artix.widgets.BitCheckGroup;
import su.artix.yuki.directory.Directory;
import su.artix.yuki.editors.EditorComposite;
import su.artix.yuki.images.ArtixAdminImages;

@SecurityKey(title="\u0414\u0438\u0430\u043b\u043e\u0433 \u0441 \u043c\u043d\u043e\u0433\u043e\u0441\u0442\u0440\u043e\u0447\u043d\u044b\u043c \u0432\u0432\u043e\u0434\u043e\u043c \u0434\u0430\u043d\u043d\u044b\u0445")
public class DialogInputMultiTextEditPanel
extends EditorComposite<DialogParamContainer> {
    @SecurityKey(title="\u0417\u0430\u0433\u043e\u043b\u043e\u0432\u043e\u043a", id="dialogInputMultiText.title")
    private Label titleLabel;
    @SecurityKey(id="dialogInputMultiText.title")
    private Text titleField;
    @SecurityKey(title="\u0421\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435", id="dialogInputMultiText.description")
    private Label descriptionLabel;
    @SecurityKey(id="dialogInputMultiText.description")
    private Text descriptionField;
    @SecurityKey(title="\u041f\u043e\u043a\u0430\u0437\u0430\u0442\u044c \u0434\u0438\u0430\u043b\u043e\u0433 \u043f\u043e\u043a\u0443\u043f\u0430\u0442\u0435\u043b\u044e (\u0434\u043b\u044f \u041a\u0421\u041e)", id="dialogInputMultiText.forCustomer")
    private Button forCustomer;
    @SecurityKey(title="\u0421\u043a\u0440\u044b\u0432\u0430\u0442\u044c \u043a\u043d\u043e\u043f\u043a\u0443 \u043e\u0442\u043c\u0435\u043d\u044b", id="dialogInputMultiText.hideCancelButton")
    private Button hideCancelButton;
    @SecurityKey(title="\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u0435 \u0446\u0438\u0444\u0440\u043e\u0432\u043e\u0439 \u043a\u043b\u0430\u0432\u0438\u0430\u0442\u0443\u0440\u044b \u0432 Touch", id="dialogInputMultiText.useDigitalKeyboard")
    private Button useDigitalKeyboard;
    @SecurityKey(title="\u0410\u0432\u0442\u043e\u043c\u0430\u0442\u0438\u0447\u0435\u0441\u043a\u0438 \u0432\u0435\u0440\u043d\u0443\u0442\u044c \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442 \u043f\u0440\u0438 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0438 \u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u044b\u0445 \u0434\u0430\u043d\u043d\u044b\u0445", id="dialogInputMultiText.returnOnValidScan")
    private Button returnOnValidScan;
    @SecurityKey(title="\u0420\u0430\u0437\u0440\u0435\u0448\u0435\u043d\u043d\u044b\u0435 \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u0430 \u0434\u043b\u044f \u0432\u0432\u043e\u0434\u0430", id="dialogInputMultiText.allowDevices")
    private BitCheckGroup allowDevices;
    private TableViewer tableViewer;
    private ToolBar toolbar;
    private List<DialogInputMultiTextField> fields = new ArrayList<DialogInputMultiTextField>();

    public DialogInputMultiTextEditPanel(Composite parent, int style, DialogParamContainer model) {
        super(parent, style, DialogParamContainer.class, (Object)model);
        if (model.getDialogInputMultiText() != null && model.getDialogInputMultiText().getFields() != null) {
            this.fields = model.getDialogInputMultiText().getFields();
        }
    }

    public void initialize() {
        GridLayoutFactory.swtDefaults().margins(0, 0).numColumns(2).applyTo((Composite)this);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)this);
        this.titleLabel = new Label((Composite)this, 0);
        this.titleLabel.setText("\u0417\u0430\u0433\u043e\u043b\u043e\u0432\u043e\u043a:");
        this.titleField = new Text((Composite)this, 2048);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)this.titleField);
        this.descriptionLabel = new Label((Composite)this, 0);
        this.descriptionLabel.setText("\u0421\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435:");
        this.descriptionField = new Text((Composite)this, 2048);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)this.descriptionField);
        this.forCustomer = new Button((Composite)this, 32);
        this.forCustomer.setText("\u041f\u043e\u043a\u0430\u0437\u0430\u0442\u044c \u0434\u0438\u0430\u043b\u043e\u0433 \u043f\u043e\u043a\u0443\u043f\u0430\u0442\u0435\u043b\u044e (\u0434\u043b\u044f \u041a\u0421\u041e)");
        GridDataFactory.fillDefaults().span(2, 1).grab(true, false).applyTo((Control)this.forCustomer);
        this.hideCancelButton = new Button((Composite)this, 32);
        this.hideCancelButton.setText("\u0421\u043a\u0440\u044b\u0432\u0430\u0442\u044c \u043a\u043d\u043e\u043f\u043a\u0443 \u043e\u0442\u043c\u0435\u043d\u044b");
        GridDataFactory.fillDefaults().span(2, 1).grab(true, false).applyTo((Control)this.hideCancelButton);
        this.useDigitalKeyboard = new Button((Composite)this, 32);
        this.useDigitalKeyboard.setText("\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u0435 \u0446\u0438\u0444\u0440\u043e\u0432\u043e\u0439 \u043a\u043b\u0430\u0432\u0438\u0430\u0442\u0443\u0440\u044b \u0432 Touch");
        GridDataFactory.fillDefaults().span(2, 1).grab(true, false).applyTo((Control)this.useDigitalKeyboard);
        this.returnOnValidScan = new Button((Composite)this, 32);
        this.returnOnValidScan.setText("\u0410\u0432\u0442\u043e\u043c\u0430\u0442\u0438\u0447\u0435\u0441\u043a\u0438 \u0432\u0435\u0440\u043d\u0443\u0442\u044c \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442 \u043f\u0440\u0438 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0438 \u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u044b\u0445 \u0434\u0430\u043d\u043d\u044b\u0445");
        GridDataFactory.fillDefaults().span(2, 1).grab(true, false).applyTo((Control)this.returnOnValidScan);
        Group allowDevicesGroup = new Group((Composite)this, 0);
        allowDevicesGroup.setText("\u0420\u0430\u0437\u0440\u0435\u0448\u0435\u043d\u043d\u044b\u0435 \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u0430 \u0434\u043b\u044f \u0432\u0432\u043e\u0434\u0430");
        GridLayoutFactory.swtDefaults().applyTo((Composite)allowDevicesGroup);
        GridDataFactory.fillDefaults().span(2, 1).grab(true, false).applyTo((Control)allowDevicesGroup);
        this.allowDevices = new BitCheckGroup((Composite)allowDevicesGroup, 0, Directory.noteAllowDevices);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.allowDevices);
        Group choicesGroup = new Group((Composite)this, 0);
        choicesGroup.setText("\u041f\u043e\u043b\u044f \u0432\u0432\u043e\u0434\u0430 \u0434\u0430\u043d\u043d\u044b\u0445");
        GridLayoutFactory.swtDefaults().applyTo((Composite)choicesGroup);
        GridDataFactory.fillDefaults().span(2, 1).grab(true, true).applyTo((Control)choicesGroup);
        this.toolbar = new ToolBar((Composite)choicesGroup, 0x800000);
        ToolBarManager toolBarManager = new ToolBarManager(this.toolbar);
        toolBarManager.add((IAction)new AddValueAction());
        final EditValueAction editValueAction = new EditValueAction();
        toolBarManager.add((IAction)editValueAction);
        final RemoveValueAction removeValueAction = new RemoveValueAction();
        toolBarManager.add((IAction)removeValueAction);
        final DownValueAction downValueAction = new DownValueAction();
        toolBarManager.add((IAction)downValueAction);
        final UpValueAction upValueAction = new UpValueAction();
        toolBarManager.add((IAction)upValueAction);
        toolBarManager.update(true);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.toolbar);
        this.tableViewer = new TableViewer((Composite)choicesGroup, 68352);
        this.tableViewer.setContentProvider((IContentProvider)new ListContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new ListLabelProvider());
        this.tableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                new EditValueAction().run();
            }
        });
        TableLayout tableLayout = new TableLayout();
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(55, 55, true));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(120, 120, true));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(65, 65, true));
        this.tableViewer.getTable().setLayout((Layout)tableLayout);
        this.tableViewer.getTable().setLinesVisible(true);
        this.tableViewer.getTable().setHeaderVisible(true);
        boolean enableEditAndRemove = !this.tableViewer.getSelection().isEmpty();
        editValueAction.setEnabled(enableEditAndRemove);
        removeValueAction.setEnabled(enableEditAndRemove);
        downValueAction.setEnabled(enableEditAndRemove);
        upValueAction.setEnabled(enableEditAndRemove);
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                boolean enableEditAndRemove = !event.getSelection().isEmpty();
                editValueAction.setEnabled(enableEditAndRemove);
                removeValueAction.setEnabled(enableEditAndRemove);
                downValueAction.setEnabled(enableEditAndRemove);
                upValueAction.setEnabled(enableEditAndRemove);
            }
        });
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.tableViewer.getTable());
        TableColumn valueColumn1 = new TableColumn(this.tableViewer.getTable(), 16384);
        valueColumn1.setText("\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440");
        TableColumn valueColumn2 = new TableColumn(this.tableViewer.getTable(), 16384);
        valueColumn2.setText("\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435");
        TableColumn valueColumn3 = new TableColumn(this.tableViewer.getTable(), 16384);
        valueColumn3.setText("\u0422\u0438\u043f");
        this.tableViewer.setInput(this.fields);
    }

    protected DialogParamContainer getActualModel(DialogParamContainer model) {
        return model;
    }

    public void bindValues() {
        this.initDefaulBinding();
    }

    public DialogParamContainer getModel() {
        return (DialogParamContainer)super.getModel();
    }

    private class AddValueAction
    extends Action {
        public AddValueAction() {
            super("\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u043f\u043e\u043b\u0435 \u0432\u0432\u043e\u0434\u0430 \u0434\u0430\u043d\u043d\u044b\u0445", ArtixAdminImages.getDefault().getImageDescriptor("plane/16x16/add"));
        }

        public void run() {
            DialogInputMultiTextFieldEditDialog dialog = new DialogInputMultiTextFieldEditDialog(new DialogInputMultiTextField());
            if (dialog.open() == 0) {
                DialogInputMultiTextEditPanel.this.fields.add(dialog.getDialogInputMultiTextField());
                DialogInputMultiTextEditPanel.this.tableViewer.refresh();
            }
        }
    }

    class DownValueAction
    extends Action {
        public DownValueAction() {
            super("\u041f\u0435\u0440\u0435\u043c\u0435\u0441\u0442\u0438\u0442\u044c \u0432\u043d\u0438\u0437", ArtixAdminImages.getDefault().getImageDescriptor("plane/16x16/down"));
        }

        public void run() {
            StructuredSelection structuredSelection = (StructuredSelection)DialogInputMultiTextEditPanel.this.tableViewer.getSelection();
            DialogInputMultiTextField entry = (DialogInputMultiTextField)structuredSelection.getFirstElement();
            int index = DialogInputMultiTextEditPanel.this.fields.indexOf(entry);
            if (index < DialogInputMultiTextEditPanel.this.fields.size()) {
                Collections.swap(DialogInputMultiTextEditPanel.this.fields, index, index + 1);
                DialogInputMultiTextEditPanel.this.tableViewer.refresh();
            }
        }
    }

    private class EditValueAction
    extends Action {
        public EditValueAction() {
            super("\u0418\u0437\u043c\u0435\u043d\u0438\u0442\u044c \u043f\u043e\u043b\u0435 \u0432\u0432\u043e\u0434\u0430 \u0434\u0430\u043d\u043d\u044b\u0445", ArtixAdminImages.getDefault().getImageDescriptor("plane/16x16/edit"));
        }

        public void run() {
            StructuredSelection structuredSelection = (StructuredSelection)DialogInputMultiTextEditPanel.this.tableViewer.getSelection();
            DialogInputMultiTextField entry = (DialogInputMultiTextField)structuredSelection.getFirstElement();
            DialogInputMultiTextFieldEditDialog dialog = new DialogInputMultiTextFieldEditDialog(entry);
            if (dialog.open() == 0) {
                int index = DialogInputMultiTextEditPanel.this.fields.indexOf(entry);
                DialogInputMultiTextEditPanel.this.fields.set(index, dialog.getDialogInputMultiTextField());
                DialogInputMultiTextEditPanel.this.tableViewer.refresh();
            }
        }
    }

    class ListContentProvider
    implements IStructuredContentProvider {
        ListContentProvider() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            viewer.refresh();
        }

        public Object[] getElements(Object inputElement) {
            DialogInputMultiTextEditPanel.this.getModel().getDialogInputMultiText().setFields(DialogInputMultiTextEditPanel.this.fields);
            return ((List)inputElement).toArray();
        }

        public void dispose() {
        }
    }

    class ListLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        ListLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            DialogInputMultiTextField entry = (DialogInputMultiTextField)element;
            switch (columnIndex) {
                case 0: {
                    return entry.getFieldId();
                }
                case 1: {
                    return entry.getDescription();
                }
                case 2: {
                    return Directory.notesDialogInputMultiTextFieldType.getDisplayValue((Object)entry.getType());
                }
            }
            return null;
        }
    }

    class RemoveValueAction
    extends Action {
        public RemoveValueAction() {
            super("\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u043f\u043e\u043b\u0435 \u0432\u0432\u043e\u0434\u0430 \u0434\u0430\u043d\u043d\u044b\u0445", ArtixAdminImages.getDefault().getImageDescriptor("plane/16x16/delete"));
        }

        public void run() {
            StructuredSelection structuredSelection = (StructuredSelection)DialogInputMultiTextEditPanel.this.tableViewer.getSelection();
            DialogInputMultiTextField entry = (DialogInputMultiTextField)structuredSelection.getFirstElement();
            DialogInputMultiTextEditPanel.this.fields.remove(entry);
            DialogInputMultiTextEditPanel.this.tableViewer.refresh();
        }
    }

    class UpValueAction
    extends Action {
        public UpValueAction() {
            super("\u041f\u0435\u0440\u0435\u043c\u0435\u0441\u0442\u0438\u0442\u044c \u0432\u0432\u0435\u0440\u0445", ArtixAdminImages.getDefault().getImageDescriptor("plane/16x16/up"));
        }

        public void run() {
            StructuredSelection structuredSelection = (StructuredSelection)DialogInputMultiTextEditPanel.this.tableViewer.getSelection();
            DialogInputMultiTextField entry = (DialogInputMultiTextField)structuredSelection.getFirstElement();
            int index = DialogInputMultiTextEditPanel.this.fields.indexOf(entry);
            if (index > 0) {
                Collections.swap(DialogInputMultiTextEditPanel.this.fields, index - 1, index);
                DialogInputMultiTextEditPanel.this.tableViewer.refresh();
            }
        }
    }
}

