/*
 * Decompiled with CFR 0.152.
 */
package ru.ssa.artixadmin.provider.goods;

import java.util.Collections;
import java.util.List;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.ssa.cashadmin.dao.SessionManager;
import ru.ssa.cashadmin.domain.InventGroup;
import su.artix.yuki.model.ModelActivator;

public class GroupTreeContentProvider
implements ITreeContentProvider {
    private final Class<?> cl;
    private static final Logger log = LoggerFactory.getLogger(GroupTreeContentProvider.class);

    public GroupTreeContentProvider(Class<?> cl) {
        this.cl = cl;
    }

    public Object[] getChildren(Object parentElement) {
        log.trace("parentElement={}", parentElement);
        SessionManager.openSession(InventGroup.class);
        InventGroup parent = (InventGroup)parentElement;
        List<InventGroup> children = Collections.emptyList();
        for (InventGroup group : children) {
            group.setParent(parent);
        }
        SessionManager.closeSession(InventGroup.class);
        return children.toArray();
    }

    public Object getParent(Object element) {
        log.trace("getParent");
        return ((InventGroup)element).getParent();
    }

    public boolean hasChildren(Object element) {
        log.trace("hasChildren");
        return this.getChildren(element).length > 0;
    }

    public Object[] getElements(Object inputElement) {
        log.trace("getElements");
        return ModelActivator.getDefault().getModelProvider().getDirectoryModel(this.cl).findByHSQL("from InventGroup where parentgroupcode is null or parentgroupcode=0", null).toArray();
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        log.trace("input changed");
        viewer.refresh();
    }
}

