/*
 * Decompiled with CFR 0.152.
 */
package ru.ssa.artixadmin.view.document;

import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbenchPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.ssa.artixadmin.ArtixAdminActivator;
import ru.ssa.artixadmin.view.document.ClientTableView;
import ru.ssa.artixadmin.view.document.DocumentTableView;
import ru.ssa.artixadmin.view.document.OrganizationViewPanel;
import ru.ssa.artixadmin.view.document.WorkshiftTableView;
import ru.ssa.cashadmin.domain.docs.Client;
import ru.ssa.cashadmin.domain.docs.ClientServerV195;
import ru.ssa.cashadmin.domain.docs.ClientV172;
import ru.ssa.cashadmin.domain.docs.Organization;
import ru.ssa.cashadmin.utils.FilterRestriction;
import su.artix.cashserver.security.SecurityKey;
import su.artix.yuki.action.DirectoryEditActionGroup;
import su.artix.yuki.provider.LazyContentProvider;
import su.artix.yuki.provider.PojoTableLabelProvider;
import su.artix.yuki.view.DirectoryTableView;
import su.artix.yuki.view.DirectoryViewPanel;

@SecurityKey(title="\u0414\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u044b. \u0414\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u044b. \u041e\u0440\u0433\u0430\u043d\u0438\u0437\u0430\u0446\u0438\u0438 \u043a\u043b\u0438\u0435\u043d\u0442\u043e\u0432")
public class OrganizationTableView
extends DirectoryTableView<Organization> {
    public static final String ID = "ru.ssa.artixadmin.view.document.OrganizationTableView";
    private static final Logger log = LoggerFactory.getLogger(OrganizationTableView.class);
    private boolean firstInitial = true;

    public void createPartControl(Composite parent) {
        this.setPojoClass(Organization.class);
        this.setViewPanel((DirectoryViewPanel)new OrganizationViewPanel(parent, 0, true));
        this.getSite().setSelectionProvider((ISelectionProvider)this.getViewer());
        ((TableViewer)this.getViewer()).setContentProvider((IContentProvider)new LazyContentProvider(Organization.class, (TableViewer)this.getViewer()));
        ((TableViewer)this.getViewer()).setLabelProvider((IBaseLabelProvider)new PojoTableLabelProvider(this.getColumns(), false));
        this.commonActionGroup = new DirectoryEditActionGroup(Organization.class).removeAction(new String[]{"ru.ssa.artixadmin.action.DirectoryAddAction", "ru.ssa.artixadmin.action.DirectoryEditAction", "ru.ssa.artixadmin.action.DirectoryCopyAction"});
        this.commonActionGroup.fillActionBars(this.getViewSite().getActionBars());
        this.commonActionGroup.setEnabledEditGroupActions(Boolean.valueOf(false));
        super.createPartControl(parent);
        this.restoreState();
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selectionIn) {
        if (selectionIn.isEmpty() && this.firstInitial) {
            ISelection selectionTemp = part.getSite().getPage().getSelection("ru.ssa.artixadmin.view.document.GoodsItemTableView");
            if (selectionTemp == null) {
                selectionTemp = part.getSite().getPage().getSelection("ru.ssa.artixadmin.view.document.StornoGoodsItemTableView");
            }
            selectionIn = selectionTemp == null ? selectionIn : selectionTemp;
        }
        log.trace("selectionChanged part {} selection {}", (Object)part, (Object)selectionIn);
        IStructuredSelection selection = (IStructuredSelection)selectionIn;
        if (part instanceof ClientTableView || selectionIn != null && !selectionIn.isEmpty() && this.firstInitial) {
            if (selection.size() == 1 && selection.getFirstElement() instanceof Client) {
                Integer organizationId = null;
                if (ArtixAdminActivator.getDefault().isCashServer()) {
                    ClientServerV195 client = (ClientServerV195)selection.getFirstElement();
                    organizationId = client.getOrganizationId();
                } else {
                    ClientV172 client = (ClientV172)selection.getFirstElement();
                    organizationId = client.getOrganizationId();
                }
                organizationId = organizationId == null ? -1 : organizationId;
                this.getViewPanel().getFilter().clearAll();
                this.getViewPanel().getFilter().add(new FilterRestriction("organizationId", (Object)organizationId, FilterRestriction.LinkCondition.unique, FilterRestriction.Condition.eq, Boolean.valueOf(true)));
                ((TableViewer)this.getViewPanel().getViewer()).setInput((Object)this.getViewPanel().getFilter());
            }
        } else if (part instanceof DocumentTableView || part instanceof WorkshiftTableView) {
            this.getViewPanel().getFilter().clearAll();
            this.getViewPanel().getFilter().add(new FilterRestriction("organizationId", (Object)-1, FilterRestriction.LinkCondition.unique, FilterRestriction.Condition.eq, Boolean.valueOf(true)));
            ((TableViewer)this.getViewPanel().getViewer()).setInput((Object)this.getViewPanel().getFilter());
        }
        this.firstInitial = false;
    }

    protected String getID() {
        return ID;
    }
}

