/*
 * Decompiled with CFR 0.152.
 */
package ru.ssa.artixadmin.view.document;

import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbenchPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.ssa.artixadmin.view.document.DocumentTableView;
import ru.ssa.artixadmin.view.document.GoodsItemTableView;
import ru.ssa.artixadmin.view.document.PaymentItemViewPanel;
import ru.ssa.artixadmin.view.document.StornoGoodsItemTableView;
import ru.ssa.artixadmin.view.document.WorkshiftTableView;
import ru.ssa.cashadmin.LibActivator;
import ru.ssa.cashadmin.domain.docs.Goodsitem;
import ru.ssa.cashadmin.domain.docs.Paymentitem;
import ru.ssa.cashadmin.domain.docs.Stornogoodsitem;
import su.artix.cashserver.security.SecurityKey;
import su.artix.yuki.action.DirectoryEditActionGroup;
import su.artix.yuki.provider.LazyContentProvider;
import su.artix.yuki.provider.PojoTableLabelProvider;
import su.artix.yuki.view.DirectoryTableView;
import su.artix.yuki.view.DirectoryViewPanel;

@SecurityKey(title="\u0414\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u044b. \u0414\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u044b. \u041f\u043b\u0430\u0442\u0435\u0436\u0438")
public class PaymentItemTableView
extends DirectoryTableView<Paymentitem> {
    public static final String ID = "ru.ssa.artixadmin.view.document.PaymentItemTableView";
    private static final Logger log = LoggerFactory.getLogger(PaymentItemTableView.class);
    private boolean firstInitial = true;

    public void createPartControl(Composite parent) {
        this.setPojoClass(Paymentitem.class);
        this.setViewPanel((DirectoryViewPanel)new PaymentItemViewPanel(parent, 0, true));
        this.getSite().setSelectionProvider((ISelectionProvider)this.getViewer());
        ((TableViewer)this.getViewer()).setContentProvider((IContentProvider)new LazyContentProvider(Paymentitem.class, (TableViewer)this.getViewer()));
        ((TableViewer)this.getViewer()).setLabelProvider((IBaseLabelProvider)new PojoTableLabelProvider(this.getColumns(), false));
        this.commonActionGroup = new DirectoryEditActionGroup(Paymentitem.class).removeAction(new String[]{"ru.ssa.artixadmin.action.DirectoryAddAction", "ru.ssa.artixadmin.action.DirectoryEditAction", "ru.ssa.artixadmin.action.DirectoryCopyAction"});
        this.commonActionGroup.fillActionBars(this.getViewSite().getActionBars());
        this.commonActionGroup.setEnabledEditGroupActions(Boolean.valueOf(false));
        super.createPartControl(parent);
        this.restoreState();
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selectionIn) {
        if (selectionIn.isEmpty() && this.firstInitial) {
            ISelection selectionTemp = part.getSite().getPage().getSelection("ru.ssa.artixadmin.view.document.GoodsItemTableView");
            if (selectionTemp == null) {
                selectionTemp = part.getSite().getPage().getSelection("ru.ssa.artixadmin.view.document.StornoGoodsItemTableView");
            }
            selectionIn = selectionTemp == null ? selectionIn : selectionTemp;
        }
        log.trace("selectionChanged part {} selection {}", (Object)part, (Object)selectionIn);
        IStructuredSelection selection = (IStructuredSelection)selectionIn;
        if (part instanceof GoodsItemTableView || selectionIn != null && !selectionIn.isEmpty() && this.firstInitial) {
            if (selection.size() == 1 && selection.getFirstElement() instanceof Goodsitem) {
                Paymentitem paymentitem = (Paymentitem)LibActivator.getDefault().getActualClassResolver().getInstance(Paymentitem.class);
                Goodsitem goodsitem = (Goodsitem)selection.getFirstElement();
                Integer paymentItemId = goodsitem.getPaymentitemid();
                paymentItemId = paymentItemId == null ? -1 : paymentItemId;
                paymentitem.setPaymentitemidFilter(paymentItemId);
                paymentitem.setCashcode(goodsitem.getCashcode());
                this.getViewPanel().setInput((Object)paymentitem);
            }
        } else if (part instanceof StornoGoodsItemTableView || !selectionIn.isEmpty() && this.firstInitial) {
            if (selection.size() == 1 && selection.getFirstElement() instanceof Stornogoodsitem) {
                Paymentitem paymentitem = (Paymentitem)LibActivator.getDefault().getActualClassResolver().getInstance(Paymentitem.class);
                Stornogoodsitem stornogoodsitem = (Stornogoodsitem)selection.getFirstElement();
                Integer paymentItemId = stornogoodsitem.getPaymentitemid();
                paymentItemId = paymentItemId == null ? -1 : paymentItemId;
                paymentitem.setPaymentitemidFilter(paymentItemId);
                paymentitem.setCashcode(stornogoodsitem.getCashcode());
                paymentitem.setPaymentitemid(paymentItemId);
                this.getViewPanel().setInput((Object)paymentitem);
            }
        } else if (part instanceof DocumentTableView || part instanceof WorkshiftTableView) {
            Paymentitem paymentitem = (Paymentitem)LibActivator.getDefault().getActualClassResolver().getInstance(Paymentitem.class);
            paymentitem.setPaymentitemidFilter(Integer.valueOf(-1));
            this.getViewPanel().setInput((Object)paymentitem);
        }
        this.firstInitial = false;
    }

    protected String getID() {
        return ID;
    }
}

