/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.transforms.implementations;

import com.sun.org.apache.xml.internal.security.c14n.CanonicalizationException;
import com.sun.org.apache.xml.internal.security.signature.XMLSignatureInput;
import com.sun.org.apache.xml.internal.security.transforms.Transform;
import com.sun.org.apache.xml.internal.security.transforms.TransformSpi;
import com.sun.org.apache.xml.internal.security.transforms.TransformationException;
import com.sun.org.apache.xml.internal.security.utils.JavaUtils;
import com.sun.org.apache.xml.internal.security.utils.XMLUtils;
import java.io.IOException;
import java.io.OutputStream;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class TransformBase64Decode
extends TransformSpi {
    public static final String implementedTransformURI = "http://www.w3.org/2000/09/xmldsig#base64";

    @Override
    protected String engineGetURI() {
        return implementedTransformURI;
    }

    @Override
    protected XMLSignatureInput enginePerformTransform(XMLSignatureInput xMLSignatureInput, Transform transform) throws IOException, CanonicalizationException, TransformationException {
        return this.enginePerformTransform(xMLSignatureInput, null, transform);
    }

    @Override
    protected XMLSignatureInput enginePerformTransform(XMLSignatureInput xMLSignatureInput, OutputStream outputStream, Transform transform) throws IOException, CanonicalizationException, TransformationException {
        if (xMLSignatureInput.isElement()) {
            Node node = xMLSignatureInput.getSubNode();
            if (xMLSignatureInput.getSubNode().getNodeType() == 3) {
                node = node.getParentNode();
            }
            StringBuilder stringBuilder = new StringBuilder();
            this.traverseElement((Element)node, stringBuilder);
            if (outputStream == null) {
                byte[] byArray = XMLUtils.decode(stringBuilder.toString());
                XMLSignatureInput xMLSignatureInput2 = new XMLSignatureInput(byArray);
                xMLSignatureInput2.setSecureValidation(this.secureValidation);
                return xMLSignatureInput2;
            }
            byte[] byArray = XMLUtils.decode(stringBuilder.toString());
            outputStream.write(byArray);
            XMLSignatureInput xMLSignatureInput3 = new XMLSignatureInput((byte[])null);
            xMLSignatureInput3.setSecureValidation(this.secureValidation);
            xMLSignatureInput3.setOutputStream(outputStream);
            return xMLSignatureInput3;
        }
        if (xMLSignatureInput.isOctetStream() || xMLSignatureInput.isNodeSet()) {
            Object object;
            if (outputStream == null) {
                byte[] byArray = xMLSignatureInput.getBytes();
                byte[] byArray2 = XMLUtils.decode(byArray);
                XMLSignatureInput xMLSignatureInput4 = new XMLSignatureInput(byArray2);
                xMLSignatureInput4.setSecureValidation(this.secureValidation);
                return xMLSignatureInput4;
            }
            if (xMLSignatureInput.isByteArray() || xMLSignatureInput.isNodeSet()) {
                object = XMLUtils.decode(xMLSignatureInput.getBytes());
                outputStream.write((byte[])object);
            } else {
                object = JavaUtils.getBytesFromStream(xMLSignatureInput.getOctetStreamReal());
                byte[] byArray = XMLUtils.decode((byte[])object);
                outputStream.write(byArray);
            }
            object = new XMLSignatureInput((byte[])null);
            ((XMLSignatureInput)object).setSecureValidation(this.secureValidation);
            ((XMLSignatureInput)object).setOutputStream(outputStream);
            return object;
        }
        try {
            Document document = XMLUtils.read(xMLSignatureInput.getOctetStream(), this.secureValidation);
            Element element = document.getDocumentElement();
            StringBuilder stringBuilder = new StringBuilder();
            this.traverseElement(element, stringBuilder);
            byte[] byArray = XMLUtils.decode(stringBuilder.toString());
            XMLSignatureInput xMLSignatureInput5 = new XMLSignatureInput(byArray);
            xMLSignatureInput5.setSecureValidation(this.secureValidation);
            return xMLSignatureInput5;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new TransformationException(parserConfigurationException, "c14n.Canonicalizer.Exception");
        }
        catch (SAXException sAXException) {
            throw new TransformationException(sAXException, "SAX exception");
        }
    }

    void traverseElement(Element element, StringBuilder stringBuilder) {
        block4: for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            switch (node.getNodeType()) {
                case 1: {
                    this.traverseElement((Element)node, stringBuilder);
                    continue block4;
                }
                case 3: {
                    stringBuilder.append(((Text)node).getData());
                }
            }
        }
    }
}

