/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cache.ehcache;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.config.Configuration;
import net.sf.ehcache.config.ConfigurationFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.Resource;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EhCacheManagerFactoryBean
implements FactoryBean<CacheManager>,
InitializingBean,
DisposableBean {
    private static final Method createWithConfiguration = ClassUtils.getMethodIfAvailable(CacheManager.class, (String)"create", (Class[])new Class[]{Configuration.class});
    protected final Log logger = LogFactory.getLog(this.getClass());
    private Resource configLocation;
    private boolean shared = false;
    private String cacheManagerName;
    private CacheManager cacheManager;

    public void setConfigLocation(Resource configLocation) {
        this.configLocation = configLocation;
    }

    public void setShared(boolean shared) {
        this.shared = shared;
    }

    public void setCacheManagerName(String cacheManagerName) {
        this.cacheManagerName = cacheManagerName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterPropertiesSet() throws IOException, CacheException {
        this.logger.info((Object)"Initializing EHCache CacheManager");
        InputStream is = this.configLocation != null ? this.configLocation.getInputStream() : null;
        try {
            if (this.cacheManagerName != null) {
                if (this.shared && createWithConfiguration == null) {
                    this.cacheManager = is != null ? CacheManager.create((InputStream)is) : CacheManager.create();
                    this.cacheManager.setName(this.cacheManagerName);
                } else {
                    Configuration configuration = is != null ? ConfigurationFactory.parseConfiguration((InputStream)is) : ConfigurationFactory.parseConfiguration();
                    configuration.setName(this.cacheManagerName);
                    this.cacheManager = this.shared ? (CacheManager)ReflectionUtils.invokeMethod((Method)createWithConfiguration, null, (Object[])new Object[]{configuration}) : new CacheManager(configuration);
                }
            } else {
                this.cacheManager = this.shared ? (is != null ? CacheManager.create((InputStream)is) : CacheManager.create()) : (is != null ? new CacheManager(is) : new CacheManager());
            }
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }

    public CacheManager getObject() {
        return this.cacheManager;
    }

    public Class<? extends CacheManager> getObjectType() {
        return this.cacheManager != null ? this.cacheManager.getClass() : CacheManager.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void destroy() {
        this.logger.info((Object)"Shutting down EHCache CacheManager");
        this.cacheManager.shutdown();
    }
}

