/*
 * Decompiled with CFR 0.152.
 */
package su.artix.artixadmin.format;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum ArtixFormatter {
    INSTANCE;

    private static final Logger log;
    private String formatDate = "dd/MM/yyyy";
    private String formatTime = "HH:mm:ss";
    private String formatTimestamp = "dd/MM/yyyy HH:mm:ss";
    private static final Locale LOCALE;
    private DateFormat myDateFormat = new SimpleDateFormat(this.formatDate);
    private DateFormat myTimeFormat = new SimpleDateFormat(this.formatTime);
    private DateFormat myTimestampFormat = new SimpleDateFormat(this.formatTimestamp);

    static {
        log = LoggerFactory.getLogger(ArtixFormatter.class);
        LOCALE = Locale.getDefault();
    }

    public String dateToString(Date date) {
        this.myDateFormat = new SimpleDateFormat(this.formatDate, LOCALE);
        String temp = "";
        if (date != null) {
            temp = this.myDateFormat.format(date);
        }
        return temp;
    }

    public String timeToString(Date date) {
        this.myTimeFormat = new SimpleDateFormat(this.formatTime, LOCALE);
        String temp = "";
        if (date != null) {
            temp = this.myTimeFormat.format(date);
        }
        return temp;
    }

    public String timestampToString(Date date) {
        this.myTimestampFormat = new SimpleDateFormat(this.formatTimestamp, LOCALE);
        String temp = "";
        if (date != null) {
            temp = this.myTimestampFormat.format(date);
        }
        return temp;
    }

    public Date stringToDate(String source) {
        this.myDateFormat = new SimpleDateFormat(this.formatDate, LOCALE);
        Date temp = null;
        if (source != null && !source.isEmpty()) {
            try {
                temp = this.myDateFormat.parse(source);
            }
            catch (ParseException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        return temp;
    }

    public Date stringToTime(String source) {
        this.myTimeFormat = new SimpleDateFormat(this.formatTime, LOCALE);
        Date temp = null;
        if (source != null && !source.isEmpty()) {
            try {
                temp = this.myTimeFormat.parse(source);
            }
            catch (ParseException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        return temp;
    }

    public Date stringToTimestamp(String source) {
        this.myTimestampFormat = new SimpleDateFormat(this.formatTimestamp, LOCALE);
        Date temp = null;
        if (source != null && !source.isEmpty()) {
            try {
                temp = this.myTimestampFormat.parse(source);
            }
            catch (ParseException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        return temp;
    }

    public String decimalToString(BigDecimal val, int digit) {
        String temp = "";
        if (val != null) {
            return String.valueOf(val.setScale(digit, 1));
        }
        return temp;
    }

    public String decimalToString(BigDecimal val) {
        String temp = "";
        if (val != null) {
            temp = String.valueOf(val.doubleValue());
        }
        return temp;
    }

    public String integerToString(BigInteger val) {
        String temp = "";
        if (val != null) {
            temp = String.valueOf(val.intValue());
        }
        return temp;
    }

    public String bitmaskToString(Integer val, Integer size) {
        String temp = "";
        if (val != null) {
            String binary = Integer.toBinaryString(val);
            String s = "";
            int delta = size - binary.length();
            if (delta > 0) {
                s = String.format("%0" + delta + "d", 0);
            }
            temp = String.valueOf(s) + binary;
        }
        return temp;
    }

    public String toSex(Boolean value, boolean maleFirst) {
        String val = "";
        val = value == null ? "\u043d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d" : (maleFirst ? (value != false ? "\u043c\u0443\u0436\u0447\u0438\u043d\u0430" : "\u0436\u0435\u043d\u0449\u0438\u043d\u0430") : (value != false ? "\u0436\u0435\u043d\u0449\u0438\u043d\u0430" : "\u043c\u0443\u0436\u0447\u0438\u043d\u0430"));
        return val;
    }

    public String toSex(Integer value) {
        String val = "";
        val = value != null ? this.toSex(value == 0, true) : this.toSex(null, true);
        return val;
    }
}

