/*
 * Decompiled with CFR 0.152.
 */
package su.artix.cashserver.rest.client.entities;

import java.util.ArrayList;
import java.util.List;
import org.springframework.core.ParameterizedTypeReference;
import su.artix.cashserver.core.cashregistry.domain.SecurityPermission;
import su.artix.cashserver.core.cashregistry.domain.SecurityRole;
import su.artix.cashserver.rest.client.RestInvoker;
import su.artix.cashserver.rest.client.RestInvokerManager;
import su.artix.cashserver.rest.domain.SecurityRoleInfo;

public class SecurityRolesRestClient {
    private static final String SECURITY_ROLES_URL = "securityRoles";
    private final RestInvokerManager restInvokerManager;

    public SecurityRolesRestClient(RestInvokerManager restInvokerManager) {
        this.restInvokerManager = restInvokerManager;
    }

    private static SecurityRoleInfo convertSecurityRoleToSecurityRoleInfo(SecurityRole securityRole) {
        SecurityRoleInfo info = new SecurityRoleInfo();
        info.setName(securityRole.getRoleName());
        info.setSecurityPermissionIds(new ArrayList());
        for (SecurityPermission permission : securityRole.getPermissions()) {
            info.getSecurityPermissionIds().add(permission.getId());
        }
        return info;
    }

    public Long countSecurityRoles() {
        return this.restInvokerManager.getRestInvoker().invokeGet("securityRoles/count", Long.class);
    }

    public Boolean existsSecurityRole(String roleName) {
        return this.restInvokerManager.getRestInvoker().invokeGet(RestInvoker.urlBuild("securityRoles/{0}/exists", roleName), Boolean.class);
    }

    public List<SecurityRole> getSecurityRoles() {
        ParameterizedTypeReference<List<SecurityRole>> returnTypeRef = new ParameterizedTypeReference<List<SecurityRole>>(){};
        return this.restInvokerManager.getRestInvoker().invokeGet(SECURITY_ROLES_URL, returnTypeRef);
    }

    public void addSecurityRole(SecurityRole securityRole) {
        this.restInvokerManager.getRestInvoker().invokePost(SECURITY_ROLES_URL, SecurityRolesRestClient.convertSecurityRoleToSecurityRoleInfo(securityRole));
    }

    public SecurityRole getSecurityRole(String roleName) {
        return this.restInvokerManager.getRestInvoker().invokeGet(RestInvoker.urlBuild("securityRoles/{0}", roleName), SecurityRole.class);
    }

    public void updateSecurityRole(String roleName, SecurityRole securityRole) {
        this.restInvokerManager.getRestInvoker().invokePut(RestInvoker.urlBuild("securityRoles/{0}", roleName), SecurityRolesRestClient.convertSecurityRoleToSecurityRoleInfo(securityRole));
    }

    public void removeSecurityRole(String roleName) {
        this.restInvokerManager.getRestInvoker().invokeDelete(RestInvoker.urlBuild("securityRoles/{0}", roleName));
    }
}

