/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.ganttchart;

import org.eclipse.nebula.widgets.ganttchart.GanttChart;
import org.eclipse.nebula.widgets.ganttchart.GanttHeaderSpacedLayout;
import org.eclipse.nebula.widgets.ganttchart.IColorManager;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

public class GanttControlParent
extends Composite
implements PaintListener {
    private GanttChart __ganttChart;
    private GanttHeaderSpacedLayout _layout = new GanttHeaderSpacedLayout();

    public GanttControlParent(Composite parent, int style) {
        super(parent, style);
        this.init();
    }

    public GanttControlParent(Composite parent, int style, GanttChart chart) {
        super(parent, style);
        this.__ganttChart = chart;
        this.init();
    }

    private void init() {
        this.addPaintListener(this);
        this.setLayout(this._layout);
    }

    public void setGanttChart(GanttChart chart) {
        this.__ganttChart = chart;
        this._layout.setGanttChart(chart);
    }

    public GanttChart getGanttChart() {
        return this.__ganttChart;
    }

    public void paintControl(PaintEvent e) {
        GC gc = e.gc;
        Rectangle bounds = this.getBounds();
        if (this.__ganttChart != null) {
            IColorManager colorManager = this.__ganttChart.getColorManager();
            gc.setForeground(colorManager.getWeekdayBackgroundColorTop());
            gc.setBackground(colorManager.getWeekdayBackgroundColorBottom());
            gc.fillGradientRectangle(0, 0, bounds.width, bounds.height, true);
        } else {
            gc.setBackground(Display.getDefault().getSystemColor(25));
            gc.fillRectangle(bounds);
        }
    }
}

