/*
 * Decompiled with CFR 0.152.
 */
package su.artix.discountmanagercore.dao.discountsystem;

import java.io.FileWriter;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.ssa.cashadmin.LibActivator;
import ru.ssa.cashadmin.domain.DiscountSystem;
import ru.ssa.cashadmin.excep.ExecuteQueryException;
import su.artix.discountmanagercore.dao.discountsystem.DiscountSystemDAO;
import su.artix.discountmanagercore.dao.discountsystem.DiscountSystemDAODBImpl;
import su.artix.discountmanagercore.holders.ConnectionHolder;
import su.artix.loyaltylib.convertor.discountsystem.DiscountSystem2Yaml;
import su.artix.loyaltylib.convertor.discountsystem.DiscountSystemFromYaml;
import su.artix.loyaltylib.domain.java.discountsystem.Discount;
import su.artix.loyaltylib.domain.java.discountsystem.DiscountCampaign;
import su.artix.loyaltylib.domain.java.discountsystem.DiscountCampaignGroup;
import su.artix.loyaltylib.domain.java.observable.AbstractDiscountModel;
import su.artix.yuki.model.ModelActivator;
import su.artix.yuki.model.directory.DirectoryEditModel;

public class DiscountSystemBaseDAO
implements DiscountSystemDAO {
    private final Logger log = LoggerFactory.getLogger(DiscountSystemDAODBImpl.class);
    private String ds;
    private static String ALL_SHOP_STORE_ID = "$$all$$";
    private ConcurrentHashMap<DiscountSystemDAO.SystemType, AtomicLong> maxIds = new ConcurrentHashMap();

    public DiscountSystemBaseDAO(String readStatementSQL) {
    }

    private String getSystem(DiscountSystemDAO.SystemType systemType, DiscountSystem systemFromBase) {
        String ds = null;
        switch (systemType) {
            case DISCOUNT_SYSTEM: {
                ds = systemFromBase.getDiscSystemDesc();
                break;
            }
            case LIMIT_BONUS_SYSTEM: {
                ds = systemFromBase.getLimitBonusSystemDesc();
                break;
            }
            case EARN_BONUS_SYSTEM: {
                ds = systemFromBase.getEarnBonusSystemDesc();
                break;
            }
            case PERIODIC_IMPACTS_BONUS_SYSTEM: {
                ds = systemFromBase.getPeriodicImpactsSystemDesc();
                break;
            }
            case SECOND_SYSTEM: {
                ds = systemFromBase.getSeconddiscsystem();
            }
        }
        return ds;
    }

    @Override
    public String getYamlFromDB(DiscountSystemDAO.SystemType system) {
        this.ds = null;
        DirectoryEditModel discountSystemModel = ModelActivator.getDefault().getModelProvider().getDirectoryModel(DiscountSystem.class);
        List discountSystems = discountSystemModel.getList();
        if (!discountSystems.isEmpty()) {
            this.ds = this.getSystem(system, (DiscountSystem)discountSystems.get(0));
        }
        return this.ds;
    }

    @Override
    public su.artix.loyaltylib.domain.java.discountsystem.DiscountSystem getDiscountSystem(DiscountSystemDAO.SystemType systemType) throws Exception {
        String systemAsYaml = this.getYamlFromDB(systemType);
        su.artix.loyaltylib.domain.java.discountsystem.DiscountSystem ds = null;
        if (systemAsYaml == null) {
            ds = new su.artix.loyaltylib.domain.java.discountsystem.DiscountSystem();
        } else {
            ds = DiscountSystemFromYaml.getDiscountSystem((String)systemAsYaml);
            Long id = this.getMaxId(ds);
            this.log.info("max id for system:{}={}", (Object)systemType, (Object)id);
            this.maxIds.put(systemType, new AtomicLong(id));
        }
        return ds;
    }

    private Long getMaxId(su.artix.loyaltylib.domain.java.discountsystem.DiscountSystem system) {
        DiscountCampaignGroup root = system.getCampaignGroup();
        Long id = this.getMaxId(root);
        return id;
    }

    private Long getMaxId(DiscountCampaignGroup root) {
        Long id = 0L;
        if (root != null) {
            id = this.getMaxInOneLevel(root);
            for (DiscountCampaignGroup child : root.getSubGroups()) {
                Long fromChild = this.getMaxForOne(child);
                if (fromChild <= id) continue;
                id = fromChild;
            }
        }
        return id;
    }

    private Long getMaxForOne(DiscountCampaignGroup child) {
        Long id = this.getMaxInOneLevel(child);
        Long fromChild = this.getMaxId(child);
        if (fromChild > id) {
            id = fromChild;
        }
        return id;
    }

    private Long getMaxInOneLevel(DiscountCampaignGroup child) {
        Long id = 0L;
        if (child != null) {
            for (DiscountCampaign campaing : child.getDiscountCampaigns()) {
                if (campaing.getId() != null && campaing.getId() > id) {
                    id = campaing.getId();
                }
                for (Discount discount : campaing.getDiscounts()) {
                    if (discount.getId() == null || discount.getId() <= id) continue;
                    id = discount.getId();
                }
            }
        }
        return id;
    }

    @Override
    public void saveSystemToFile(String file, su.artix.loyaltylib.domain.java.discountsystem.DiscountSystem system) {
        try {
            String dsString = DiscountSystem2Yaml.getDiscountSystemYaml((su.artix.loyaltylib.domain.java.discountsystem.DiscountSystem)system);
            FileWriter fw = new FileWriter(file);
            fw.write(dsString);
            fw.close();
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void saveDiscountSubTreeToFile(String file, List<AbstractDiscountModel> discountModels) throws Exception {
        String dsString = DiscountSystem2Yaml.getPyDiscountObject(discountModels);
        FileWriter fw = new FileWriter(file);
        fw.write(dsString);
        fw.close();
    }

    private void saveSystem(su.artix.loyaltylib.domain.java.discountsystem.DiscountSystem system, DiscountSystemDAO.SystemType systemType, boolean isLocalEdit) {
        String stringSystem = DiscountSystem2Yaml.getDiscountSystemYaml((su.artix.loyaltylib.domain.java.discountsystem.DiscountSystem)system);
        PreparedDiscountDirectoryModel directoryModel = new PreparedDiscountDirectoryModel();
        DiscountSystem systemFromBase = directoryModel.getSystemFromBase();
        switch (systemType) {
            case LIMIT_BONUS_SYSTEM: {
                systemFromBase.setLimitBonusSystemDesc(stringSystem);
                break;
            }
            case DISCOUNT_SYSTEM: {
                systemFromBase.setDiscSystemDesc(stringSystem);
                break;
            }
            case EARN_BONUS_SYSTEM: {
                systemFromBase.setEarnBonusSystemDesc(stringSystem);
                break;
            }
            case PERIODIC_IMPACTS_BONUS_SYSTEM: {
                systemFromBase.setPeriodicImpactsSystemDesc(stringSystem);
                break;
            }
            case SECOND_SYSTEM: {
                systemFromBase.setSeconddiscsystem(stringSystem);
                break;
            }
        }
        directoryModel.saveDiscountSystem(systemFromBase);
    }

    @Override
    public void saveDiscountSystem(su.artix.loyaltylib.domain.java.discountsystem.DiscountSystem discountSystem, boolean isLocalEdit) {
        this.saveSystem(discountSystem, DiscountSystemDAO.SystemType.DISCOUNT_SYSTEM, isLocalEdit);
    }

    @Override
    public void saveEarnBonusSystem(su.artix.loyaltylib.domain.java.discountsystem.DiscountSystem earnBonusSystem, boolean isLocalEdit) {
        this.saveSystem(earnBonusSystem, DiscountSystemDAO.SystemType.EARN_BONUS_SYSTEM, isLocalEdit);
    }

    @Override
    public void saveLimitBonusSystem(su.artix.loyaltylib.domain.java.discountsystem.DiscountSystem limitBonusSystem, boolean isLocalEdit) {
        this.saveSystem(limitBonusSystem, DiscountSystemDAO.SystemType.LIMIT_BONUS_SYSTEM, isLocalEdit);
    }

    @Override
    public void savePeriodicImpactsBonusSystem(su.artix.loyaltylib.domain.java.discountsystem.DiscountSystem periodicImpactsBonusSystem, boolean isLocalEdit) {
        this.saveSystem(periodicImpactsBonusSystem, DiscountSystemDAO.SystemType.PERIODIC_IMPACTS_BONUS_SYSTEM, isLocalEdit);
    }

    @Override
    public void saveSecondSystem(su.artix.loyaltylib.domain.java.discountsystem.DiscountSystem system, boolean isLocalEdit) {
        this.saveSystem(system, DiscountSystemDAO.SystemType.SECOND_SYSTEM, isLocalEdit);
    }

    @Override
    public boolean saveLocalEditValue(boolean isLocalEdit) {
        boolean success = false;
        if (!ConnectionHolder.getStoreId().equalsIgnoreCase(ALL_SHOP_STORE_ID)) {
            String owner = null;
            if (!isLocalEdit) {
                owner = ALL_SHOP_STORE_ID;
            }
            PreparedDiscountDirectoryModel directoryModel = new PreparedDiscountDirectoryModel();
            DiscountSystem systemFromBase = directoryModel.getSystemFromBase();
            systemFromBase.setOwnerStoreId(owner);
            directoryModel.saveDiscountSystem(systemFromBase);
            success = true;
        }
        return success;
    }

    @Override
    public boolean isLocalEdit() {
        PreparedDiscountDirectoryModel directoryModel;
        String owner;
        boolean localEdit = false;
        localEdit = ConnectionHolder.isCash() ? true : (owner = (directoryModel = new PreparedDiscountDirectoryModel()).getSystemFromBase().getOwnerStoreId()) == null || !owner.equals(ALL_SHOP_STORE_ID);
        return localEdit;
    }

    @Override
    public su.artix.loyaltylib.domain.java.discountsystem.DiscountSystem getRevisionDiscountSystem(DiscountSystemDAO.SystemType systemType, int revision) {
        DirectoryEditModel discountSystemModel = ModelActivator.getDefault().getModelProvider().getDirectoryModel(DiscountSystem.class);
        Object audit = discountSystemModel.getAuditRevisionItem(revision);
        this.log.info("audit list: {}", audit);
        if (audit != null) {
            Object[] auditObject = (Object[])audit;
            DiscountSystem allSystems = (DiscountSystem)auditObject[0];
            return DiscountSystemFromYaml.getDiscountSystem((String)this.getSystem(systemType, allSystems));
        }
        return null;
    }

    @Override
    public AtomicLong getMaxId(DiscountSystemDAO.SystemType system) {
        AtomicLong res = this.maxIds.get((Object)system);
        if (res == null) {
            res = new AtomicLong(0L);
            this.maxIds.put(system, res);
        }
        return res;
    }

    private class PreparedDiscountDirectoryModel {
        private DirectoryEditModel<DiscountSystem> discountSystemModel = ModelActivator.getDefault().getModelProvider().getDirectoryModel(DiscountSystem.class);
        private DiscountSystem systemFromBase;
        private boolean discountSystemBaseIsEmpty;
        private boolean isCalled = false;

        public PreparedDiscountDirectoryModel() {
            List discountSystems = this.discountSystemModel.getList();
            this.discountSystemBaseIsEmpty = discountSystems.isEmpty();
            this.systemFromBase = this.discountSystemBaseIsEmpty ? (DiscountSystem)LibActivator.getDefault().getActualClassResolver().getInstance(DiscountSystem.class) : (DiscountSystem)discountSystems.get(0);
        }

        public DiscountSystem getSystemFromBase() {
            return this.systemFromBase;
        }

        public void saveDiscountSystem(DiscountSystem discountSystem) {
            if (this.isCalled) {
                throw new RuntimeException("Create new instance for new save operation please!");
            }
            try {
                try {
                    if (this.discountSystemBaseIsEmpty) {
                        this.discountSystemModel.save((Object)discountSystem);
                    } else {
                        this.discountSystemModel.update((Object)discountSystem);
                    }
                }
                catch (ExecuteQueryException e) {
                    throw new RuntimeException(e);
                }
            }
            finally {
                this.isCalled = true;
            }
        }
    }
}

