/*
 * Decompiled with CFR 0.152.
 */
package ru.ssa.cashadmin.dao;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.EmbeddedId;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import org.apache.commons.lang.reflect.FieldUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DomainUtils {
    private static final Logger log = LoggerFactory.getLogger(DomainUtils.class);

    public static String getIdColum(Class<?> cl) {
        try {
            return DomainUtils.getAnnotationField(cl, Id.class, true).get(0);
        }
        catch (Exception exception) {
            try {
                return DomainUtils.getAnnotationField(cl, EmbeddedId.class, true).get(0);
            }
            catch (Exception exception2) {
                return DomainUtils.getAnnotationField(cl, org.springframework.data.annotation.Id.class, true).get(0);
            }
        }
    }

    public static List<String> getAnnotationField(Class<?> cl, Class<? extends Annotation> annotationClass, boolean onlyFirst) {
        ArrayList<String> annotatFields = new ArrayList<String>();
        try {
            PropertyDescriptor[] propertyDescriptorArray = Introspector.getBeanInfo(cl).getPropertyDescriptors();
            int n = propertyDescriptorArray.length;
            int n2 = 0;
            while (n2 < n) {
                PropertyDescriptor d = propertyDescriptorArray[n2];
                Field field = FieldUtils.getField(cl, (String)d.getName(), (boolean)true);
                if (field != null && field.isAnnotationPresent(annotationClass)) {
                    annotatFields.add(d.getName());
                    if (onlyFirst) break;
                }
                ++n2;
            }
        }
        catch (IntrospectionException e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
        return annotatFields;
    }

    public static List<String> getAnnotationFieldOneToMany(Class<?> cl, boolean onlyFirst) {
        return DomainUtils.getAnnotationField(cl, OneToMany.class, false);
    }

    public static Object setFieldValue(String fieldName, Object obj, Object value) {
        try {
            FieldUtils.writeField((Object)obj, (String)fieldName, (Object)value, (boolean)true);
            return obj;
        }
        catch (SecurityException e) {
            log.warn(e.getMessage(), (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            log.warn(e.getMessage(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            log.warn(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public static Object getFieldValue(String fieldName, Object obj) {
        try {
            return FieldUtils.readField((Object)obj, (String)fieldName, (boolean)true);
        }
        catch (SecurityException e) {
            log.warn(e.getMessage(), (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            log.warn(e.getMessage(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            log.warn(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public static Object getIdValue(Object obj) {
        return DomainUtils.getFieldValue(DomainUtils.getIdColum(obj.getClass()), obj);
    }

    public static void setIdValue(Object obj, Object value) {
        DomainUtils.setFieldValue(DomainUtils.getIdColum(obj.getClass()), obj, value);
    }

    public static boolean isComposite(Class<?> clazz, String field) {
        try {
            return FieldUtils.getField(clazz, (String)field, (boolean)true).isAnnotationPresent(EmbeddedId.class);
        }
        catch (SecurityException e) {
            log.warn(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public static Class<?> getTypeId(Class<?> cl) {
        return FieldUtils.getField(cl, (String)DomainUtils.getIdColum(cl), (boolean)true).getType();
    }
}

