/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.config;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.parsing.BeanComponentDefinition;
import org.springframework.beans.factory.parsing.ReaderContext;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.data.repository.config.RepositoryBeanDefinitionBuilder;
import org.springframework.data.repository.config.RepositoryConfiguration;
import org.springframework.data.repository.config.RepositoryConfigurationExtension;
import org.springframework.data.repository.config.XmlRepositoryConfigurationSource;
import org.springframework.util.Assert;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepositoryBeanDefinitionParser
implements BeanDefinitionParser {
    private static final Log LOG = LogFactory.getLog(RepositoryBeanDefinitionParser.class);
    private final RepositoryConfigurationExtension extension;

    public RepositoryBeanDefinitionParser(RepositoryConfigurationExtension extension) {
        Assert.notNull((Object)extension);
        this.extension = extension;
    }

    public BeanDefinition parse(Element element, ParserContext parser) {
        try {
            XmlRepositoryConfigurationSource configSource = new XmlRepositoryConfigurationSource(element, parser);
            for (RepositoryConfiguration<XmlRepositoryConfigurationSource> config : this.extension.getRepositoryConfigurations(configSource, parser.getReaderContext().getResourceLoader())) {
                this.registerGenericRepositoryFactoryBean(config, parser);
            }
            this.extension.registerBeansForRoot(parser.getRegistry(), configSource);
        }
        catch (RuntimeException e) {
            this.handleError(e, element, (ReaderContext)parser.getReaderContext());
        }
        return null;
    }

    private void handleError(Exception e, Element source, ReaderContext reader) {
        reader.error(e.getMessage(), reader.extractSource((Object)source), (Throwable)e);
    }

    private void registerGenericRepositoryFactoryBean(RepositoryConfiguration<XmlRepositoryConfigurationSource> configuration, ParserContext parser) {
        RepositoryBeanDefinitionBuilder definitionBuilder = new RepositoryBeanDefinitionBuilder(configuration, this.extension);
        try {
            BeanDefinitionBuilder builder = definitionBuilder.build(parser.getRegistry(), parser.getReaderContext().getResourceLoader());
            this.extension.postProcess(builder, configuration.getConfigurationSource());
            AbstractBeanDefinition beanDefinition = builder.getBeanDefinition();
            beanDefinition.setSource(configuration.getSource());
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Registering repository: " + configuration.getBeanId() + " - Interface: " + configuration.getRepositoryInterface() + " - Factory: " + this.extension.getRepositoryFactoryClassName()));
            }
            BeanComponentDefinition definition = new BeanComponentDefinition((BeanDefinition)beanDefinition, configuration.getBeanId());
            parser.registerBeanComponent(definition);
        }
        catch (RuntimeException e) {
            this.handleError(e, configuration.getConfigurationSource().getElement(), (ReaderContext)parser.getReaderContext());
        }
    }

    protected static boolean hasBean(Class<?> type, BeanDefinitionRegistry registry) {
        String name = String.format("%s%s0", type.getName(), "#");
        return registry.containsBeanDefinition(name);
    }
}

