/*
 * Decompiled with CFR 0.152.
 */
package su.artix.cashserver.rest.client.entities;

import java.util.List;
import org.springframework.core.ParameterizedTypeReference;
import su.artix.cashserver.core.cashregistry.domain.SecurityObject;
import su.artix.cashserver.rest.client.RestInvoker;
import su.artix.cashserver.rest.client.RestInvokerManager;
import su.artix.cashserver.rest.domain.SecurityObjectInfo;

public class SecurityObjectsRestClient {
    private static final String SECURITY_OBJECTS_URL = "securityObjects";
    private final RestInvokerManager restInvokerManager;

    public SecurityObjectsRestClient(RestInvokerManager restInvokerManager) {
        this.restInvokerManager = restInvokerManager;
    }

    public static SecurityObjectInfo convertSecurityObjectToSecurityObjectInfo(SecurityObject securityObject) {
        SecurityObjectInfo info = new SecurityObjectInfo();
        info.setId(securityObject.getId());
        info.setClazz(securityObject.getClazz());
        info.setTitle(securityObject.getTitle());
        if (securityObject.getParent() != null) {
            info.setParentId(securityObject.getParent().getId());
        }
        return info;
    }

    public Long countSecurityObjects() {
        return this.restInvokerManager.getRestInvoker().invokeGet("securityObjects/count", Long.class);
    }

    public Boolean existsSecurityObject(String id) {
        return this.restInvokerManager.getRestInvoker().invokeGet(RestInvoker.urlBuild("securityObjects/{0}/exists", id), Boolean.class);
    }

    public List<SecurityObject> getSecurityObjects() {
        ParameterizedTypeReference<List<SecurityObject>> returnTypeRef = new ParameterizedTypeReference<List<SecurityObject>>(){};
        return this.restInvokerManager.getRestInvoker().invokeGet(SECURITY_OBJECTS_URL, returnTypeRef);
    }

    public List<SecurityObject> getSecurityObjectsByClass(String className) {
        ParameterizedTypeReference<List<SecurityObject>> returnTypeRef = new ParameterizedTypeReference<List<SecurityObject>>(){};
        return this.restInvokerManager.getRestInvoker().invokeGet(RestInvoker.urlBuild("securityObjects/class/{0}", className), returnTypeRef);
    }

    public List<SecurityObject> getSecurityObjectsByParentId(String parentId) {
        ParameterizedTypeReference<List<SecurityObject>> returnTypeRef = new ParameterizedTypeReference<List<SecurityObject>>(){};
        return this.restInvokerManager.getRestInvoker().invokeGet(RestInvoker.urlBuild("securityObjects/parent/{0}", parentId), returnTypeRef);
    }

    public void addSecurityObject(SecurityObject securityObject) {
        this.restInvokerManager.getRestInvoker().invokePost(SECURITY_OBJECTS_URL, SecurityObjectsRestClient.convertSecurityObjectToSecurityObjectInfo(securityObject));
    }

    public SecurityObject getSecurityObject(String id) {
        return this.restInvokerManager.getRestInvoker().invokeGet(RestInvoker.urlBuild("securityObjects/{0}", id), SecurityObject.class);
    }

    public void updateSecurityObject(String id, SecurityObject securityObject) {
        this.restInvokerManager.getRestInvoker().invokePut(RestInvoker.urlBuild("securityObjects/{0}", id), SecurityObjectsRestClient.convertSecurityObjectToSecurityObjectInfo(securityObject));
    }

    public void removeSecurityObject(String id) {
        this.restInvokerManager.getRestInvoker().invokeDelete(RestInvoker.urlBuild("securityObjects/{0}", id));
    }
}

