/*
 * Decompiled with CFR 0.152.
 */
package su.artix.yuki.keyboard.gui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import su.artix.yuki.keyboard.domain.KeyboardButtonData;
import su.artix.yuki.keyboard.domain.KeyboardContainer;
import su.artix.yuki.keyboard.gui.KeyboardButton;
import su.artix.yuki.keyboard.gui.KeyboardButtonAction;

public class KeyboardPanel
extends Composite {
    private KeyboardContainer keyboard;
    private KeyboardButtonAction action;
    private List<KeyboardButton> buttons = new ArrayList<KeyboardButton>();

    public KeyboardPanel(Composite parent, int style, KeyboardContainer keyboard) {
        this(parent, style, keyboard, null);
    }

    public KeyboardPanel(Composite parent, int style, KeyboardContainer keyboard, KeyboardButtonAction action) {
        super(parent, style);
        this.keyboard = keyboard;
        this.action = action;
        this.init();
    }

    private void init() {
        this.setLayout((Layout)new FormLayout());
        if (this.keyboard != null && this.keyboard.getButtons() != null) {
            for (KeyboardButtonData button : this.keyboard.getButtons()) {
                this.buttons.add(new KeyboardButton(this, button, this.action));
            }
        } else {
            Label message = new Label((Composite)this, 0);
            message.setText("\u041d\u0443 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u0442\u043e\u0431\u0440\u0430\u0437\u0438\u0442\u044c \u043a\u043b\u0430\u0432\u0438\u0430\u0442\u0443\u0440\u0443. \u041f\u0440\u043e\u0432\u0435\u0440\u044c\u0442\u0435 \u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u043e\u0441\u0442\u044c \u0443\u043a\u0430\u0437\u0430\u043d\u043d\u043e\u0439 \u043a\u043b\u0430\u0432\u0438\u0430\u0442\u0443\u0440\u044b " + this.keyboard);
        }
    }

    public void updateView() {
        for (KeyboardButton button : this.buttons) {
            button.updateButtonView();
        }
    }

    public void update(KeyboardContainer newKeyboardContainer) {
        this.setKeyboard(newKeyboardContainer);
        Control[] controlArray = this.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            control.dispose();
            ++n2;
        }
        this.buttons.clear();
        if (this.keyboard != null) {
            for (KeyboardButtonData button : this.keyboard.getButtons()) {
                this.buttons.add(new KeyboardButton(this, button, this.action));
            }
        }
        this.layout();
    }

    public KeyboardContainer getKeyboard() {
        return this.keyboard;
    }

    public void setKeyboard(KeyboardContainer keyboard) {
        this.keyboard = keyboard;
    }

    public void setShowCode(boolean show) {
        for (KeyboardButton button : this.buttons) {
            button.setShowCode(show);
        }
        this.updateView();
    }

    public void setShowHotKey(boolean show) {
        for (KeyboardButton button : this.buttons) {
            button.setShowHotKey(show);
        }
        this.updateView();
    }
}

