/*
 * Decompiled with CFR 0.152.
 */
package su.artix.yuki.action;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import su.artix.cashserver.security.SecurityAction;
import su.artix.yuki.images.ArtixAdminImages;
import su.artix.yuki.model.directory.DirectoryAction;

public class TableViewerRemoveAction<E>
extends Action
implements ISelectionChangedListener,
SecurityAction {
    private final Class<E> cl;
    private final PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport((Object)this);
    private StructuredSelection structuredSelection;
    private boolean securityEnabled;

    public TableViewerRemoveAction(Class<E> cl, PropertyChangeListener propertyChangeListener) {
        super("\u0423\u0434\u0430\u043b\u0438\u0442\u044c");
        this.cl = cl;
        this.propertyChangeSupport.addPropertyChangeListener(propertyChangeListener);
        this.setImageDescriptor(ArtixAdminImages.getDefault().getImageDescriptor("plane/16x16/delete"));
        this.setToolTipText("\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435");
    }

    public void run() {
        if (MessageDialog.openQuestion((Shell)Display.getDefault().getActiveShell(), (String)"\u041f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u0438\u0435...", (String)"\u0412\u044b \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0442\u0435\u043b\u044c\u043d\u043e \u0445\u043e\u0442\u0438\u0442\u0435 \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u044d\u043b\u0435\u043c\u0435\u043d\u0442?")) {
            for (Object obj : this.structuredSelection.toList()) {
                this.propertyChangeSupport.firePropertyChange(DirectoryAction.REMOVE.toString(), null, obj);
            }
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        if (event.getSelection() instanceof IStructuredSelection) {
            this.structuredSelection = (StructuredSelection)event.getSelection();
            this.setEnabled(this.securityEnabled && this.structuredSelection.size() == 1 && this.structuredSelection.getFirstElement().getClass() == this.cl);
        } else {
            this.setEnabled(false);
        }
    }

    public void setSecurityEnabled(boolean enabled) {
        this.securityEnabled = enabled;
    }

    public boolean isSecurityEnabled() {
        return this.securityEnabled;
    }
}

