/*
 * Decompiled with CFR 0.152.
 */
package ru.ssa.artixadmin.action.connect;

import java.beans.PropertyVetoException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ui.ModelMap;
import ru.ssa.artixadmin.ArtixAdminActivator;
import ru.ssa.artixadmin.view.connect.ConnectTableViewer;
import ru.ssa.cashadmin.domain.BuildNumber;
import ru.ssa.cashadmin.domain.CSVersion;
import ru.ssa.cashadmin.domain.Connect;
import su.artix.artixadmin.connection.manager.DataSourceFactory;
import su.artix.cashserver.rest.client.IClientGetter;
import su.artix.cashserver.rest.client.RestInvokerManager;
import su.artix.yuki.images.ArtixAdminImages;

public class TestConnectAction
extends Action {
    private ConnectTableViewer connectTableViewer = null;
    private Connect connect = null;
    private final boolean showResultMessage;
    private boolean succefull;
    private static final Logger log = LoggerFactory.getLogger(TestConnectAction.class);

    private void testConnect(String ip, String port, String user, String password, String dbName) throws SQLException, PropertyVetoException {
        DataSource dataSource = ArtixAdminActivator.getDefault().getBeanByClass(DataSourceFactory.class).makeDataSource(user, password, ip, port, dbName);
        dataSource.setLoginTimeout(2000);
        Connection connection = dataSource.getConnection();
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery("SHOW VARIABLES LIKE 'VERSION'");
        if (resultSet.next()) {
            this.succefull = true;
            if (this.showResultMessage) {
                MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)"\u0421\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u0435 \u043f\u0440\u043e\u0448\u043b\u043e \u0443\u0441\u043f\u0435\u0448\u043d\u043e!", (String)("\u0412\u0435\u0440\u0441\u0438\u044f MySQL (" + resultSet.getString("value") + ")"));
            }
        }
        connection.close();
        resultSet.close();
        statement.close();
    }

    private void testCSConnect(String ip, String port) {
        ArtixAdminActivator.getDefault().getBeanByClass(RestInvokerManager.class, "restInvokerManager").setDefault(ip, port);
        IClientGetter client = ArtixAdminActivator.getDefault().getBeanByClass(IClientGetter.class);
        ModelMap systemInfo = client.getClient().getSystemEntity().getInfo();
        if (systemInfo != null && !systemInfo.isEmpty()) {
            this.succefull = true;
            if (this.showResultMessage) {
                MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)"\u0421\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u0435 \u043f\u0440\u043e\u0448\u043b\u043e \u0443\u0441\u043f\u0435\u0448\u043d\u043e!", (String)("Artix:CashServer\n\u0412\u0435\u0440\u0441\u0438\u044f : " + systemInfo.get((Object)"version") + "\n\u0421\u0431\u043e\u0440\u043a\u0430 : " + systemInfo.get((Object)"buildNumber") + "\n\u0414\u0430\u0442\u0430 \u0441\u0431\u043e\u0440\u043a\u0438 : " + systemInfo.get((Object)"buildDate")));
            } else {
                Object verson;
                BuildNumber buildNumber = BuildNumber.parse((String)systemInfo.get((Object)"buildNumber").toString());
                if (!Boolean.getBoolean("yuki.force") && buildNumber.getNumber() != null && buildNumber.getBuildType() != BuildNumber.BuildType.testing && (verson = systemInfo.get((Object)"versionRest")) != null) {
                    Integer versionRest = Integer.valueOf(verson.toString());
                    if (!ArtixAdminActivator.getDefault().isSupportRestVersion(versionRest)) {
                        this.succefull = false;
                        MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)"\u0418\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f", (String)("\u0412\u0430\u0448\u0430 \u0432\u0435\u0440\u0441\u0438\u044f Yuki \u0443\u0441\u0442\u0430\u0440\u0435\u043b\u0430! \n\n\u0414\u043b\u044f \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u044f \u043a \u043a\u0430\u0441\u0441\u043e\u0432\u043e\u043c\u0443 \u0441\u0435\u0440\u0432\u0435\u0440\u0443, \u0412\u0430\u043c \u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u0437\u0430\u0433\u0440\u0443\u0437\u0438\u0442\u044c \u0438 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u043f\u043e\u0441\u043b\u0435\u0434\u043d\u044e\u044e \u0434\u043e\u0441\u0442\u0443\u043f\u043d\u0443\u044e \u0432\u0435\u0440\u0441\u0438\u044e.\n\n \u0412\u0435\u0440\u0441\u0438\u044f \u0441\u0435\u0440\u0432\u0435\u0440\u0430:" + versionRest + "\n\n \u041f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u043c\u0430\u044f \u0432\u0435\u0440\u0441\u0438\u044f:" + ArtixAdminActivator.getDefault().getRestVersion()));
                    }
                }
            }
        }
    }

    public TestConnectAction(ConnectTableViewer connectTableViewer, boolean showResultMessage) {
        super("&\u041f\u0440\u043e\u0432\u0435\u0440\u0438\u0442\u044c \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u0435", ArtixAdminImages.getDefault().getImageDescriptor("plane/16x16/connect_test"));
        this.connectTableViewer = connectTableViewer;
        this.showResultMessage = showResultMessage;
        this.succefull = false;
    }

    public TestConnectAction(Connect connect, boolean showResultMessage, boolean cashSever) {
        super("&\u041f\u0440\u043e\u0432\u0435\u0440\u0438\u0442\u044c \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u0435");
        this.connect = connect;
        this.connect.setCashServerConnect(cashSever);
        this.showResultMessage = showResultMessage;
        this.succefull = false;
    }

    public boolean isSuccefull() {
        return this.succefull;
    }

    public void run() {
        if (this.connectTableViewer != null) {
            this.connect = this.connectTableViewer.getSelectedConnect();
        }
        Display.getCurrent().syncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    Display display = Display.getCurrent();
                    if (display == null) {
                        display = Display.getDefault();
                    }
                    display.getActiveShell().setCursor(new Cursor((Device)display, 1));
                }
                catch (Exception e) {
                    log.error(e.getMessage());
                }
            }
        });
        try {
            String user = this.connect.getLogin();
            String password = this.connect.getPassword();
            if (!this.connect.isCashServerConnect()) {
                this.testConnect(this.connect.getAddress(), this.connect.getPort(), user, password, "dictionaries");
                this.testConnect(this.connect.getAddress(), this.connect.getPort(), user, password, "documents");
            } else if (this.connect.getCsVersion().older(CSVersion.VERSION2_3)) {
                this.testConnect(this.connect.getAddress(), this.connect.getPort(), user, password, "");
            } else {
                this.testCSConnect(this.connect.getAddress(), this.connect.getHttpPort());
                if (this.connect.isMysqlServerSplitConnect()) {
                    this.testConnect(this.connect.getMysqlServerHost(), this.connect.getPort(), this.connect.getMysqlServerLogin(), this.connect.getMysqlServerPassword(), "");
                }
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            Status status = new Status(4, "ArtixAdmin_V4.4", 0, "\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u044f", (Throwable)e);
            ErrorDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"\u041e\u0448\u0438\u0431\u043a\u0430!", null, (IStatus)status);
        }
        Display.getCurrent().syncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    Display.getCurrent().getActiveShell().setCursor(new Cursor((Device)Display.getCurrent(), 0));
                }
                catch (Exception e) {
                    log.error(e.getMessage());
                }
            }
        });
    }
}

