/*
 * Decompiled with CFR 0.152.
 */
package ru.ssa.artixadmin.action.menutree.dnd;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.TransferData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MenuTreeTransfer
extends ByteArrayTransfer {
    private static final Logger log = LoggerFactory.getLogger(MenuTreeTransfer.class);
    private static final MenuTreeTransfer instance = new MenuTreeTransfer();
    private static final String TYPENAME = "menutree-transfer-format";
    private static final int TYPEID = MenuTreeTransfer.registerType((String)"menutree-transfer-format");

    protected int[] getTypeIds() {
        return new int[]{TYPEID};
    }

    protected String[] getTypeNames() {
        return new String[]{TYPENAME};
    }

    protected void javaToNative(Object object, TransferData transferData) {
        if (!this.validate(object) || !this.isSupportedType(transferData)) {
            DND.error((int)2003);
        }
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(object);
            byte[] buffer = byteArrayOutputStream.toByteArray();
            objectOutputStream.close();
            super.javaToNative((Object)buffer, transferData);
        }
        catch (IOException e) {
            log.error(e.getMessage());
        }
    }

    protected Object nativeToJava(TransferData transferData) {
        if (this.isSupportedType(transferData)) {
            byte[] buffer = (byte[])super.nativeToJava(transferData);
            if (buffer == null) {
                return null;
            }
            Object object = null;
            try {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(buffer);
                ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
                object = objectInputStream.readObject();
            }
            catch (IOException e) {
                log.error(e.getMessage());
                return null;
            }
            catch (ClassNotFoundException e) {
                log.error(e.getMessage());
                return null;
            }
            return object;
        }
        return null;
    }

    public static MenuTreeTransfer getInstance() {
        return instance;
    }
}

