/*
 * Decompiled with CFR 0.152.
 */
package su.artix.discountmanager.dialogs.accounting;

import java.math.BigDecimal;
import java.util.List;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.mihalis.opal.checkBoxGroup.CheckBoxGroup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.ssa.cashadmin.dao.DaoFactory;
import ru.ssa.cashadmin.domain.TransactionReason;
import ru.ssa.cashadmin.excep.ExecuteQueryException;
import su.artix.cashserver.security.SecurityKey;
import su.artix.discountmanager.dialogs.accounting.Validation;
import su.artix.discountmanager.utils.ErrorMessageFactory;
import su.artix.discountmanagercore.model.accounting.Accounting;
import su.artix.widgets.ComboBoxWithEmptyBox;
import su.artix.widgets.DateTimeAndTimeWithEmpyBox;
import su.artix.yuki.binding.BindingKey;
import su.artix.yuki.binding.BindingType;
import su.artix.yuki.directory.Directory;
import su.artix.yuki.directory.DirectoryLabelProvider;
import su.artix.yuki.directory.DirectoryList;
import su.artix.yuki.editors.EditorComposite;

@SecurityKey(title="\u0414\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u0431\u043e\u043d\u0443\u0441\u0430")
public class AddAccountingPanel
extends EditorComposite<Accounting>
implements Validation {
    private static final Logger log = LoggerFactory.getLogger(AddAccountingPanel.class);
    private static final boolean REQUIRE_REASON = BooleanUtils.toBoolean((String)System.getProperty("yuki.requireTransactionReason"));
    @SecurityKey(id="amount", title="\u0421\u0443\u043c\u043c\u0430")
    private Label amountLabel;
    @SecurityKey(id="amount")
    private Spinner amountField;
    @SecurityKey(id="reason", title="\u041f\u0440\u0438\u0447\u0438\u043d\u0430")
    private Label reasonLabel;
    @SecurityKey(id="reason")
    private Text reasonField;
    @SecurityKey(id="groupId", title="\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0433\u0440\u0443\u043f\u043f\u044b")
    private Label groupIdLabel;
    @SecurityKey(id="groupId")
    private Text groupIdField;
    @SecurityKey(id="beginDate", title="\u041d\u0430\u0447\u0430\u043b\u043e \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f")
    private Label beginDateLabel;
    @SecurityKey(id="beginDate")
    private DateTimeAndTimeWithEmpyBox beginDateField;
    @SecurityKey(id="endDate", title="\u041a\u043e\u043d\u0435\u0446 \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f")
    private Label endDateLabel;
    @SecurityKey(id="endDate")
    private DateTimeAndTimeWithEmpyBox endDateField;
    @SecurityKey(id="weight", title="\u041e\u0447\u0435\u0440\u0435\u0434\u044c \u0441\u043f\u0438\u0441\u0430\u043d\u0438\u044f")
    private Label weightLabel;
    @SecurityKey(id="weight")
    @BindingKey(bindingType=BindingType.DIRECTORY_LIST_INTEGER)
    private ComboBoxWithEmptyBox weightField;
    @SecurityKey(id="reason", title="\u041f\u0440\u0438\u0447\u0438\u043d\u0430 \u0438\u0437 \u0441\u043f\u0438\u0441\u043a\u0430")
    private Label reasonListLabel;
    @SecurityKey(id="reasonSelect")
    @BindingKey(bindingType=BindingType.DIRECTORY_LIST_STRING, id="reason")
    private ComboViewer reasonListField;
    private DirectoryList reasons;

    public AddAccountingPanel(Composite parent, int style, Accounting model) {
        super(parent, style, Accounting.class, (Object)model);
    }

    public void initialize() {
        GridLayoutFactory.swtDefaults().numColumns(2).applyTo((Composite)this);
        this.amountLabel = new Label((Composite)this, 0);
        this.amountLabel.setText("\u0421\u0443\u043c\u043c\u0430:");
        this.amountField = new Spinner((Composite)this, 2048);
        this.amountField.setDigits(2);
        this.amountField.setIncrement((int)Math.pow(10.0, this.amountField.getDigits()));
        this.amountField.setPageIncrement((int)Math.pow(10.0, this.amountField.getDigits() + 1));
        this.amountField.setMinimum(0);
        this.amountField.setMaximum(Integer.MAX_VALUE);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.amountField);
        if (REQUIRE_REASON) {
            this.reasonListLabel = new Label((Composite)this, 0);
            this.reasonListLabel.setText("\u041f\u0440\u0438\u0447\u0438\u043d\u0430:");
            this.reasonListField = new ComboViewer((Composite)this, 0);
            this.reasonListField.setContentProvider((IContentProvider)new ArrayContentProvider());
            this.reasonListField.setLabelProvider((IBaseLabelProvider)new DirectoryLabelProvider());
            this.reasons = new DirectoryList();
            try {
                List list = DaoFactory.getDAO(TransactionReason.class).getList();
                for (TransactionReason reason : list) {
                    this.reasons.add(reason.getKey(), reason.getName());
                }
            }
            catch (ExecuteQueryException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
            this.reasonListField.setInput((Object)this.reasons);
            GridDataFactory.fillDefaults().applyTo((Control)this.reasonListField.getCombo());
        } else {
            this.reasonLabel = new Label((Composite)this, 0);
            this.reasonLabel.setText("\u041f\u0440\u0438\u0447\u0438\u043d\u0430:");
            this.reasonField = new Text((Composite)this, 2048);
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.reasonField);
        }
        final CheckBoxGroup group = new CheckBoxGroup((Composite)this, 0);
        Composite groupPanel = group.getContent();
        group.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ((Accounting)AddAccountingPanel.this.getModel()).setRestriction(group.isActivated());
            }
        });
        group.setText("\u041e\u0433\u0440\u0430\u043d\u0438\u0447\u0435\u043d\u0438\u044f");
        GridLayoutFactory.swtDefaults().numColumns(3).applyTo((Composite)group);
        GridDataFactory.fillDefaults().span(2, 1).grab(true, true).applyTo((Control)group);
        this.groupIdLabel = new Label(groupPanel, 0);
        this.groupIdLabel.setText("\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0433\u0440\u0443\u043f\u043f\u044b:");
        this.groupIdField = new Text(groupPanel, 2048);
        GridDataFactory.fillDefaults().span(2, 1).grab(true, false).applyTo((Control)this.groupIdField);
        this.beginDateLabel = new Label(groupPanel, 0);
        this.beginDateLabel.setText("\u041d\u0430\u0447\u0430\u043b\u043e \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f:");
        this.beginDateField = new DateTimeAndTimeWithEmpyBox(groupPanel, 36);
        this.beginDateField.getCheckBox().setText("\u043d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d\u043e");
        GridDataFactory.fillDefaults().span(1, 1).applyTo((Control)this.beginDateField);
        new Label(groupPanel, 0);
        this.endDateLabel = new Label(groupPanel, 0);
        this.endDateLabel.setText("\u041a\u043e\u043d\u0435\u0446 \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f:");
        this.endDateField = new DateTimeAndTimeWithEmpyBox(groupPanel, 36);
        this.endDateField.getCheckBox().setText("\u043d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d\u043e");
        GridDataFactory.fillDefaults().span(1, 1).applyTo((Control)this.endDateField);
        new Label(groupPanel, 0);
        this.weightLabel = new Label(groupPanel, 0);
        this.weightLabel.setText("\u041e\u0447\u0435\u0440\u0435\u0434\u044c \u0441\u043f\u0438\u0441\u0430\u043d\u0438\u044f:");
        this.weightField = new ComboBoxWithEmptyBox(groupPanel, 0);
        this.weightField.getComboBox().setContentProvider((IContentProvider)new ArrayContentProvider());
        this.weightField.getComboBox().setLabelProvider((IBaseLabelProvider)new DirectoryLabelProvider());
        this.weightField.getComboBox().setInput((Object)Directory.bonusesPaymentPriority);
        GridDataFactory.fillDefaults().applyTo((Control)this.weightField);
        new Label(groupPanel, 0);
        group.deactivate();
        if (Boolean.getBoolean("discount.bonus.hide_restrictions")) {
            ((GridData)group.getLayoutData()).exclude = true;
            group.setVisible(false);
        } else if (((Accounting)this.getModel()).isRestriction()) {
            group.activate();
        }
    }

    public void bindValues() {
        this.initDefaulBinding();
    }

    public void initDefault(Accounting model) {
        model.setRestriction(false);
        if (this.reasonListField == null) {
            model.setReason("MANUAL");
        }
    }

    @Override
    public boolean validation() {
        boolean valid = true;
        if (((Accounting)this.getModel()).getAmount() == null || BigDecimal.ZERO.compareTo(((Accounting)this.getModel()).getAmount()) >= 0) {
            valid = false;
            ErrorMessageFactory.generalErrorMessage("\u0421\u0443\u043c\u043c\u0430 \u0434\u043e\u043b\u0436\u043d\u0430 \u0431\u044b\u0442\u044c \u0431\u043e\u043b\u044c\u0448\u0435 0.00.");
        } else if (((Accounting)this.getModel()).isRestriction() && StringUtils.isEmpty((String)((Accounting)this.getModel()).getGroupId())) {
            valid = false;
            ErrorMessageFactory.generalErrorMessage("\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0433\u0440\u0443\u043f\u043f\u044b \u043e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u0435\u043d \u0434\u043b\u044f \u0437\u0430\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f.");
        } else if (REQUIRE_REASON && StringUtils.isEmpty((String)((Accounting)this.getModel()).getReason())) {
            valid = false;
            ErrorMessageFactory.generalErrorMessage("\u041f\u0440\u0438\u0447\u0438\u043d\u0430 \u043e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u0430 \u0434\u043b\u044f \u0437\u0430\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f.");
        }
        return valid;
    }
}

