/*
 * Decompiled with CFR 0.152.
 */
package su.artix.discountmanager.dialogs.discountsystem;

import com.google.common.base.Objects;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.IWorkbenchPart;
import su.artix.cashserver.security.SecurityKey;
import su.artix.discountmanager.dialogs.SystemTitleAreaDialog;
import su.artix.discountmanager.dialogs.discountsystem.DiscountPanel;
import su.artix.discountmanager.dialogs.discountsystem.DiscountPanelCashText;
import su.artix.discountmanager.dialogs.discountsystem.DiscountPanelClientDisplayText;
import su.artix.discountmanager.dialogs.discountsystem.DiscountPanelClientText;
import su.artix.discountmanager.dialogs.discountsystem.DiscountPanelPositionMark;
import su.artix.discountmanager.holders.ViewHolder;
import su.artix.discountmanager.utils.ErrorMessageFactory;
import su.artix.discountmanager.utils.FieldsUtils;
import su.artix.discountmanager.views.PeriodicImpactsBonusSystemView;
import su.artix.discountmanagercore.dao.discountsystem.DiscountSystemDAO;
import su.artix.loyaltylib.domain.java.discountsystem.Discount;
import su.artix.loyaltylib.domain.java.discountsystem.DiscountCampaign;
import su.artix.loyaltylib.domain.java.discountsystem.DiscountKitObject;
import su.artix.loyaltylib.domain.java.discountsystem.DiscountObject;
import su.artix.loyaltylib.domain.java.discountsystem.DiscountObjectCheck;
import su.artix.loyaltylib.domain.java.discountsystem.DiscountObjectKit;
import su.artix.loyaltylib.domain.java.discountsystem.DiscountObjectPosition;
import su.artix.loyaltylib.domain.java.discountsystem.DiscountRate;
import su.artix.loyaltylib.domain.java.discountsystem.DiscountRateKit;
import su.artix.loyaltylib.domain.java.discountsystem.DiscountRateKitObject;
import su.artix.loyaltylib.domain.java.discountsystem.DiscountRatePercent;
import su.artix.loyaltylib.domain.java.discountsystem.DiscountRateSum;
import su.artix.loyaltylib.domain.java.discountsystem.LegacyObject;
import su.artix.loyaltylib.domain.java.discountsystem.PositionMark;
import su.artix.loyaltylib.domain.java.discountsystem.SimpleObject;
import su.artix.loyaltylib.domain.java.observable.AutoincCodes;
import su.artix.loyaltylib.domain.java.observable.Named;
import su.artix.yuki.directory.Directory;
import su.artix.yuki.directory.MyKeyValue;
import su.artix.yuki.discount.macroparameter.dao.MacroparameterDAO;
import su.artix.yuki.editors.DialogMode;
import su.artix.yuki.editors.EditorComposite;

@SecurityKey(title="\u0421\u043a\u0438\u0434\u043a\u0438")
public class DiscountDialog
extends SystemTitleAreaDialog {
    private Discount discount;
    private DiscountCampaign parent;
    private String begginingTypeOfDiscount = null;
    private static final boolean saveInventSupportInKids = Boolean.getBoolean("discount.save_invent_support_in_kids");
    private MacroparameterDAO macroparameterDAO;
    private DiscountSystemDAO.SystemType type;
    private List<EditorComposite<?>> childPanels;
    private DiscountPanel discountPanel;
    private EditorComposite<Discount> clientTextPanel;
    private EditorComposite<Discount> clientDisplayTextPanel;
    private EditorComposite<Discount> cashTextPanel;
    private EditorComposite<PositionMark> positionMarkPanel;

    public DiscountDialog(DiscountCampaign parent, Discount discount, Map<String, String> paramList, DialogMode dialogMode, MacroparameterDAO dao, DiscountSystemDAO.SystemType type) {
        super(Display.getCurrent().getActiveShell(), dialogMode, paramList);
        this.parent = parent;
        this.discount = discount;
        this.macroparameterDAO = dao;
        this.type = type;
    }

    @Override
    protected Control createContents(Composite parentComposite) {
        Control content = super.createContents(parentComposite);
        this.fillTitleHeader((Named)this.parent, (Named)this.discount);
        return content;
    }

    @Override
    protected Control createDialogArea(Composite parent) {
        this.begginingTypeOfDiscount = FieldsUtils.getDiscountClassNameByObject(this.discount.getDiscountObject());
        this.discount.setTypeOfDiscount(this.begginingTypeOfDiscount);
        Composite container = (Composite)super.createDialogArea(parent);
        this.childPanels = new ArrayList();
        TabFolder tabFolder = new TabFolder(container, 0);
        GridDataFactory defualtDataFactory = GridDataFactory.fillDefaults().align(4, 4).grab(true, true);
        defualtDataFactory.applyTo((Control)tabFolder);
        TabItem basicItem = new TabItem(tabFolder, 0);
        basicItem.setText("\u0411\u0430\u0437\u043e\u0432\u0430\u044f");
        this.discountPanel = new DiscountPanel((Composite)tabFolder, 0, Discount.class, this.discount, this.type);
        this.discountPanel.setLayoutData(new GridData(4, 0x1000000, false, false, 1, 1));
        Discount initedModel = (Discount)this.discountPanel.getModel();
        if (this.getDialogMode() == DialogMode.CREATE) {
            this.discountPanel.initDefault(initedModel);
        }
        this.discountPanel.initialize();
        basicItem.setControl((Control)this.discountPanel);
        this.childPanels.add(this.discountPanel);
        IWorkbenchPart currentView = ViewHolder.INSTANCE.getActiveViewPart();
        if (!(currentView instanceof PeriodicImpactsBonusSystemView)) {
            TabItem clientTextItem = new TabItem(tabFolder, 0);
            clientTextItem.setText("\u0422\u0435\u043a\u0441\u0442 \u0434\u043b\u044f \u0447\u0435\u043a\u0430");
            this.clientTextPanel = new DiscountPanelClientText((Composite)tabFolder, 0, Discount.class, this.discount, this.macroparameterDAO);
            this.clientTextPanel.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
            this.clientTextPanel.initialize();
            clientTextItem.setControl(this.clientTextPanel);
            this.childPanels.add(this.clientTextPanel);
            TabItem clientDisplayTextItem = new TabItem(tabFolder, 0);
            clientDisplayTextItem.setText("\u0422\u0435\u043a\u0441\u0442 \u043d\u0430 \u043c\u043e\u043d\u0438\u0442\u043e\u0440 \u043f\u043e\u043a\u0443\u043f\u0430\u0442\u0435\u043b\u044f");
            this.clientDisplayTextPanel = new DiscountPanelClientDisplayText((Composite)tabFolder, 0, Discount.class, this.discount, this.macroparameterDAO);
            this.clientDisplayTextPanel.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
            this.clientDisplayTextPanel.initialize();
            clientDisplayTextItem.setControl(this.clientDisplayTextPanel);
            this.childPanels.add(this.clientDisplayTextPanel);
            TabItem cashTextItem = new TabItem(tabFolder, 0);
            cashTextItem.setText("\u0422\u0435\u043a\u0441\u0442 \u043d\u0430 \u043c\u043e\u043d\u0438\u0442\u043e\u0440 \u043a\u0430\u0441\u0441\u0438\u0440\u0430");
            this.cashTextPanel = new DiscountPanelCashText((Composite)tabFolder, 0, Discount.class, this.discount, this.macroparameterDAO);
            this.cashTextPanel.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
            this.cashTextPanel.initialize();
            cashTextItem.setControl(this.cashTextPanel);
            this.childPanels.add(this.cashTextPanel);
            TabItem positionMarkItem = new TabItem(tabFolder, 0);
            positionMarkItem.setText("\u0423\u0432\u0435\u0434\u043e\u043c\u043b\u0435\u043d\u0438\u0435 \u0434\u043b\u044f \u043f\u043e\u0437\u0438\u0446\u0438\u0438");
            PositionMark modelPositionMark = CollectionUtils.isEmpty((Collection)this.discount.getDiscountMarks()) ? new PositionMark() : (PositionMark)this.discount.getDiscountMarks().get(0);
            this.positionMarkPanel = new DiscountPanelPositionMark((Composite)tabFolder, 0, PositionMark.class, modelPositionMark);
            this.positionMarkPanel.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
            this.positionMarkPanel.initialize();
            positionMarkItem.setControl(this.positionMarkPanel);
            this.childPanels.add(this.positionMarkPanel);
        }
        return container;
    }

    @Override
    public void applyRights(String selector) {
        for (EditorComposite<?> panel : this.childPanels) {
            if (panel == null) continue;
            panel.applyRights(selector);
        }
        super.applyRights(selector);
    }

    protected void okPressed() {
        Discount model = (Discount)this.discountPanel.getModel();
        if (model.getName() == null || model.getName().isEmpty()) {
            ErrorMessageFactory.emptyFieldMessage();
        } else if (AutoincCodes.checkCodesDiscount((DiscountCampaign)this.parent, (Long)model.getId()) && !model.getId().equals(this.discount.getId())) {
            ErrorMessageFactory.retryCodeMessage();
        } else {
            if (StringUtils.isNotBlank((String)((Discount)this.cashTextPanel.getModel()).getCashText())) {
                this.discount.setCashText(((Discount)this.cashTextPanel.getModel()).getCashText().replaceAll(System.getProperty("line.separator"), "##"));
                this.discount.setShowCashTextToConsultant(((Discount)this.cashTextPanel.getModel()).getShowCashTextToConsultant());
            } else {
                this.discount.setCashText(null);
                this.discount.setShowCashTextToConsultant(Boolean.valueOf(false));
            }
            if (StringUtils.isNotBlank((String)((Discount)this.clientTextPanel.getModel()).getClientText())) {
                this.discount.setClientText(((Discount)this.clientTextPanel.getModel()).getClientText().replaceAll(System.getProperty("line.separator"), "##"));
            } else {
                this.discount.setClientText(null);
            }
            if (StringUtils.isNotBlank((String)((Discount)this.clientDisplayTextPanel.getModel()).getClientDisplayText())) {
                this.discount.setClientDisplayText(((Discount)this.clientDisplayTextPanel.getModel()).getClientDisplayText().replaceAll(System.getProperty("line.separator"), "##"));
            } else {
                this.discount.setClientDisplayText(null);
            }
            if (StringUtils.isNotBlank((String)((PositionMark)this.positionMarkPanel.getModel()).getText()) || StringUtils.isNotBlank((String)((PositionMark)this.positionMarkPanel.getModel()).getBackgroundColor()) || StringUtils.isNotBlank((String)((PositionMark)this.positionMarkPanel.getModel()).getTextColor())) {
                if (CollectionUtils.isEmpty((Collection)this.discount.getDiscountMarks())) {
                    this.discount.addDiscountMark((PositionMark)this.positionMarkPanel.getModel());
                } else if (!Objects.equal(this.discount.getDiscountMarks().get(0), (Object)this.positionMarkPanel.getModel())) {
                    this.discount.getDiscountMarks().clear();
                    this.discount.addDiscountMark((PositionMark)this.positionMarkPanel.getModel());
                }
            } else {
                this.discount.getDiscountMarks().clear();
            }
            FieldsUtils.copyOnlyAnnotatedProperties(model, this.discount, ((Object)((Object)this.discountPanel)).getClass());
            if (this.begginingTypeOfDiscount != model.getTypeOfDiscount()) {
                DiscountObject oldDiscountObject = this.discount.getDiscountObject();
                this.discount.deleteDiscountObject();
                this.discount.addDiscountObject(FieldsUtils.createDiscountObjectByClassName(model.getTypeOfDiscount(), DiscountObject.class));
                DiscountObject disObject = this.discount.getDiscountObject();
                if (this.isNotKit(disObject) && this.isKit(oldDiscountObject)) {
                    if (oldDiscountObject != null) {
                        this.discount.deleteDiscountRate();
                    }
                    if (ViewHolder.INSTANCE.getActiveViewPart() instanceof PeriodicImpactsBonusSystemView) {
                        this.discount.setDiscountRate((DiscountRate)new DiscountRateSum(BigDecimal.valueOf(0.0)));
                    } else {
                        this.discount.setDiscountRate((DiscountRate)new DiscountRatePercent(BigDecimal.valueOf(5.0)));
                    }
                }
                if (disObject instanceof DiscountObjectKit && this.isNotKit(oldDiscountObject)) {
                    if (oldDiscountObject != null) {
                        this.discount.deleteDiscountRate();
                    }
                    this.discount.setDiscountRate((DiscountRate)new DiscountRateKit());
                    ((DiscountObjectKit)disObject).setKittype(((MyKeyValue)Directory.kitTypeModern.get(saveInventSupportInKids ? 0 : 1)).getKey().toString());
                }
                if (disObject instanceof DiscountKitObject && this.isNotKit(oldDiscountObject)) {
                    if (oldDiscountObject != null) {
                        this.discount.deleteDiscountRate();
                    }
                    this.discount.setDiscountRate((DiscountRate)new DiscountRateKitObject());
                }
            }
            super.okPressed();
        }
    }

    private boolean isKit(DiscountObject oldDiscountObject) {
        return oldDiscountObject == null || oldDiscountObject instanceof DiscountObjectKit || oldDiscountObject instanceof DiscountKitObject;
    }

    private boolean isNotKit(DiscountObject disObject) {
        return disObject == null || disObject instanceof DiscountObjectCheck || disObject instanceof DiscountObjectPosition || disObject instanceof LegacyObject || disObject instanceof SimpleObject;
    }
}

