/*
 * Decompiled with CFR 0.152.
 */
package su.artix.discountmanager.dialogs.discountsystem;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbenchPart;
import su.artix.discountmanager.holders.ViewHolder;
import su.artix.discountmanager.utils.FieldsUtils;
import su.artix.discountmanager.views.DiscountSystemView;
import su.artix.discountmanager.views.EarnBonusSystemView;
import su.artix.discountmanager.views.LimitBonusSystemView;
import su.artix.discountmanager.views.SecondSystemView;
import su.artix.loyaltylib.domain.java.discountsystem.Discount;
import su.artix.yuki.directory.Directory;
import su.artix.yuki.directory.DirectoryList;
import su.artix.yuki.editors.EditorComposite;

public abstract class DiscountPanelAbstract
extends EditorComposite<Discount> {
    public DiscountPanelAbstract(Composite parent, int style, Class<Discount> clazz, Discount model) {
        super(parent, style, clazz, (Object)model);
    }

    protected Discount getActualModel(Discount model) {
        Discount discount = new Discount("");
        FieldsUtils.copyOnlyAnnotatedProperties(model, discount, ((Object)((Object)this)).getClass());
        if (discount.getCashText() != null) {
            discount.setCashText(discount.getCashText().replaceAll("##", System.getProperty("line.separator")));
        }
        if (discount.getClientText() != null) {
            discount.setClientText(model.getClientText().replaceAll("##", System.getProperty("line.separator")));
        }
        if (discount.getClientDisplayText() != null) {
            discount.setClientDisplayText(model.getClientDisplayText().replaceAll("##", System.getProperty("line.separator")));
        }
        return discount;
    }

    public void initialize() {
        DirectoryList typeOfDiscountInput;
        DiscountPanelAbstract container = this;
        GridLayoutFactory.swtDefaults().numColumns(2).applyTo((Composite)container);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)container);
        boolean isDiscountSystem = false;
        IWorkbenchPart currentView = ViewHolder.INSTANCE.getActiveViewPart();
        if (currentView instanceof DiscountSystemView || currentView instanceof SecondSystemView) {
            typeOfDiscountInput = Directory.typeOfDiscount;
            isDiscountSystem = true;
        } else {
            typeOfDiscountInput = currentView instanceof EarnBonusSystemView ? Directory.typeOfBonuses : (currentView instanceof LimitBonusSystemView ? Directory.typeOfLimits : Directory.typeOfPeriodicImpacts);
        }
        this.addFiedsToContainer((Composite)container, typeOfDiscountInput, isDiscountSystem);
        if (!typeOfDiscountInput.equals((Object)Directory.typeOfPeriodicImpacts)) {
            this.bindValues();
        } else {
            this.initDefaulBinding();
        }
    }

    abstract void addFiedsToContainer(Composite var1, DirectoryList var2, boolean var3);
}

