/*
 * Decompiled with CFR 0.152.
 */
package su.artix.discountmanager.dialogs.discountsystem.controls;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Composite;
import ru.ssa.cashadmin.domain.Valut;
import su.artix.discountmanager.dialogs.discountsystem.controls.DiscountConditionEntityControl;
import su.artix.discountmanager.utils.StringResultGetter;

public class DiscountConditionValutControl
extends DiscountConditionEntityControl {
    private StringResultGetter resultGetter = new StringResultGetter(",", "", "[", "]", "");

    public DiscountConditionValutControl(Composite parent, String labelName, String defaultValue, boolean isMulti) {
        super(parent, labelName, defaultValue, isMulti);
    }

    @Override
    protected SelectionAdapter getSelectionAdapter(final boolean isMultiSelect, StringResultGetter rg, String defaultValue) {
        if (defaultValue != null) {
            if (isMultiSelect) {
                this.text.setText("[" + defaultValue + "]");
            } else {
                this.text.setText(defaultValue);
            }
        }
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (isMultiSelect) {
                    List<Valut> inventList = DiscountConditionValutControl.this.selectMulti(Valut.class);
                    if (inventList != null) {
                        ArrayList<String> barcodes = new ArrayList<String>();
                        for (Valut valut : inventList) {
                            barcodes.add(valut.getCode().toString());
                        }
                        DiscountConditionValutControl.this.validator.setContents((Object)DiscountConditionValutControl.this.resultGetter.getStringFromList(barcodes));
                    }
                } else {
                    Valut valut = DiscountConditionValutControl.this.selectSingle(Valut.class);
                    if (valut != null) {
                        DiscountConditionValutControl.this.validator.setContents((Object)valut.getCode().toString());
                    }
                }
            }
        };
    }
}

