/*
 * Decompiled with CFR 0.152.
 */
package su.artix.discountmanager.dialogs.discountsystem.kitnew;

import com.rits.cloning.Cloner;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.ObjectUtils;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import su.artix.cashserver.security.SecurityKey;
import su.artix.discountmanager.dialogs.discountsystem.kitnew.KitItemDialog;
import su.artix.discountmanager.dialogs.discountsystem.kitnew.KitLabelProvider;
import su.artix.discountmanager.dialogs.discountsystem.kitnew.KitTableViewer;
import su.artix.discountmanager.images.ImagesFactory;
import su.artix.discountmanager.utils.FieldsUtils;
import su.artix.loyaltylib.domain.java.discountsystem.Discount;
import su.artix.loyaltylib.domain.java.discountsystem.DiscountCampaign;
import su.artix.loyaltylib.domain.java.discountsystem.DiscountKitObject;
import su.artix.loyaltylib.domain.java.discountsystem.DiscountKitObjectItem;
import su.artix.loyaltylib.domain.java.discountsystem.DiscountObject;
import su.artix.loyaltylib.domain.java.discountsystem.DiscountRate;
import su.artix.loyaltylib.domain.java.discountsystem.DiscountRateKitObject;
import su.artix.loyaltylib.domain.java.discountsystem.DiscountRateKitObjectItem;
import su.artix.yuki.binding.BindingKey;
import su.artix.yuki.binding.BindingType;
import su.artix.yuki.editors.EditorComposite;

@SecurityKey(title="\u041e\u0431\u044a\u0435\u043a\u0442 \u043a\u043e\u043c\u043f\u043b\u0435\u043a\u0442")
public class KitPanel
extends EditorComposite<DiscountKitObject> {
    private static final Logger log = LoggerFactory.getLogger(KitPanel.class);
    private KitTableViewer tableViewer;
    @SecurityKey(title="\u0418\u0437\u043c\u0435\u043d\u0438\u0442\u044c")
    private ChangeRowAction changeRowAction = new ChangeRowAction();
    @SecurityKey(title="\u0423\u0434\u0430\u043b\u0438\u0442\u044c")
    private DeleteRowAction deleteRowAction = new DeleteRowAction();
    private List<DiscountRateKitObjectItem> ratedItems;
    @SecurityKey(title="\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", id="name")
    private Label nameLabel;
    @SecurityKey(id="name")
    private Text nameValField;
    @SecurityKey(title="\u041c\u0430\u043a\u0441\u0438\u043c\u0430\u043b\u044c\u043d\u043e\u0435 \u043a\u043e\u043b-\u0432\u043e \u0432 \u043d\u0430\u0431\u043e\u0440\u0435", id="maxtimes")
    private Label maxtimesLabel;
    @SecurityKey(id="maxtimes")
    private Text maxtimesField;
    @SecurityKey(id="maxTimesNotSpecified", title="\u041c\u0430\u043a\u0441\u0438\u043c\u0430\u043b\u044c\u043d\u043e\u0435 \u043a\u043e\u043b-\u0432\u043e \u0432 \u043d\u0430\u0431\u043e\u0440\u0435 \u043d\u0435 \u0437\u0430\u0434\u0430\u043d\u043e")
    private Button maxtimesCheckedButton;
    @SecurityKey(title="\u041f\u0430\u043d\u0435\u043b\u044c")
    private Composite composite;
    @SecurityKey(id="byTmc", title="\u0412\u044b\u043f\u043e\u043b\u043d\u044f\u0442\u044c \u0432\u043e\u0437\u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0435 \u043f\u043e \u043a\u0430\u0436\u0434\u043e\u043c\u0443 \u0442\u043e\u0432\u0430\u0440\u0443 \u043e\u0442\u0434\u0435\u043b\u044c\u043d\u043e")
    private Button byTmcButton;
    @SecurityKey(id="cartesian", title="\u0412\u044b\u0431\u0438\u0440\u0430\u0442\u044c \u0442\u043e\u043b\u044c\u043a\u043e \u043e\u0434\u0438\u043d \u0442\u043e\u0432\u0430\u0440 \u043f\u043e \u043a\u043e\u0434\u0443 \u0438\u0437 \u043a\u0430\u0436\u0434\u043e\u0439 \u0447\u0430\u0441\u0442\u0438 \u043d\u0430\u0431\u043e\u0440\u0430")
    private Button cartesianButton;
    @SecurityKey(id="distributeByCheck", title="\u0420\u0430\u0441\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d\u0438\u0435 \u0441\u043a\u0438\u0434\u043a\u0438 \u043d\u0430 \u043a\u043e\u043c\u043f\u043b\u0435\u043a\u0442 \u043f\u043e \u0432\u0441\u0435\u043c \u043f\u043e\u0437\u0438\u0446\u0438\u044f\u043c \u0432 \u0447\u0435\u043a\u0435")
    private Button distributeByCheckButton;
    @SecurityKey(title="\u0422\u0438\u043f \u043d\u0430\u0431\u043e\u0440\u0430", id="kittype")
    private Label kittypeLabel;
    @SecurityKey(id="kittype")
    @BindingKey(bindingType=BindingType.DIRECTORY_LIST_STRING, id="kittype", subField="combo")
    private ComboViewer kittypeCombo;

    public KitPanel(Composite parent, int style, Class<DiscountKitObject> clazz, DiscountKitObject model) {
        super(parent, style, clazz, (Object)model);
    }

    public KitPanel(Composite parent, int style) {
        super(parent, style);
        this.initialize();
    }

    protected DiscountKitObject getActualModel(DiscountKitObject model) {
        DiscountKitObject discountObjectKit = new DiscountKitObject();
        FieldsUtils.copyOnlyAnnotatedProperties(model, discountObjectKit, ((Object)((Object)this)).getClass());
        Discount discount = new Discount("temp");
        discount.addDiscountObject((DiscountObject)discountObjectKit);
        Cloner cloner = new Cloner();
        cloner.dontCloneInstanceOf(new Class[]{PropertyChangeSupport.class});
        cloner.dontClone(new Class[]{DiscountCampaign.class});
        discountObjectKit.setListKitItems((List)cloner.deepClone((Object)model.getListKitItems()));
        DiscountRateKitObject discountRateKit = new DiscountRateKitObject();
        discount.setDiscountRate((DiscountRate)discountRateKit);
        discountRateKit.setKitItems((List)cloner.deepClone((Object)((DiscountRateKitObject)((Discount)model.getParent()).getDiscountRate()).getKitItems()));
        this.ratedItems = this.createRatedKitItems(discountRateKit, discountObjectKit);
        return (DiscountKitObject)discount.getDiscountObject();
    }

    private List<DiscountRateKitObjectItem> createRatedKitItems(DiscountRateKitObject discountRateKit, DiscountKitObject discountObjectKit) {
        ArrayList<DiscountRateKitObjectItem> result = new ArrayList<DiscountRateKitObjectItem>();
        List rateKitItems = discountRateKit.getKitItems();
        for (DiscountKitObjectItem item : discountObjectKit.getListKitItems()) {
            DiscountRateKitObjectItem example = this.findInDiscountRateKitItems(rateKitItems, item);
            if (example != null) {
                result.add(example);
                continue;
            }
            example = new DiscountRateKitObjectItem();
            example.setDiscountKitObjectItem(item);
            example.setDiscountRate(null);
            result.add(example);
        }
        return result;
    }

    private DiscountRateKitObjectItem findInDiscountRateKitItems(List<DiscountRateKitObjectItem> rateKitItems, DiscountKitObjectItem example) {
        for (DiscountRateKitObjectItem item : rateKitItems) {
            if (!ObjectUtils.equals((Object)item.getDiscountKitObjectItem(), (Object)example)) continue;
            return item;
        }
        return null;
    }

    public void initialize() {
        KitPanel container = this;
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo((Composite)container);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)container);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        this.setLayout((Layout)gridLayout);
        this.composite = new Composite((Composite)this, 0);
        this.composite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        GridLayout gl_composite = new GridLayout(1, false);
        gl_composite.marginWidth = 0;
        gl_composite.marginHeight = 0;
        this.composite.setLayout((Layout)gl_composite);
        Composite fieldsComposite = new Composite(this.composite, 0);
        fieldsComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        fieldsComposite.setBounds(0, 0, 64, 64);
        fieldsComposite.setLayout((Layout)new GridLayout(2, false));
        this.nameLabel = new Label(fieldsComposite, 0);
        this.nameLabel.setSize(55, 15);
        this.nameLabel.setText("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435:");
        this.nameValField = new Text(fieldsComposite, 2048);
        this.nameValField.setSize(486, 21);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)this.nameValField);
        this.maxtimesLabel = new Label(fieldsComposite, 0);
        this.maxtimesLabel.setSize(178, 15);
        this.maxtimesLabel.setText("\u041c\u0430\u043a\u0441\u0438\u043c\u0430\u043b\u044c\u043d\u043e\u0435 \u043a\u043e\u043b-\u0432\u043e \u043d\u0430\u0431\u043e\u0440\u043e\u0432:");
        Composite maxtimesComposite = new Composite(fieldsComposite, 0);
        GridLayout gl_maxtimesComposite = new GridLayout(2, false);
        gl_maxtimesComposite.marginHeight = 0;
        gl_maxtimesComposite.marginWidth = 0;
        gl_maxtimesComposite.verticalSpacing = 0;
        maxtimesComposite.setLayout((Layout)gl_maxtimesComposite);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)maxtimesComposite);
        this.maxtimesField = new Text(maxtimesComposite, 2048);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)this.maxtimesField);
        this.maxtimesCheckedButton = new Button(maxtimesComposite, 32);
        this.maxtimesCheckedButton.setSelection(true);
        this.maxtimesCheckedButton.setText("\u041d\u0435 \u0437\u0430\u0434\u0430\u043d\u043e");
        this.maxtimesCheckedButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                KitPanel.this.maxtimesField.setEnabled(!KitPanel.this.maxtimesCheckedButton.getSelection());
            }
        });
        GridDataFactory.fillDefaults().align(131072, 0x1000000).grab(false, false).applyTo((Control)this.maxtimesCheckedButton);
        this.byTmcButton = new Button(fieldsComposite, 32);
        this.byTmcButton.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.byTmcButton.setSelection(true);
        this.byTmcButton.setText("\u0412\u044b\u043f\u043e\u043b\u043d\u044f\u0442\u044c \u0432\u043e\u0437\u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0435 \u043f\u043e \u043a\u0430\u0436\u0434\u043e\u043c\u0443 \u0442\u043e\u0432\u0430\u0440\u0443 \u043e\u0442\u0434\u0435\u043b\u044c\u043d\u043e");
        this.byTmcButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                KitPanel.this.cartesianButton.setEnabled(!KitPanel.this.byTmcButton.getSelection());
                KitPanel.this.distributeByCheckButton.setEnabled(!KitPanel.this.byTmcButton.getSelection());
            }
        });
        this.cartesianButton = new Button(fieldsComposite, 32);
        this.cartesianButton.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.cartesianButton.setSelection(true);
        this.cartesianButton.setText("\u0412\u044b\u0431\u0438\u0440\u0430\u0442\u044c \u0442\u043e\u043b\u044c\u043a\u043e \u043e\u0434\u0438\u043d \u0442\u043e\u0432\u0430\u0440 \u043f\u043e \u043a\u043e\u0434\u0443 \u0438\u0437 \u043a\u0430\u0436\u0434\u043e\u0439 \u0447\u0430\u0441\u0442\u0438 \u043d\u0430\u0431\u043e\u0440\u0430");
        this.cartesianButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                KitPanel.this.byTmcButton.setEnabled(!KitPanel.this.distributeByCheckButton.getSelection() && !KitPanel.this.cartesianButton.getSelection());
            }
        });
        this.distributeByCheckButton = new Button(fieldsComposite, 32);
        this.distributeByCheckButton.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.distributeByCheckButton.setSelection(true);
        this.distributeByCheckButton.setText("\u0420\u0430\u0441\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d\u0438\u0435 \u0441\u043a\u0438\u0434\u043a\u0438 \u043d\u0430 \u043a\u043e\u043c\u043f\u043b\u0435\u043a\u0442 \u043f\u043e \u0432\u0441\u0435\u043c \u043f\u043e\u0437\u0438\u0446\u0438\u044f\u043c \u0432 \u0447\u0435\u043a\u0435");
        this.distributeByCheckButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                KitPanel.this.byTmcButton.setEnabled(!KitPanel.this.distributeByCheckButton.getSelection() && !KitPanel.this.cartesianButton.getSelection());
            }
        });
        Composite listOfKitsComposite = new Composite(this.composite, 0);
        listOfKitsComposite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        listOfKitsComposite.setBounds(0, 0, 64, 64);
        listOfKitsComposite.setLayout((Layout)new GridLayout(1, false));
        Group group = new Group(listOfKitsComposite, 0);
        group.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        group.setText("\u041d\u0430\u0431\u043e\u0440\u044b:");
        group.setBounds(0, 0, 70, 82);
        group.setLayout((Layout)new GridLayout(1, false));
        ToolBar toolBar = new ToolBar((Composite)group, 0x820000);
        GridDataFactory.fillDefaults().span(2, 1).align(4, 0x1000000).grab(true, false).applyTo((Control)toolBar);
        ToolBarManager toolBarManager = new ToolBarManager(toolBar);
        toolBarManager.add((IAction)new InsertRowAction());
        toolBarManager.add((IAction)this.changeRowAction);
        toolBarManager.add((IAction)this.deleteRowAction);
        toolBarManager.update(true);
        this.tableViewer = new KitTableViewer((Composite)group, 67584);
        Table table = this.tableViewer.getTable();
        table.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        GridDataFactory.fillDefaults().span(2, 1).grab(true, true).applyTo((Control)this.tableViewer.getTable());
        this.tableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new KitLabelProvider());
        this.tableViewer.setInputData(this.ratedItems);
        this.tableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                new ChangeRowAction().run();
            }
        });
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                boolean enabled = !event.getSelection().isEmpty();
                KitPanel.this.changeRowAction.setEnabled(enabled);
                KitPanel.this.deleteRowAction.setEnabled(enabled);
            }
        });
        MenuManager popupMenu = new MenuManager();
        Menu menu = popupMenu.createContextMenu((Control)this.tableViewer.getTable());
        popupMenu.add((IAction)new InsertRowAction());
        popupMenu.add((IAction)new ChangeRowAction());
        popupMenu.add((IAction)new DeleteRowAction());
        this.tableViewer.getTable().setMenu(menu);
        this.initDefaulBinding();
    }

    public void applyRights(String selector) {
        super.applyRights(selector);
        this.changeRowAction.setEnabled(false);
        this.deleteRowAction.setEnabled(false);
        this.maxtimesField.setEnabled(!((DiscountKitObject)this.getModel()).isMaxTimesNotSpecified());
        this.byTmcButton.setEnabled(!((DiscountKitObject)this.getModel()).isCartesian() && !((DiscountKitObject)this.getModel()).isDistributeByCheck());
        this.cartesianButton.setEnabled(!((DiscountKitObject)this.getModel()).isByTmc());
        this.distributeByCheckButton.setEnabled(!((DiscountKitObject)this.getModel()).isByTmc());
    }

    public List<DiscountRateKitObjectItem> getRatedItems() {
        return this.ratedItems;
    }

    private class ChangeRowAction
    extends Action {
        public ChangeRowAction() {
            super("&\u0418\u0437\u043c\u0435\u043d\u0438\u0442\u044c", ImagesFactory.INSTANCE.getImageDescriptor("16x16/plane/edit.png"));
        }

        public void run() {
            IStructuredSelection selection = (IStructuredSelection)KitPanel.this.tableViewer.getSelection();
            KitItemDialog dialog = new KitItemDialog("\u0418\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u0435 \u043e\u0431\u044a\u0435\u043a\u0442\u0430 \u043d\u0430\u0431\u043e\u0440\u0430", (DiscountRateKitObjectItem)selection.getFirstElement());
            if (dialog.open() == 0) {
                KitPanel.this.tableViewer.update(dialog.getRateItem(), null);
            }
        }
    }

    private class DeleteRowAction
    extends Action {
        public DeleteRowAction() {
            super("&\u0423\u0434\u0430\u043b\u0438\u0442\u044c", ImagesFactory.INSTANCE.getImageDescriptor("16x16/plane/delete.png"));
        }

        public void run() {
            int index = KitPanel.this.tableViewer.getTable().getSelectionIndex();
            DiscountRateKitObjectItem element = (DiscountRateKitObjectItem)KitPanel.this.tableViewer.getElementAt(index);
            if (element != null) {
                ((DiscountKitObject)KitPanel.this.getModel()).getListKitItems().remove(element.getDiscountKitObjectItem());
                KitPanel.this.tableViewer.remove(element);
                log.trace("Deleted: " + element + " from Map");
            }
        }
    }

    private class InsertRowAction
    extends Action {
        public InsertRowAction() {
            super("&\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c", ImagesFactory.INSTANCE.getImageDescriptor("16x16/plane/add.png"));
        }

        public void run() {
            DiscountRateKitObjectItem item = new DiscountRateKitObjectItem();
            item.setDiscountRate(null);
            item.setDiscountKitObjectItem(new DiscountKitObjectItem());
            KitItemDialog dialog = new KitItemDialog("\u0414\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u043e\u0431\u044a\u0435\u043a\u0442\u0430 \u043d\u0430\u0431\u043e\u0440\u0430", item);
            if (dialog.open() == 0) {
                KitPanel.this.tableViewer.add(dialog.getRateItem());
                log.info("Added new element: " + dialog.getRateItem() + " to the Map");
            }
        }
    }
}

