/*
 * Decompiled with CFR 0.152.
 */
package su.artix.discountmanager.discountsystem.compare;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.eclipse.compare.IModificationDate;
import org.eclipse.compare.IStreamContentAccessor;
import org.eclipse.compare.ITypedElement;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.graphics.Image;
import su.artix.artixadmin.format.ArtixFormatter;
import su.artix.discountmanager.providers.SystemLabelProvider;
import su.artix.loyaltylib.domain.java.discountsystem.Discount;
import su.artix.loyaltylib.domain.java.discountsystem.DiscountCampaign;
import su.artix.loyaltylib.domain.java.discountsystem.DiscountCampaignGroup;
import su.artix.loyaltylib.domain.java.discountsystem.DiscountCardCondition;
import su.artix.loyaltylib.domain.java.discountsystem.DiscountCondition;
import su.artix.loyaltylib.domain.java.discountsystem.DiscountObjectKit;
import su.artix.loyaltylib.domain.java.discountsystem.DiscountSystem;
import su.artix.yuki.directory.Directory;

public class CompareItem
implements IStreamContentAccessor,
ITypedElement,
IModificationDate {
    private Object discountObject;
    private long time;
    private SystemLabelProvider labelProvider;
    private Image image;

    public CompareItem(Object object, ILabelProvider labelProvider, Image image) {
        this.discountObject = object;
        this.labelProvider = (SystemLabelProvider)labelProvider;
        this.image = image;
    }

    private String combineContent(Object ... objects) {
        StringBuilder b = new StringBuilder();
        int i = 0;
        while (i < objects.length) {
            if (i % 2 == 0) {
                b.append(objects[i]).append(": ");
            } else {
                b.append(objects[i]).append("\n");
            }
            ++i;
        }
        return b.toString();
    }

    private String getYesOrNo(boolean isYes) {
        return isYes ? "\u0434\u0430" : "\u043d\u0435\u0442";
    }

    public InputStream getContents() throws CoreException {
        if (this.discountObject == null) {
            return null;
        }
        Object element = this.discountObject;
        String content = null;
        if (element instanceof DiscountSystem) {
            content = this.labelProvider.getTextWithoutChangedSymbol(element);
        } else if (element instanceof DiscountCampaignGroup) {
            DiscountCampaignGroup impl = (DiscountCampaignGroup)element;
            content = this.combineContent("\u0413\u0440\u0443\u043f\u043f\u0430", impl.getName(), "\u0412\u0437\u0430\u0438\u043c\u043e\u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0435", Directory.interactionDiscountCampaignType.getDisplayValue((Object)impl.getCampaignInteraction()));
        } else if (element instanceof DiscountCampaign) {
            DiscountCampaign impl = (DiscountCampaign)element;
            content = this.combineContent("\u0410\u043a\u0446\u0438\u044f", impl.getName(), "\u041a\u043e\u0434", impl.getId(), "\u0410\u043a\u0442\u0438\u0432\u043d\u043e\u0441\u0442\u044c \u0430\u043a\u0446\u0438\u0438", this.getYesOrNo(impl.isActiveNow()), "\u041d\u0430\u0447\u0430\u043b\u043e \u0430\u043a\u0446\u0438\u0438", ArtixFormatter.INSTANCE.timestampToString(impl.getBeginDate()), "\u041e\u043a\u043e\u043d\u0447\u0430\u043d\u0438\u0435 \u0430\u043a\u0446\u0438\u0438", ArtixFormatter.INSTANCE.timestampToString(impl.getEndDate()), "\u0412\u0437\u0430\u0438\u043c\u043e\u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0435", Directory.interactionDiscountCampaignType.getDisplayValue((Object)impl.getDiscountInteraction()));
        } else if (element instanceof Discount) {
            Discount impl = (Discount)element;
            content = this.combineContent("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", impl.getName(), "\u041a\u043e\u0434", impl.getId(), "\u0410\u043a\u0442\u0438\u0432\u043d\u043e\u0441\u0442\u044c", this.getYesOrNo(impl.getActive()), "\u041d\u0435 \u0443\u0447\u0438\u0442\u044b\u0432\u0430\u0442\u044c \u043c\u0438\u043d\u0438\u043c\u0430\u043b\u044c\u043d\u0443\u044e \u0446\u0435\u043d\u0443", this.getYesOrNo(impl.getMinPriceIgnored()), "\u0422\u0435\u043a\u0441\u0442 \u0434\u043b\u044f \u0447\u0435\u043a\u0430", impl.getClientText(), "\u0422\u0435\u043a\u0441\u0442 \u043d\u0430 \u043c\u043e\u043d\u0438\u0442\u043e\u0440 \u043f\u043e\u043a\u0443\u043f\u0430\u0442\u0435\u043b\u044f", impl.getClientDisplayText(), "\u0422\u0435\u043a\u0441\u0442 \u043a\u0430\u0441\u0441\u0438\u0440\u0430", impl.getCashText(), "\u041f\u043e\u043a\u0430\u0437\u044b\u0432\u0430\u0442\u044c \u0442\u0435\u043a\u0441\u0442 \u043a\u0430\u0441\u0441\u0438\u0440\u0430 \u043a\u043e\u043d\u0441\u0443\u043b\u044c\u0442\u0430\u043d\u0442\u0443 \u043d\u0430 \u041a\u0421\u041e", this.getYesOrNo(impl.getShowCashTextToConsultant()));
        } else if (element instanceof DiscountObjectKit) {
            content = "\u041e\u0431\u044a\u0435\u043a\u0442:" + ((DiscountObjectKit)element).getNameTreeNode();
        } else if (element instanceof DiscountCardCondition) {
            DiscountCardCondition impl = (DiscountCardCondition)element;
            content = this.combineContent("\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u0443\u0441\u043b\u043e\u0432\u0438\u044f \u043f\u043e \u043a\u0430\u0440\u0442\u0435", impl.getDescription(), "\u0423\u0441\u043b\u043e\u0432\u0438\u0435", impl.getCondition());
        } else if (element instanceof DiscountCondition) {
            DiscountCondition impl = (DiscountCondition)element;
            content = this.combineContent("\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u043e\u0431\u0449\u0435\u0433\u043e \u0443\u0441\u043b\u043e\u0432\u0438\u044f", impl.getDescription(), "\u0423\u0441\u043b\u043e\u0432\u0438\u0435", impl.getCondition());
        } else {
            content = this.labelProvider.getTextWithoutChangedSymbol(element);
        }
        return new ByteArrayInputStream(content.getBytes(Charset.defaultCharset()));
    }

    public Image getImage() {
        return this.image;
    }

    public long getModificationDate() {
        return this.time;
    }

    public String getName() {
        if (this.discountObject == null) {
            return "";
        }
        return this.labelProvider.getTextWithoutChangedSymbol(this.discountObject);
    }

    public String getString() {
        return this.labelProvider.getText(this.discountObject.toString());
    }

    public String getType() {
        return "txt";
    }

    public int hashCode() {
        return super.hashCode();
    }

    public Object getDiscountObject() {
        return this.discountObject;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        return this.getClass() == obj.getClass();
    }
}

