/*
 * Decompiled with CFR 0.152.
 */
package ru.ssa.cashadmin.dao;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.hibernate.SQLQuery;
import org.hibernate.classic.Session;
import org.hibernate.transform.ResultTransformer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;
import ru.ssa.cashadmin.dao.DaoInterface;
import ru.ssa.cashadmin.domain.InventInfo;
import ru.ssa.cashadmin.excep.ExecuteQueryException;
import ru.ssa.cashadmin.utils.ArtixFilter;
import ru.ssa.cashadmin.utils.FilterRestriction;

public class InventInfoDao
extends HibernateDaoSupport
implements DaoInterface<InventInfo>,
Serializable {
    private static final Logger log = LoggerFactory.getLogger(InventInfoDao.class);
    private static final long serialVersionUID = 1L;
    private static final String QUERY = "SELECT a.barcode, a.code, a.name, a.price FROM ( SELECT COALESCE(b.barcode, t.bcode) barcode, COALESCE(b.code, t.code) CODE, COALESCE(b.name, t.name) NAME, COALESCE(b.price, t.price) price FROM barcodes b RIGHT JOIN tmc t ON b.code = t.bcode UNION SELECT t.bcode barcode, t.code CODE, t.name NAME, t.price price FROM barcodes b INNER JOIN tmc t ON b.code = t.bcode ) AS a";
    private static final String ERROR_MESAGE = "Unrealized method";

    private String createCountQuery(String query, List<FilterRestriction<InventInfo>> filters) {
        return this.createCountQuery(this.createQuery(query, filters));
    }

    private String createCountQuery(String query) {
        StringBuilder queryBuilder = new StringBuilder();
        queryBuilder.append("SELECT COUNT(*) count FROM ( ");
        queryBuilder.append(query);
        queryBuilder.append(" ) AS c");
        return queryBuilder.toString();
    }

    private String createQuery(String query, List<FilterRestriction<InventInfo>> filters) {
        return this.createQuery(query, filters, null, true);
    }

    private String createQuery(String query, List<FilterRestriction<InventInfo>> filters, String sortBy, boolean sortAsc) {
        StringBuilder queryBuilder = new StringBuilder();
        queryBuilder.append(query);
        boolean hasBeen = false;
        if (filters.size() > 0) {
            queryBuilder.append(" WHERE");
            for (FilterRestriction<InventInfo> filter : filters) {
                if (filter.getProperty().equals("barcode")) {
                    if (hasBeen) {
                        queryBuilder.append(" OR");
                    }
                    queryBuilder.append(" a.barcode LIKE ");
                    queryBuilder.append("'%");
                    queryBuilder.append(filter.getState());
                    queryBuilder.append("%'");
                    hasBeen = true;
                    continue;
                }
                if (filter.getProperty().equals("code")) {
                    if (hasBeen) {
                        queryBuilder.append(" OR");
                    }
                    queryBuilder.append(" a.code LIKE ");
                    queryBuilder.append("'%");
                    queryBuilder.append(filter.getState());
                    queryBuilder.append("%'");
                    hasBeen = true;
                    continue;
                }
                if (!filter.getProperty().equals("name")) continue;
                if (hasBeen) {
                    queryBuilder.append(" OR");
                }
                queryBuilder.append(" a.name LIKE ");
                queryBuilder.append("'%");
                queryBuilder.append(filter.getState());
                queryBuilder.append("%'");
                hasBeen = true;
            }
        }
        if (sortBy != null && !sortBy.isEmpty()) {
            queryBuilder.append(" ORDER BY a.");
            queryBuilder.append(sortBy);
            if (sortAsc) {
                queryBuilder.append(" ASC");
            } else {
                queryBuilder.append(" DESC");
            }
        } else {
            queryBuilder.append(" ORDER BY NULL");
        }
        return queryBuilder.toString();
    }

    @Override
    public InventInfo getById(Object id) throws ExecuteQueryException {
        throw new RuntimeException(ERROR_MESAGE);
    }

    @Override
    public List<InventInfo> getList(String sortby, boolean sortAsc) throws ExecuteQueryException {
        throw new RuntimeException(ERROR_MESAGE);
    }

    @Override
    public List<InventInfo> getList(String sortby, boolean sortAsc, InventInfo state) throws ExecuteQueryException {
        throw new RuntimeException(ERROR_MESAGE);
    }

    @Override
    public List<InventInfo> getList(String sortby, boolean sortAsc, InventInfo state, Integer firstResult, Integer maxResults) throws ExecuteQueryException {
        throw new RuntimeException(ERROR_MESAGE);
    }

    @Override
    public List<InventInfo> getList(InventInfo state) throws ExecuteQueryException {
        throw new RuntimeException(ERROR_MESAGE);
    }

    @Override
    public List<InventInfo> getList() throws ExecuteQueryException {
        List list;
        try {
            Session session = this.getHibernateTemplate().getSessionFactory().openSession();
            SQLQuery query = session.createSQLQuery(QUERY);
            query.setResultTransformer((ResultTransformer)new InventResultTransformer());
            list = query.list();
            session.close();
        }
        catch (Exception e) {
            throw new ExecuteQueryException(e.getMessage(), e);
        }
        return list;
    }

    @Override
    public void delete(InventInfo o) throws ExecuteQueryException {
        throw new RuntimeException(ERROR_MESAGE);
    }

    @Override
    public void deleteById(Object id) throws ExecuteQueryException {
        throw new RuntimeException(ERROR_MESAGE);
    }

    @Override
    public InventInfo update(InventInfo o) throws ExecuteQueryException {
        throw new RuntimeException(ERROR_MESAGE);
    }

    @Override
    public InventInfo save(InventInfo o) throws ExecuteQueryException {
        throw new RuntimeException(ERROR_MESAGE);
    }

    @Override
    public void clear() throws ExecuteQueryException {
        throw new RuntimeException(ERROR_MESAGE);
    }

    @Override
    public Long count() throws ExecuteQueryException {
        Long count;
        try {
            Session session = this.getHibernateTemplate().getSessionFactory().openSession();
            SQLQuery query = session.createSQLQuery(this.createCountQuery(QUERY));
            count = ((BigInteger)query.uniqueResult()).longValue();
            session.close();
        }
        catch (Exception e) {
            throw new ExecuteQueryException(e.getMessage(), e);
        }
        return count;
    }

    @Override
    public Long count(InventInfo state) throws ExecuteQueryException {
        throw new RuntimeException(ERROR_MESAGE);
    }

    @Override
    public void clearCascade() throws ExecuteQueryException {
        throw new RuntimeException(ERROR_MESAGE);
    }

    @Override
    public List<?> findByHSQL(String hsql, Object[] param) throws ExecuteQueryException {
        throw new RuntimeException(ERROR_MESAGE);
    }

    @Override
    public List<?> findByNamedParam(String queryString, String[] paramNames, Object[] values) throws ExecuteQueryException {
        throw new RuntimeException(ERROR_MESAGE);
    }

    @Override
    public List<?> findByNamedParam(String queryString, Map<String, Object> params) throws ExecuteQueryException {
        throw new RuntimeException(ERROR_MESAGE);
    }

    @Override
    public InventInfo refresh(InventInfo o) throws ExecuteQueryException {
        throw new RuntimeException(ERROR_MESAGE);
    }

    @Override
    public Object getMaxId() throws ExecuteQueryException {
        throw new RuntimeException(ERROR_MESAGE);
    }

    @Override
    public void changeId(Object oldId, Object newId, String ... idFields) throws ExecuteQueryException {
        throw new RuntimeException(ERROR_MESAGE);
    }

    @Override
    public Object getMax(String column, InventInfo state) throws ExecuteQueryException {
        throw new RuntimeException(ERROR_MESAGE);
    }

    @Override
    public List<?> getProjectionList(String projectionProperty, InventInfo state) throws ExecuteQueryException {
        throw new RuntimeException(ERROR_MESAGE);
    }

    @Override
    public List<?> getProjectionList(String projectionProperty) throws ExecuteQueryException {
        throw new RuntimeException(ERROR_MESAGE);
    }

    @Override
    public List<InventInfo> getList(ArtixFilter<InventInfo> criteria) throws ExecuteQueryException {
        throw new RuntimeException(ERROR_MESAGE);
    }

    @Override
    public Long count(ArtixFilter<InventInfo> criteria) throws ExecuteQueryException {
        Long count;
        try {
            Session session = this.getHibernateTemplate().getSessionFactory().openSession();
            String strQuery = this.createCountQuery(QUERY, criteria.getRestrictions());
            SQLQuery query = session.createSQLQuery(strQuery);
            count = ((BigInteger)query.uniqueResult()).longValue();
            log.trace("count : {}", (Object)count);
            session.close();
        }
        catch (Exception e) {
            throw new ExecuteQueryException(e.getMessage(), e);
        }
        return count;
    }

    @Override
    public List<InventInfo> getList(ArtixFilter<InventInfo> criteria, String sortBy, boolean sortAsc, Integer firstResult, Integer maxResults) throws ExecuteQueryException {
        List list;
        log.trace("sortBy = {}, sortAsc = {}, firstResult = {}, maxResults = {}", new Object[]{sortBy, sortAsc, firstResult, maxResults});
        try {
            Session session = this.getHibernateTemplate().getSessionFactory().openSession();
            String strQuery = this.createQuery(QUERY, criteria.getRestrictions(), sortBy, sortAsc);
            SQLQuery query = session.createSQLQuery(strQuery);
            query.setResultTransformer((ResultTransformer)new InventResultTransformer());
            query.setFirstResult(firstResult.intValue());
            query.setMaxResults(maxResults.intValue());
            list = query.list();
            session.close();
        }
        catch (Exception e) {
            throw new ExecuteQueryException(e.getMessage(), e);
        }
        return list;
    }

    @Override
    public List<InventInfo> findByNamedQuery(String queryName, Integer firstResult, Integer maxResults) throws ExecuteQueryException {
        throw new RuntimeException(ERROR_MESAGE);
    }

    @Override
    public void updateActionsMap(Map<InventInfo, String> map) {
        throw new RuntimeException(ERROR_MESAGE);
    }

    @Override
    public void updateCollection(Collection<InventInfo> collection) {
        throw new RuntimeException(ERROR_MESAGE);
    }

    @Override
    public void saveCollection(Collection<InventInfo> collection) {
        throw new RuntimeException(ERROR_MESAGE);
    }

    @Override
    public void deleteAll(Collection<InventInfo> o) throws ExecuteQueryException {
        throw new RuntimeException(ERROR_MESAGE);
    }

    @Override
    public void changeIdNoExtractPK(Object oldId, Object newId, String ... idFields) throws ExecuteQueryException {
        throw new RuntimeException(ERROR_MESAGE);
    }

    @Override
    public List<?> getAuditList(Object filter, int first, int maxItemCount, String sortByField, boolean ascending) {
        throw new RuntimeException(ERROR_MESAGE);
    }

    @Override
    public Object getAuditRevisionEntry(int revision) {
        throw new RuntimeException(ERROR_MESAGE);
    }

    @Override
    public void putExistsIds(List<?> ids) {
    }

    @Override
    public void clearExistsIds() {
    }

    @Override
    public List<Object> findIds() throws ExecuteQueryException {
        return null;
    }

    class InventResultTransformer
    implements ResultTransformer {
        private static final long serialVersionUID = 1L;

        InventResultTransformer() {
        }

        public Object transformTuple(Object[] tuple, String[] aliases) {
            InventInfo info = new InventInfo();
            info.setBarcode((String)tuple[0]);
            info.setCode((String)tuple[1]);
            info.setName((String)tuple[2]);
            info.setPrice((BigDecimal)tuple[3]);
            return info;
        }

        public List<InventInfo> transformList(List collection) {
            return collection;
        }
    }
}

