/*
 * Decompiled with CFR 0.152.
 */
package su.artix.widgets;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.progress.WorkbenchJob;
import su.artix.widgets.FilterElement;
import su.artix.widgets.IInputChanged;
import su.artix.widgets.TextWithClearButton;

public class SimpleFilterTextControl
extends TextWithClearButton {
    private ColumnViewer viewer;
    private IInputChanged inputChanged;
    private RefreshJob job = new RefreshJob(this);
    private boolean activeFilter = true;
    private long delay = 1000L;
    private final FilterElement filterElement;

    public SimpleFilterTextControl(Composite parent, int style, long delay, FilterElement filterElement) {
        super(parent, style, true);
        this.delay = delay;
        this.filterElement = filterElement;
        this.getTextField().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SimpleFilterTextControl.this.runUpdate();
            }
        });
        this.getSelectButtonControl().setVisible(false);
        this.getViewButtonControl().setVisible(false);
        this.getClearButtonControl().moveBelow(this.getViewButtonControl());
    }

    protected void acceptFilter(ColumnViewer viewer, FilterElement filterElement, Object filterValue) {
        if (filterElement != null && filterValue instanceof String) {
            filterElement.setValue((String)filterValue);
            if (this.inputChanged != null) {
                this.inputChanged.setInput(filterElement);
            } else {
                viewer.setInput((Object)filterElement);
            }
        }
    }

    @Override
    protected void clearText() {
        super.clearText();
        this.runUpdate();
    }

    @Override
    public void setText(String text) {
        this.activeFilter = false;
        this.getTextField().setText(text);
        this.activeFilter = true;
    }

    private void runUpdate() {
        if (this.activeFilter) {
            this.job.cancel();
            this.job.schedule(this.delay);
        }
    }

    public void setViewer(ColumnViewer viewer) {
        this.viewer = viewer;
    }

    public void setInputChanged(IInputChanged inputChanged) {
        this.inputChanged = inputChanged;
    }

    class RefreshJob
    extends WorkbenchJob {
        private SimpleFilterTextControl control;

        public RefreshJob(SimpleFilterTextControl control) {
            super("Refresh Job");
            this.control = null;
            this.control = control;
            this.setSystem(true);
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            monitor.beginTask("Refreshing", -1);
            if (SimpleFilterTextControl.this.viewer != null && !SimpleFilterTextControl.this.viewer.getControl().isDisposed()) {
                String value = SimpleFilterTextControl.this.getTextField().getText();
                this.control.acceptFilter(SimpleFilterTextControl.this.viewer, SimpleFilterTextControl.this.filterElement, value);
            }
            monitor.done();
            return Status.OK_STATUS;
        }
    }
}

