/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.fs;

import java.security.AccessController;
import java.security.PrivilegedAction;
import sun.nio.fs.NativeBuffer;
import sun.nio.fs.NativeBuffers;
import sun.nio.fs.UnixException;
import sun.nio.fs.UnixFileAttributes;
import sun.nio.fs.UnixFileStoreAttributes;
import sun.nio.fs.UnixPath;
import sun.nio.fs.Util;

class UnixNativeDispatcher {
    private static final int SUPPORTS_OPENAT = 2;
    private static final int SUPPORTS_FUTIMES = 4;
    private static final int SUPPORTS_BIRTHTIME = 65536;
    private static final int capabilities;

    protected UnixNativeDispatcher() {
    }

    static NativeBuffer copyToNativeBuffer(UnixPath unixPath) {
        byte[] byArray = unixPath.getByteArrayForSysCalls();
        int n = byArray.length + 1;
        NativeBuffer nativeBuffer = NativeBuffers.getNativeBufferFromCache(n);
        if (nativeBuffer == null) {
            nativeBuffer = NativeBuffers.allocNativeBuffer(n);
        } else if (nativeBuffer.owner() == unixPath) {
            return nativeBuffer;
        }
        NativeBuffers.copyCStringToNativeBuffer(byArray, nativeBuffer);
        nativeBuffer.setOwner(unixPath);
        return nativeBuffer;
    }

    static native byte[] getcwd();

    static native int dup(int var0) throws UnixException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int open(UnixPath unixPath, int n, int n2) throws UnixException {
        NativeBuffer nativeBuffer = UnixNativeDispatcher.copyToNativeBuffer(unixPath);
        try {
            int n3 = UnixNativeDispatcher.open0(nativeBuffer.address(), n, n2);
            return n3;
        }
        finally {
            nativeBuffer.release();
        }
    }

    private static native int open0(long var0, int var2, int var3) throws UnixException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int openat(int n, byte[] byArray, int n2, int n3) throws UnixException {
        NativeBuffer nativeBuffer = NativeBuffers.asNativeBuffer(byArray);
        try {
            int n4 = UnixNativeDispatcher.openat0(n, nativeBuffer.address(), n2, n3);
            return n4;
        }
        finally {
            nativeBuffer.release();
        }
    }

    private static native int openat0(int var0, long var1, int var3, int var4) throws UnixException;

    static native void close(int var0);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static long fopen(UnixPath unixPath, String string) throws UnixException {
        NativeBuffer nativeBuffer = UnixNativeDispatcher.copyToNativeBuffer(unixPath);
        NativeBuffer nativeBuffer2 = NativeBuffers.asNativeBuffer(Util.toBytes(string));
        try {
            long l = UnixNativeDispatcher.fopen0(nativeBuffer.address(), nativeBuffer2.address());
            return l;
        }
        finally {
            nativeBuffer2.release();
            nativeBuffer.release();
        }
    }

    private static native long fopen0(long var0, long var2) throws UnixException;

    static native void fclose(long var0) throws UnixException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void link(UnixPath unixPath, UnixPath unixPath2) throws UnixException {
        NativeBuffer nativeBuffer = UnixNativeDispatcher.copyToNativeBuffer(unixPath);
        NativeBuffer nativeBuffer2 = UnixNativeDispatcher.copyToNativeBuffer(unixPath2);
        try {
            UnixNativeDispatcher.link0(nativeBuffer.address(), nativeBuffer2.address());
        }
        finally {
            nativeBuffer2.release();
            nativeBuffer.release();
        }
    }

    private static native void link0(long var0, long var2) throws UnixException;

    static void unlink(UnixPath unixPath) throws UnixException {
        NativeBuffer nativeBuffer = UnixNativeDispatcher.copyToNativeBuffer(unixPath);
        try {
            UnixNativeDispatcher.unlink0(nativeBuffer.address());
        }
        finally {
            nativeBuffer.release();
        }
    }

    private static native void unlink0(long var0) throws UnixException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void unlinkat(int n, byte[] byArray, int n2) throws UnixException {
        NativeBuffer nativeBuffer = NativeBuffers.asNativeBuffer(byArray);
        try {
            UnixNativeDispatcher.unlinkat0(n, nativeBuffer.address(), n2);
        }
        finally {
            nativeBuffer.release();
        }
    }

    private static native void unlinkat0(int var0, long var1, int var3) throws UnixException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void mknod(UnixPath unixPath, int n, long l) throws UnixException {
        NativeBuffer nativeBuffer = UnixNativeDispatcher.copyToNativeBuffer(unixPath);
        try {
            UnixNativeDispatcher.mknod0(nativeBuffer.address(), n, l);
        }
        finally {
            nativeBuffer.release();
        }
    }

    private static native void mknod0(long var0, int var2, long var3) throws UnixException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void rename(UnixPath unixPath, UnixPath unixPath2) throws UnixException {
        NativeBuffer nativeBuffer = UnixNativeDispatcher.copyToNativeBuffer(unixPath);
        NativeBuffer nativeBuffer2 = UnixNativeDispatcher.copyToNativeBuffer(unixPath2);
        try {
            UnixNativeDispatcher.rename0(nativeBuffer.address(), nativeBuffer2.address());
        }
        finally {
            nativeBuffer2.release();
            nativeBuffer.release();
        }
    }

    private static native void rename0(long var0, long var2) throws UnixException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void renameat(int n, byte[] byArray, int n2, byte[] byArray2) throws UnixException {
        NativeBuffer nativeBuffer = NativeBuffers.asNativeBuffer(byArray);
        NativeBuffer nativeBuffer2 = NativeBuffers.asNativeBuffer(byArray2);
        try {
            UnixNativeDispatcher.renameat0(n, nativeBuffer.address(), n2, nativeBuffer2.address());
        }
        finally {
            nativeBuffer2.release();
            nativeBuffer.release();
        }
    }

    private static native void renameat0(int var0, long var1, int var3, long var4) throws UnixException;

    static void mkdir(UnixPath unixPath, int n) throws UnixException {
        NativeBuffer nativeBuffer = UnixNativeDispatcher.copyToNativeBuffer(unixPath);
        try {
            UnixNativeDispatcher.mkdir0(nativeBuffer.address(), n);
        }
        finally {
            nativeBuffer.release();
        }
    }

    private static native void mkdir0(long var0, int var2) throws UnixException;

    static void rmdir(UnixPath unixPath) throws UnixException {
        NativeBuffer nativeBuffer = UnixNativeDispatcher.copyToNativeBuffer(unixPath);
        try {
            UnixNativeDispatcher.rmdir0(nativeBuffer.address());
        }
        finally {
            nativeBuffer.release();
        }
    }

    private static native void rmdir0(long var0) throws UnixException;

    static byte[] readlink(UnixPath unixPath) throws UnixException {
        NativeBuffer nativeBuffer = UnixNativeDispatcher.copyToNativeBuffer(unixPath);
        try {
            byte[] byArray = UnixNativeDispatcher.readlink0(nativeBuffer.address());
            return byArray;
        }
        finally {
            nativeBuffer.release();
        }
    }

    private static native byte[] readlink0(long var0) throws UnixException;

    static byte[] realpath(UnixPath unixPath) throws UnixException {
        NativeBuffer nativeBuffer = UnixNativeDispatcher.copyToNativeBuffer(unixPath);
        try {
            byte[] byArray = UnixNativeDispatcher.realpath0(nativeBuffer.address());
            return byArray;
        }
        finally {
            nativeBuffer.release();
        }
    }

    private static native byte[] realpath0(long var0) throws UnixException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void symlink(byte[] byArray, UnixPath unixPath) throws UnixException {
        NativeBuffer nativeBuffer = NativeBuffers.asNativeBuffer(byArray);
        NativeBuffer nativeBuffer2 = UnixNativeDispatcher.copyToNativeBuffer(unixPath);
        try {
            UnixNativeDispatcher.symlink0(nativeBuffer.address(), nativeBuffer2.address());
        }
        finally {
            nativeBuffer2.release();
            nativeBuffer.release();
        }
    }

    private static native void symlink0(long var0, long var2) throws UnixException;

    static void stat(UnixPath unixPath, UnixFileAttributes unixFileAttributes) throws UnixException {
        NativeBuffer nativeBuffer = UnixNativeDispatcher.copyToNativeBuffer(unixPath);
        try {
            UnixNativeDispatcher.stat0(nativeBuffer.address(), unixFileAttributes);
        }
        finally {
            nativeBuffer.release();
        }
    }

    private static native void stat0(long var0, UnixFileAttributes var2) throws UnixException;

    static void lstat(UnixPath unixPath, UnixFileAttributes unixFileAttributes) throws UnixException {
        NativeBuffer nativeBuffer = UnixNativeDispatcher.copyToNativeBuffer(unixPath);
        try {
            UnixNativeDispatcher.lstat0(nativeBuffer.address(), unixFileAttributes);
        }
        finally {
            nativeBuffer.release();
        }
    }

    private static native void lstat0(long var0, UnixFileAttributes var2) throws UnixException;

    static native void fstat(int var0, UnixFileAttributes var1) throws UnixException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void fstatat(int n, byte[] byArray, int n2, UnixFileAttributes unixFileAttributes) throws UnixException {
        NativeBuffer nativeBuffer = NativeBuffers.asNativeBuffer(byArray);
        try {
            UnixNativeDispatcher.fstatat0(n, nativeBuffer.address(), n2, unixFileAttributes);
        }
        finally {
            nativeBuffer.release();
        }
    }

    private static native void fstatat0(int var0, long var1, int var3, UnixFileAttributes var4) throws UnixException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void chown(UnixPath unixPath, int n, int n2) throws UnixException {
        NativeBuffer nativeBuffer = UnixNativeDispatcher.copyToNativeBuffer(unixPath);
        try {
            UnixNativeDispatcher.chown0(nativeBuffer.address(), n, n2);
        }
        finally {
            nativeBuffer.release();
        }
    }

    private static native void chown0(long var0, int var2, int var3) throws UnixException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void lchown(UnixPath unixPath, int n, int n2) throws UnixException {
        NativeBuffer nativeBuffer = UnixNativeDispatcher.copyToNativeBuffer(unixPath);
        try {
            UnixNativeDispatcher.lchown0(nativeBuffer.address(), n, n2);
        }
        finally {
            nativeBuffer.release();
        }
    }

    private static native void lchown0(long var0, int var2, int var3) throws UnixException;

    static native void fchown(int var0, int var1, int var2) throws UnixException;

    static void chmod(UnixPath unixPath, int n) throws UnixException {
        NativeBuffer nativeBuffer = UnixNativeDispatcher.copyToNativeBuffer(unixPath);
        try {
            UnixNativeDispatcher.chmod0(nativeBuffer.address(), n);
        }
        finally {
            nativeBuffer.release();
        }
    }

    private static native void chmod0(long var0, int var2) throws UnixException;

    static native void fchmod(int var0, int var1) throws UnixException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void utimes(UnixPath unixPath, long l, long l2) throws UnixException {
        NativeBuffer nativeBuffer = UnixNativeDispatcher.copyToNativeBuffer(unixPath);
        try {
            UnixNativeDispatcher.utimes0(nativeBuffer.address(), l, l2);
        }
        finally {
            nativeBuffer.release();
        }
    }

    private static native void utimes0(long var0, long var2, long var4) throws UnixException;

    static native void futimes(int var0, long var1, long var3) throws UnixException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static long opendir(UnixPath unixPath) throws UnixException {
        NativeBuffer nativeBuffer = UnixNativeDispatcher.copyToNativeBuffer(unixPath);
        try {
            long l = UnixNativeDispatcher.opendir0(nativeBuffer.address());
            return l;
        }
        finally {
            nativeBuffer.release();
        }
    }

    private static native long opendir0(long var0) throws UnixException;

    static native long fdopendir(int var0) throws UnixException;

    static native void closedir(long var0) throws UnixException;

    static native byte[] readdir(long var0) throws UnixException;

    static native int read(int var0, long var1, int var3) throws UnixException;

    static native int write(int var0, long var1, int var3) throws UnixException;

    static void access(UnixPath unixPath, int n) throws UnixException {
        NativeBuffer nativeBuffer = UnixNativeDispatcher.copyToNativeBuffer(unixPath);
        try {
            UnixNativeDispatcher.access0(nativeBuffer.address(), n);
        }
        finally {
            nativeBuffer.release();
        }
    }

    private static native void access0(long var0, int var2) throws UnixException;

    static native byte[] getpwuid(int var0) throws UnixException;

    static native byte[] getgrgid(int var0) throws UnixException;

    static int getpwnam(String string) throws UnixException {
        NativeBuffer nativeBuffer = NativeBuffers.asNativeBuffer(Util.toBytes(string));
        try {
            int n = UnixNativeDispatcher.getpwnam0(nativeBuffer.address());
            return n;
        }
        finally {
            nativeBuffer.release();
        }
    }

    private static native int getpwnam0(long var0) throws UnixException;

    static int getgrnam(String string) throws UnixException {
        NativeBuffer nativeBuffer = NativeBuffers.asNativeBuffer(Util.toBytes(string));
        try {
            int n = UnixNativeDispatcher.getgrnam0(nativeBuffer.address());
            return n;
        }
        finally {
            nativeBuffer.release();
        }
    }

    private static native int getgrnam0(long var0) throws UnixException;

    static void statvfs(UnixPath unixPath, UnixFileStoreAttributes unixFileStoreAttributes) throws UnixException {
        NativeBuffer nativeBuffer = UnixNativeDispatcher.copyToNativeBuffer(unixPath);
        try {
            UnixNativeDispatcher.statvfs0(nativeBuffer.address(), unixFileStoreAttributes);
        }
        finally {
            nativeBuffer.release();
        }
    }

    private static native void statvfs0(long var0, UnixFileStoreAttributes var2) throws UnixException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static long pathconf(UnixPath unixPath, int n) throws UnixException {
        NativeBuffer nativeBuffer = UnixNativeDispatcher.copyToNativeBuffer(unixPath);
        try {
            long l = UnixNativeDispatcher.pathconf0(nativeBuffer.address(), n);
            return l;
        }
        finally {
            nativeBuffer.release();
        }
    }

    private static native long pathconf0(long var0, int var2) throws UnixException;

    static native long fpathconf(int var0, int var1) throws UnixException;

    static native byte[] strerror(int var0);

    static boolean openatSupported() {
        return (capabilities & 2) != 0;
    }

    static boolean futimesSupported() {
        return (capabilities & 4) != 0;
    }

    static boolean birthtimeSupported() {
        return (capabilities & 0x10000) != 0;
    }

    private static native int init();

    static {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                System.loadLibrary("nio");
                return null;
            }
        });
        capabilities = UnixNativeDispatcher.init();
    }
}

