/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.util.annotationfactory;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Proxy;
import java.security.AccessController;
import org.hibernate.validator.util.GetClassLoader;
import org.hibernate.validator.util.GetConstructor;
import org.hibernate.validator.util.annotationfactory.AnnotationDescriptor;
import org.hibernate.validator.util.annotationfactory.AnnotationProxy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationFactory {
    public static <T extends Annotation> T create(AnnotationDescriptor<T> descriptor) {
        boolean isSecured = System.getSecurityManager() != null;
        GetClassLoader action = GetClassLoader.fromContext();
        ClassLoader classLoader = isSecured ? AccessController.doPrivileged(action) : action.run();
        Class<?> proxyClass = Proxy.getProxyClass(classLoader, descriptor.type());
        AnnotationProxy handler = new AnnotationProxy(descriptor);
        try {
            return (T)AnnotationFactory.getProxyInstance(proxyClass, handler);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static <T extends Annotation> T getProxyInstance(Class<T> proxyClass, InvocationHandler handler) throws SecurityException, NoSuchMethodException, IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        GetConstructor<T> action = GetConstructor.action(proxyClass, InvocationHandler.class);
        Object constructor = System.getSecurityManager() != null ? (Constructor)AccessController.doPrivileged(action) : action.run();
        return (T)((Annotation)((Constructor)constructor).newInstance(handler));
    }
}

