/*
 * Decompiled with CFR 0.152.
 */
package su.artix.yuki.keyboard.gui;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import su.artix.yuki.converter.KeyboardKeyCodeConverter;
import su.artix.yuki.keyboard.domain.KeyboardButtonData;
import su.artix.yuki.keyboard.gui.KeyboardButtonAction;

public class KeyboardButton
extends Composite {
    public static final Color hoverColor = new Color((Device)Display.getDefault(), 25, 225, 225);
    public static final Color pressedColor = new Color((Device)Display.getDefault(), 5, 200, 200);
    private Label mainText;
    private Label textCode;
    private Composite mainPanel;
    protected Color defaultColor;
    private boolean showCode;
    private boolean showHotKey;
    private boolean isDown;
    protected KeyboardButtonAction action;
    protected KeyboardButtonData btnData;
    PaintListener drawHotKeyBorderListener = new PaintListener(){

        public void paintControl(PaintEvent e) {
            if (KeyboardButton.this.showHotKey && KeyboardButton.this.isHotKey()) {
                GC gc = e.gc;
                Color red = new Color(null, 255, 120, 0);
                gc.setBackground(red);
                Rectangle rect = KeyboardButton.this.mainPanel.getBounds();
                Rectangle rect1 = new Rectangle(rect.x - 2, rect.y - 2, rect.width, rect.height);
                gc.fillRectangle(rect1);
                gc.setBackground(KeyboardButton.this.mainPanel.getBackground());
                rect.x = rect.x;
                rect.y = rect.y;
                rect.height -= 8;
                rect.width -= 8;
                gc.fillRectangle(rect);
            }
        }
    };
    private Listener setNewColor = new Listener(){

        public void handleEvent(Event e) {
            KeyboardButton.this.setColor(hoverColor);
        }
    };
    MouseAdapter adapter = new MouseAdapter(){

        public void mouseUp(MouseEvent e) {
            if (KeyboardButton.this.isDown) {
                if (e.button == 1 && this.isMouseInButton(e) && KeyboardButton.this.action != null) {
                    KeyboardButton.this.action.press(KeyboardButton.this);
                }
                KeyboardButton.this.isDown = false;
            }
        }

        public void mouseDown(MouseEvent e) {
            KeyboardButton.this.isDown = true;
            KeyboardButton.this.setColor(pressedColor);
        }

        private boolean isMouseInButton(MouseEvent e) {
            Point buttonSize = KeyboardButton.this.mainPanel.getSize();
            return e.x >= 0 && e.x < buttonSize.x && e.y >= 0 && e.y < buttonSize.y;
        }
    };

    public KeyboardButton(Composite parent, KeyboardButtonData btnData) {
        super(parent, 0);
        this.btnData = btnData;
        this.init();
    }

    public KeyboardButton(Composite parent, KeyboardButtonData btnData, KeyboardButtonAction action) {
        this(parent, btnData);
        this.action = action;
    }

    private void init() {
        GridLayoutFactory.fillDefaults().margins(2, 2).applyTo((Composite)this);
        FormData data = new FormData();
        data.height = this.btnData.getHeigth();
        data.width = this.btnData.getWidth();
        data.left = new FormAttachment(0, this.btnData.getX());
        data.top = new FormAttachment(0, this.btnData.getY());
        this.setLayoutData(data);
        this.mainPanel = new Composite((Composite)this, 2052);
        this.mainPanel.addPaintListener(this.drawHotKeyBorderListener);
        GridLayoutFactory.fillDefaults().margins(2, 2).spacing(1, 1).applyTo(this.mainPanel);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.mainPanel);
        this.mainText = new Label(this.mainPanel, 0);
        GridDataFactory.fillDefaults().align(16384, 128).grab(false, true).applyTo((Control)this.mainText);
        FontDescriptor boldDescriptor = FontDescriptor.createFrom((Font)this.mainText.getFont()).setStyle(1);
        Font boldFont = boldDescriptor.createFont((Device)this.mainText.getDisplay());
        this.mainText.setFont(boldFont);
        this.textCode = new Label(this.mainPanel, 0);
        GridDataFactory.fillDefaults().align(16384, 1024).applyTo((Control)this.textCode);
        this.updateButtonView();
        this.defaultColor = this.mainPanel.getBackground();
        this.mainPanel.addListener(6, this.setNewColor);
        this.mainPanel.addListener(7, this.getDefColorListener());
        this.mainPanel.addMouseListener((MouseListener)this.adapter);
        this.mainText.addListener(6, this.setNewColor);
        this.mainText.addListener(7, this.getDefColorListener());
        this.mainText.addMouseListener((MouseListener)this.adapter);
        this.textCode.addListener(6, this.setNewColor);
        this.textCode.addListener(7, this.getDefColorListener());
        this.textCode.addMouseListener((MouseListener)this.adapter);
    }

    protected void setColor(Color color) {
        if (!this.showHotKey || this.showHotKey && this.isHotKey()) {
            this.mainPanel.setBackground(color);
            this.mainText.setBackground(color);
            this.textCode.setBackground(color);
        }
    }

    protected Listener getDefColorListener() {
        return new Listener(){

            public void handleEvent(Event e) {
                KeyboardButton.this.setColor(KeyboardButton.this.defaultColor);
            }
        };
    }

    public void updateButtonView() {
        if (this.btnData.getTitle() != null) {
            this.mainText.setText(this.btnData.getTitle());
            this.mainText.setToolTipText(this.btnData.getTitle());
        }
        if (this.btnData.getCode() != 0) {
            String code = null;
            code = this.showCode ? String.valueOf(this.btnData.getCode()) : KeyboardKeyCodeConverter.toDisplayValue((int)this.btnData.getCode());
            this.textCode.setText(code);
            if (code.length() > 3) {
                this.textCode.setToolTipText(code);
            }
            this.textCode.getParent().layout();
        }
        this.mainPanel.redraw();
    }

    public KeyboardButtonData getBtnData() {
        return this.btnData;
    }

    public boolean isShowCode() {
        return this.showCode;
    }

    public void setShowCode(boolean showCode) {
        this.showCode = showCode;
    }

    public void setShowHotKey(boolean showHotKey) {
        this.showHotKey = showHotKey;
    }

    public boolean isHotKey() {
        return this.btnData.getCmaction() != null && this.btnData.getCmaction().getCommand() != null && "COMMAND_HOTKEY".equals(this.btnData.getCmaction().getCommand().getCommandname());
    }
}

