/*
 * Decompiled with CFR 0.152.
 */
package su.artix.yuki.binding;

import java.util.Calendar;
import java.util.Date;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.swt.widgets.DateTime;

public class ToCurrentDateTimeFieldConverter
implements IConverter {
    private final DateTime dateTime;
    private boolean inverseCheckBox = false;

    public ToCurrentDateTimeFieldConverter(DateTime dateTime) {
        this.dateTime = dateTime;
    }

    public ToCurrentDateTimeFieldConverter(DateTime dateTime, boolean inverseCheckBox) {
        this(dateTime);
        this.inverseCheckBox = inverseCheckBox;
    }

    public Object getFromType() {
        return Boolean.class;
    }

    public Object getToType() {
        return Date.class;
    }

    public Object convert(Object fromObject) {
        boolean returnNull = this.inverseCheckBox ? !((Boolean)fromObject).booleanValue() : (Boolean)fromObject;
        return returnNull ? null : this.dateTimeToDate();
    }

    private Date dateTimeToDate() {
        Date result = null;
        if (!this.dateTime.isDisposed()) {
            Calendar cal = Calendar.getInstance();
            cal.set(1, this.dateTime.getYear());
            cal.set(2, this.dateTime.getMonth());
            cal.set(5, this.dateTime.getDay());
            cal.set(11, this.dateTime.getHours());
            cal.set(12, this.dateTime.getMinutes());
            cal.set(13, this.dateTime.getSeconds());
            result = cal.getTime();
        }
        return result;
    }
}

