/*
 * Decompiled with CFR 0.152.
 */
package su.artix.yuki.editors;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.ssa.cashadmin.domain.DomainCollections;
import ru.ssa.cashadmin.domain.utils.JaxbUtil;
import ru.ssa.cashadmin.excep.ExecuteQueryException;
import su.artix.yuki.directory.Directory;
import su.artix.yuki.directory.GuiActivator;
import su.artix.yuki.model.ModelActivator;

public class ImportDialog
extends TitleAreaDialog {
    private static final Logger log = LoggerFactory.getLogger(ImportDialog.class);
    private Map<String, Class> classesMap;
    private Map<String, List<Object>> objectsMap = new HashMap<String, List<Object>>();
    private Map<String, Button> importButtons = new HashMap<String, Button>();

    public ImportDialog(String xmlFileName) {
        super(Display.getCurrent().getActiveShell());
        this.classesMap = Directory.exportClasesMap;
        if (xmlFileName != null) {
            try {
                GuiActivator.getDefault().setLoadCursor(true);
                DomainCollections domainCollections = JaxbUtil.INSTANCE.importFromXml(xmlFileName);
                if (!domainCollections.getDomainCollection().isEmpty()) {
                    Object[] objectArray = domainCollections.getDomainCollection().toArray();
                    int n = objectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object object = objectArray[n2];
                        for (String key : this.classesMap.keySet()) {
                            if (object.getClass() != this.classesMap.get(key)) continue;
                            List<Object> tmpList = this.objectsMap.containsKey(key) ? this.objectsMap.get(key) : new ArrayList<Object>();
                            tmpList.add(object);
                            this.objectsMap.put(key, tmpList);
                            break;
                        }
                        ++n2;
                    }
                }
                GuiActivator.getDefault().setLoadCursor(false);
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText("\u0417\u0430\u0433\u0440\u0443\u0437\u043a\u0430 \u0438\u0437 \u0444\u0430\u0439\u043b\u0430");
        this.setMessage("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043e\u0431\u044a\u0435\u043a\u0442\u044b \u0434\u043b\u044f \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0438", 1);
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        GridLayoutFactory.swtDefaults().numColumns(2).applyTo(container);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)container);
        Group group = new Group(container, 16);
        group.setText("\u0417\u0430\u0433\u0440\u0443\u0436\u0430\u0435\u043c\u044b\u0435 \u043e\u0431\u044a\u0435\u043a\u0442\u044b");
        GridLayoutFactory.swtDefaults().numColumns(2).applyTo((Composite)group);
        GridDataFactory.fillDefaults().align(4, 128).grab(true, false).applyTo((Control)group);
        group.setBackground(new Color((Device)Display.getCurrent(), 255, 255, 255));
        ArrayList<String> sortedKeys = new ArrayList<String>(this.objectsMap.keySet());
        Collections.sort(sortedKeys);
        for (String key : sortedKeys) {
            Button button = new Button((Composite)group, 32);
            button.setText(key);
            button.setSelection(true);
            button.setBackground(new Color((Device)Display.getCurrent(), 255, 255, 255));
            this.importButtons.put(key, button);
        }
        Composite container1 = new Composite(container, 0);
        GridLayoutFactory.swtDefaults().applyTo(container1);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)container1);
        Button selectAll = new Button(container1, 0);
        selectAll.setText("\u0412\u044b\u0434\u0435\u043b\u0438\u0442\u044c \u0432\u0441\u0435");
        selectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportDialog.this.setSelectExportButtons(true);
            }
        });
        Button deselectAll = new Button(container1, 0);
        deselectAll.setText("\u0423\u0431\u0440\u0430\u0442\u044c \u0432\u044b\u0434\u0435\u043b\u0435\u043d\u0438\u0435");
        deselectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportDialog.this.setSelectExportButtons(false);
            }
        });
        return area;
    }

    private void setSelectExportButtons(boolean selected) {
        for (String key : this.importButtons.keySet()) {
            this.importButtons.get(key).setSelection(selected);
        }
    }

    private void importObjects(Class cl, List<Object> objects) {
        for (Object object : objects) {
            try {
                ModelActivator.getDefault().getModelProvider().getDirectoryModel(cl).doUpdate(object);
            }
            catch (ExecuteQueryException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    protected void okPressed() {
        for (String key : this.importButtons.keySet()) {
            if (!this.importButtons.get(key).getSelection()) continue;
            this.importObjects(this.classesMap.get(key), this.objectsMap.get(key));
        }
        super.okPressed();
    }

    protected boolean isResizable() {
        return true;
    }
}

