/*
 * Decompiled with CFR 0.152.
 */
package su.artix.yuki.view.state;

import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.IMemento;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import su.artix.yuki.view.state.PersistState;

public class PersistTableWidthState
implements PersistState<Table> {
    private static final Logger log = LoggerFactory.getLogger(PersistTableWidthState.class);
    private String id;
    private IMemento memento;

    public PersistTableWidthState(IMemento memento, String id) {
        this.id = id;
        this.memento = memento;
    }

    @Override
    public void saveState(IMemento memento, Table composite) {
        log.trace("save state");
        IMemento stored = memento.getChild(String.valueOf(this.id) + "_width");
        memento = stored == null ? memento.createChild(String.valueOf(this.id) + "_width") : stored;
        int i = 0;
        while (i < composite.getColumnCount()) {
            int width = composite.getColumn(i).getWidth();
            memento.putInteger("column_" + i, width);
            ++i;
        }
    }

    @Override
    public void restoreState(Table composite) {
        log.trace("restore state");
        if (this.memento != null) {
            this.memento = this.memento.getChild(String.valueOf(this.id) + "_width");
            if (this.memento != null) {
                String columnsMenuText = "\u041a\u043e\u043b\u043e\u043d\u043a\u0438";
                Menu columnsMenu = null;
                Menu menu = composite.getMenu();
                MenuItem[] menuItemArray = menu.getItems();
                int n = menuItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    MenuItem item = menuItemArray[n2];
                    if (columnsMenuText.equals(item.getText())) {
                        columnsMenu = item.getMenu();
                    }
                    ++n2;
                }
                int i = 0;
                while (i < composite.getColumnCount()) {
                    Integer width = this.memento.getInteger("column_" + i);
                    if (width != null) {
                        composite.getColumn(i).setWidth(width.intValue());
                        if (columnsMenu != null && columnsMenu.getItemCount() > i) {
                            columnsMenu.getItem(i).setSelection(width != 0);
                        }
                    }
                    ++i;
                }
            }
        }
    }
}

