/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.mapping.event;

import com.mongodb.DBObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.mongodb.core.mapping.event.AbstractMongoEventListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoggingEventListener
extends AbstractMongoEventListener<Object> {
    private static final Logger log = LoggerFactory.getLogger(LoggingEventListener.class);

    @Override
    public void onBeforeConvert(Object source) {
        log.info("onBeforeConvert: " + source);
    }

    @Override
    public void onBeforeSave(Object source, DBObject dbo) {
        try {
            log.info("onBeforeSave: " + source + ", " + dbo);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void onAfterSave(Object source, DBObject dbo) {
        log.info("onAfterSave: " + source + ", " + dbo);
    }

    @Override
    public void onAfterLoad(DBObject dbo) {
        log.info("onAfterLoad: " + dbo);
    }

    @Override
    public void onAfterConvert(DBObject dbo, Object source) {
        log.info("onAfterConvert: " + dbo + ", " + source);
    }
}

