/*
 * Decompiled with CFR 0.152.
 */
package su.artix.cashserver.security;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.PermissionEvaluator;
import org.springframework.security.access.hierarchicalroles.RoleHierarchy;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import su.artix.cashserver.core.cashregistry.domain.SecurityPermission;
import su.artix.cashserver.core.cashregistry.domain.SecurityRole;
import su.artix.cashserver.core.cashregistry.repository.SecurityRoleRepository;
import su.artix.cashserver.security.SecurityRoleUpdate;

public class CustomPermissionEvaluator
implements PermissionEvaluator,
SecurityRoleUpdate {
    private static final Logger log = LoggerFactory.getLogger(CustomPermissionEvaluator.class);
    @Autowired
    private SecurityRoleRepository securityRoleRepository;
    private RoleHierarchy roleHierarchy;
    private List<SecurityRole> securityRoles = null;
    private Map<String, Integer> securityRights;

    @PostConstruct
    public void init() {
        this.securityRights = new HashMap<String, Integer>();
        this.securityRights.put("READ", 1);
        this.securityRights.put("WRITE", 2);
        this.securityRights.put("CREATE", 4);
        this.securityRights.put("DELETE", 8);
        this.securityRights.put("ADMINISTRATION", 16);
    }

    public boolean hasPermission(Authentication authentication, Object targetDomainObject, Object permission) {
        this.readSecurityRole();
        Collection auths = authentication.getAuthorities();
        ArrayList<String> userRoles = new ArrayList<String>();
        for (GrantedAuthority auth : auths) {
            userRoles.add(auth.getAuthority());
        }
        boolean result = true;
        block3: for (SecurityRole securityRole : this.securityRoles) {
            if (!userRoles.contains(securityRole.getRoleName())) continue;
            for (SecurityPermission securityPermission : securityRole.getPermissions()) {
                try {
                    if (securityPermission == null || securityPermission.getSecurityObject() == null || !securityPermission.getSecurityObject().equals(targetDomainObject)) continue;
                    result = false;
                    if (securityPermission.getPermission() < this.securityRights.get(permission)) continue;
                    result = true;
                    continue block3;
                }
                catch (RuntimeException e) {
                    log.error("securityPermission={}, targetDomainObject={}", (Object)securityPermission, targetDomainObject);
                    log.error(e.getMessage(), (Throwable)e);
                    throw e;
                }
            }
        }
        return result;
    }

    private void readSecurityRole() {
        if (this.securityRoles == null) {
            List temp = this.securityRoleRepository.findAll();
            this.securityRoles = new ArrayList<SecurityRole>();
            try {
                for (SecurityRole tempA : temp) {
                    this.securityRoles.add(this.securityRoleRepository.findByName(tempA.getName()));
                }
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                this.securityRoles = null;
            }
        }
    }

    public void disposeSecurityRole() {
        this.securityRoles = null;
    }

    public boolean hasPermission(Authentication authentication, Serializable targetId, String targetType, Object permission) {
        return false;
    }

    private String getRole(Authentication authentication) {
        String highestRole = null;
        try {
            Collection auths = this.roleHierarchy.getReachableGrantedAuthorities(authentication.getAuthorities());
            Iterator iterator = auths.iterator();
            if (iterator.hasNext()) {
                GrantedAuthority auth = (GrantedAuthority)iterator.next();
                highestRole = auth.getAuthority();
            }
        }
        catch (Exception exception) {}
        return highestRole;
    }

    public RoleHierarchy getRoleHierarchy() {
        return this.roleHierarchy;
    }

    public void setRoleHierarchy(RoleHierarchy roleHierarchy) {
        this.roleHierarchy = roleHierarchy;
    }
}

