/*
 * Decompiled with CFR 0.152.
 */
package ru.ssa.cashadmin.domain;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.MappedSuperclass;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.validation.constraints.NotNull;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlTransient;
import org.hibernate.annotations.NotFound;
import org.hibernate.annotations.NotFoundAction;
import org.hibernate.annotations.Target;
import ru.ssa.cashadmin.domain.Barcodes;
import ru.ssa.cashadmin.domain.HotKey;
import ru.ssa.cashadmin.domain.Invent;

@XmlAccessorType(value=XmlAccessType.NONE)
@Entity
@Table(name="hotkeyinvent")
@MappedSuperclass
public class HotKeyInvent {
    @XmlElement
    @NotNull
    @Id
    @GeneratedValue
    private Integer hotkeyinventid;
    @XmlTransient
    @ManyToOne
    @JoinColumn(name="inventcode", referencedColumnName="bcode", insertable=false, updatable=false)
    @NotFound(action=NotFoundAction.IGNORE)
    @Target(value=Invent.class)
    private Invent invent;
    @XmlTransient
    @ManyToOne
    @JoinColumn(name="inventcode", referencedColumnName="barcode", insertable=false, updatable=false)
    @NotFound(action=NotFoundAction.IGNORE)
    @Target(value=Barcodes.class)
    private Barcodes barcode;
    @XmlElement
    @Column(name="inventcode")
    private String inventcode;
    @XmlTransient
    @ManyToOne
    @JoinColumn(name="hotkeycode", insertable=false, updatable=false)
    @NotFound(action=NotFoundAction.IGNORE)
    private HotKey hotkey;
    @XmlElement
    @Column(name="hotkeycode")
    private Integer hotkeycode;
    @Transient
    private String inventname;

    protected HotKeyInvent() {
    }

    public void setHotkeyinventid(Integer hotkeyinventid) {
        this.hotkeyinventid = hotkeyinventid;
    }

    public Integer getHotkeyinventid() {
        return this.hotkeyinventid;
    }

    public void setInventcode(String inventcode) {
        this.inventcode = inventcode;
    }

    public String getInventcode() {
        return this.inventcode;
    }

    public void setInvent(Invent invent) {
        this.invent = invent;
        this.inventcode = invent != null ? invent.getCode() : null;
    }

    public Invent getInvent() {
        return this.invent;
    }

    public void setHotkey(HotKey hotkey) {
        this.hotkey = hotkey;
        this.hotkeycode = hotkey != null ? hotkey.getHotkeycode() : null;
    }

    public HotKey getHotkey() {
        return this.hotkey;
    }

    public void setHotkeycode(Integer hotkeycode) {
        this.hotkeycode = hotkeycode;
    }

    public Integer getHotkeycode() {
        return this.hotkeycode;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.hotkeyinventid == null ? 0 : this.hotkeyinventid.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HotKeyInvent other = (HotKeyInvent)obj;
        return !(this.hotkeyinventid == null ? other.hotkeyinventid != null : !this.hotkeyinventid.equals(other.hotkeyinventid));
    }

    public Barcodes getBarcode() {
        return this.barcode;
    }

    public void setBarcode(Barcodes barcode) {
        if (barcode != null) {
            this.inventcode = barcode.getCode();
        } else {
            this.barcode = null;
        }
    }

    public String getInventname() {
        String res = "\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u043e";
        if (this.getHotkey() != null) {
            if (this.getHotkey().getBybarcode() != null && this.getHotkey().getBybarcode().booleanValue()) {
                if (this.getBarcode() != null) {
                    res = this.getBarcode().getName();
                }
            } else if (this.getInvent() != null) {
                res = this.getInvent().getName();
            }
        }
        return res;
    }
}

