/*
 * Decompiled with CFR 0.152.
 */
package org.mihalis.opal.propertyTable.editor;

import org.eclipse.swt.custom.ControlEditor;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.custom.TreeEditor;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.mihalis.opal.propertyTable.PTProperty;
import org.mihalis.opal.propertyTable.PTWidget;
import org.mihalis.opal.propertyTable.editor.PTEditor;

public class PTSpinnerEditor
extends PTEditor {
    private final int max;
    private final int min;

    public PTSpinnerEditor(int n, int n2) {
        this.min = n;
        this.max = n2;
    }

    @Override
    public ControlEditor render(final PTWidget pTWidget, Item item, final PTProperty pTProperty) {
        Object object = pTWidget.getWidget() instanceof Table ? new TableEditor((Table)pTWidget.getWidget()) : new TreeEditor((Tree)pTWidget.getWidget());
        final Spinner spinner = new Spinner(pTWidget.getWidget(), 256);
        spinner.setMinimum(this.min);
        spinner.setMaximum(this.max);
        Integer n = (Integer)pTProperty.getValue();
        spinner.setSelection(n == null ? this.min : n);
        spinner.addListener(15, new Listener(){

            public void handleEvent(Event event) {
                pTWidget.updateDescriptionPanel(pTProperty);
            }
        });
        spinner.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                pTProperty.setValue(spinner.getSelection());
            }
        });
        object.grabHorizontal = true;
        if (pTWidget.getWidget() instanceof Table) {
            object.setEditor((Control)spinner, (TableItem)item, 1);
        } else {
            ((TreeEditor)object).setEditor((Control)spinner, (TreeItem)item, 1);
        }
        spinner.setEnabled(pTProperty.isEnabled());
        return object;
    }
}

