/*
 * Decompiled with CFR 0.152.
 */
package su.artix.discountmanager.controls.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.ui.PlatformUI;
import su.artix.discountmanager.Activator;
import su.artix.discountmanager.holders.ViewHolder;
import su.artix.discountmanager.trees.CustomSystemTreeViewer;
import su.artix.discountmanager.views.DiscountGanttChartView;
import su.artix.loyaltylib.domain.java.discountsystem.Discount;
import su.artix.loyaltylib.domain.java.discountsystem.DiscountCampaign;
import su.artix.loyaltylib.domain.java.discountsystem.DiscountCampaignGroup;

public class ActiveCampaignsFilterAction
extends Action {
    private DiscountTreeActiveCampaignsFilter filter = new DiscountTreeActiveCampaignsFilter();
    private CustomSystemTreeViewer discountTreeViewer;
    private DiscountGanttChartView discountGanttChartView;
    private ImageDescriptor activeImageDescriptor;
    private ImageDescriptor deactiveImageDescriptor;
    private String activeToolTip;
    private String deactiveToolTip;
    private boolean checked;

    public int getStyle() {
        return 2;
    }

    public boolean isChecked() {
        return this.checked;
    }

    public ImageDescriptor getActiveImageDescriptor() {
        return this.activeImageDescriptor;
    }

    public void setActiveImageDescriptor(ImageDescriptor activeImageDescriptor) {
        this.activeImageDescriptor = activeImageDescriptor;
    }

    public ImageDescriptor getDeactiveImageDescriptor() {
        return this.deactiveImageDescriptor;
    }

    public void setDeactiveImageDescriptor(ImageDescriptor deactiveImageDescriptor) {
        this.deactiveImageDescriptor = deactiveImageDescriptor;
    }

    public String getActiveToolTip() {
        return this.activeToolTip;
    }

    public void setActiveToolTip(String activeToolTip) {
        this.setToolTipText(activeToolTip);
        this.activeToolTip = activeToolTip;
    }

    public String getDeactiveToolTip() {
        return this.deactiveToolTip;
    }

    public void setDeactiveToolTip(String deactiveToolTip) {
        this.deactiveToolTip = deactiveToolTip;
    }

    public void setChecked(boolean checked) {
        this.checked = checked;
        if (this.discountTreeViewer == null) {
            this.discountTreeViewer = (CustomSystemTreeViewer)ViewHolder.INSTANCE.getActiveViewPart().getSite().getSelectionProvider();
        }
        this.discountGanttChartView = (DiscountGanttChartView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("su.artix.discountmanager.views.DiscountGanttChartView");
        if (this.isChecked()) {
            this.filter.init();
            this.discountTreeViewer.addFilter(this.filter);
            if (this.discountGanttChartView != null) {
                this.discountGanttChartView.getViewPanel().addFilter(this.discountTreeViewer.getJoinedViewID(), this.filter);
            }
            this.setToolTipText(this.deactiveToolTip);
            this.setImageDescriptor(this.activeImageDescriptor);
        } else {
            this.discountTreeViewer.removeFilter(this.filter);
            if (this.discountGanttChartView != null) {
                this.discountGanttChartView.getViewPanel().removeFilter(this.discountTreeViewer.getJoinedViewID(), this.filter);
            }
            this.setToolTipText(this.activeToolTip);
            this.setImageDescriptor(this.deactiveImageDescriptor);
        }
    }

    public static class DiscountTreeActiveCampaignsFilter
    extends ViewerFilter {
        private String id = "DiscountTreeActiveCampaignsFilter";
        private Boolean hideEmptyGroups;

        public DiscountTreeActiveCampaignsFilter() {
            this.init();
        }

        public void init() {
            IPreferenceStore preferenceStore = Activator.getDefault().getPreferenceStore();
            this.hideEmptyGroups = preferenceStore.getBoolean("HIDE_GROUP_IN_FILTER");
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (element instanceof DiscountCampaign) {
                return ((DiscountCampaign)element).getActive();
            }
            if (element instanceof Discount) {
                return ((Discount)element).getActive();
            }
            if (this.hideEmptyGroups.booleanValue() && element instanceof DiscountCampaignGroup) {
                return this.hasSubActive((DiscountCampaignGroup)element);
            }
            return true;
        }

        private boolean hasSubActive(DiscountCampaignGroup element) {
            boolean anyoneActive = false;
            for (DiscountCampaign campaign : element.getDiscountCampaigns()) {
                if (!campaign.getActive().booleanValue()) continue;
                anyoneActive = true;
                break;
            }
            if (!anyoneActive) {
                for (DiscountCampaign campaign : element.getSubGroups()) {
                    if (!this.hasSubActive((DiscountCampaignGroup)campaign)) continue;
                    anyoneActive = true;
                    break;
                }
            }
            return anyoneActive;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            DiscountTreeActiveCampaignsFilter other = (DiscountTreeActiveCampaignsFilter)((Object)obj);
            return !(this.id == null ? other.id != null : !this.id.equals(other.id));
        }
    }
}

