/*
 * Decompiled with CFR 0.152.
 */
package su.artix.discountmanager.handlers.cards;

import java.util.Iterator;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.beanutils.PropertyUtils;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.ssa.cashadmin.LibActivator;
import ru.ssa.cashadmin.domain.Card;
import su.artix.accounting.domain.CardStatus;
import su.artix.artixadmin.connection.ArtixAdminContextHolder;
import su.artix.discountmanager.Activator;
import su.artix.discountmanager.images.ImagesFactory;
import su.artix.discountmanager.utils.InfoMessageFactory;
import su.artix.discountmanager.utils.ItemsText;
import su.artix.discountmanager.utils.MultiLineDialogOperations;
import su.artix.discountmanager.utils.MultiLineMessages;
import su.artix.discountmanagercore.dao.accounting.AccountingDAO;
import su.artix.discountmanagercore.model.accounting.AccountingResult;
import su.artix.yuki.model.ModelActivator;

public class ChangeCardStatusAction
extends Action
implements IMenuCreator,
ISelectionChangedListener {
    private CardStatus currentCardStatus = null;
    private static final Logger log = LoggerFactory.getLogger(ChangeCardStatusAction.class);
    private Menu cardStatusList;
    private IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();

    public void dispose() {
        if (this.cardStatusList != null) {
            this.cardStatusList.dispose();
            this.cardStatusList = null;
        }
    }

    protected int cardStatusConvert(CardStatus cardStatus) {
        switch (cardStatus) {
            case ANONYMOUS_CARD: {
                return 0;
            }
            case ACTIVE: {
                return 1;
            }
            case BLOCKED: {
                return 2;
            }
            case EARN_PAY: {
                return 1;
            }
            case EARN_ONLY: {
                return 0;
            }
            case NO_OPERATION: {
                return 2;
            }
            case PAY_ONLY: {
                return 3;
            }
        }
        return 2;
    }

    public Menu getMenu(Menu parent) {
        return null;
    }

    public Menu getMenu(Control parent) {
        CardStatus[] statuses;
        if (this.cardStatusList != null) {
            this.cardStatusList.dispose();
        }
        this.cardStatusList = new Menu(parent);
        CardStatus[] cardStatusArray = statuses = CardStatus.getModern();
        int n = statuses.length;
        int n2 = 0;
        while (n2 < n) {
            CardStatus cardStatus = cardStatusArray[n2];
            if (cardStatus != CardStatus.WITHDRAWAL) {
                this.addActionToMenu(this.cardStatusList, new SetCardStatusAction(this, cardStatus){

                    public void run() {
                        currentCardStatus = this.getCardStatusInner();
                        this.runAction();
                    }
                });
            }
            ++n2;
        }
        return this.cardStatusList;
    }

    protected void addActionToMenu(Menu parent, Action action) {
        ActionContributionItem item = new ActionContributionItem((IAction)action);
        item.fill(parent, -1);
    }

    public ChangeCardStatusAction() {
        super("Card status", 4);
        this.setId("rcp.setCardStatusAction");
        this.setText("");
        this.setToolTipText("\u0423\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u0441\u0442\u0430\u0442\u0443\u0441");
        this.setText("\u0423\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u0441\u0442\u0430\u0442\u0443\u0441");
        this.setImageDescriptor(ImagesFactory.INSTANCE.getImageDescriptor("16x16/plane/cards.png"));
        this.setMenuCreator(this);
    }

    public CardStatus getCardStatus() {
        return this.currentCardStatus;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        if (event.getSelection() instanceof IStructuredSelection) {
            this.setEnabled(((IStructuredSelection)event.getSelection()).size() > 0);
        } else {
            this.setEnabled(false);
        }
    }

    public String getToolTipText() {
        return "\u0423\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u0441\u0442\u0430\u0442\u0443\u0441 \u0434\u043b\u044f \u0432\u044b\u0434\u0435\u043b\u0435\u043d\u043d\u044b\u0445 \u043a\u0430\u0440\u0442";
    }

    public void runAction() {
        Activator.getDefault().setLoadCursor(true);
        ISelection selection = this.window.getSelectionService().getSelection();
        if (selection instanceof StructuredSelection) {
            final IStructuredSelection strucSelection = (IStructuredSelection)selection;
            final AtomicBoolean abortCommand = new AtomicBoolean(false);
            MultiLineDialogOperations cardMessageOperations = new MultiLineDialogOperations(){

                @Override
                public void abortOperation() {
                    abortCommand.set(true);
                }
            };
            final MultiLineMessages messages = InfoMessageFactory.multiLineInfoMessage(cardMessageOperations);
            ArtixAdminContextHolder.getConnectionId();
            final String connectionId = ArtixAdminContextHolder.getConnectionId();
            Thread changeCardsStatusThread = new Thread("setCardStatusThread"){

                @Override
                public void run() {
                    ArtixAdminContextHolder.setConnectionId((String)connectionId);
                    Class cardClazz = LibActivator.getDefault().getActualClassResolver().getActual(Card.class);
                    try {
                        boolean errorExist = false;
                        Iterator iterator = strucSelection.iterator();
                        while (iterator.hasNext()) {
                            if (abortCommand.get()) break;
                            Card discountCard = (Card)iterator.next();
                            AccountingResult result = Activator.getDefault().getBeanByClass(AccountingDAO.class).setCardStatus(discountCard.getNumber(), ChangeCardStatusAction.this.getCardStatus());
                            log.debug("{}", (Object)result);
                            if (result.isSuccess()) {
                                PropertyUtils.setProperty((Object)discountCard, (String)"cardstatus", (Object)ChangeCardStatusAction.this.cardStatusConvert(ChangeCardStatusAction.this.getCardStatus()));
                                ModelActivator.getDefault().getModelProvider().getDirectoryModel(cardClazz).doUpdate((Object)discountCard);
                            } else {
                                errorExist = true;
                            }
                            messages.addMessage("\u041a\u0430\u0440\u0442\u0430 \u2116: " + discountCard.getNumber() + " => " + result.getDescription());
                        }
                        messages.lastMessage(errorExist ? "\u041e\u043f\u0435\u0440\u0430\u0446\u0438\u044f \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u0430 \u0441 \u043e\u0448\u0438\u0431\u043a\u0430\u043c\u0438" : "\u041e\u043f\u0435\u0440\u0430\u0446\u0438\u044f \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u0430 \u0431\u0435\u0437 \u043e\u0448\u0438\u0431\u043e\u043a");
                    }
                    catch (Exception e) {
                        log.error(e.getMessage(), (Throwable)e);
                        messages.lastMessage("\u041e\u043f\u0435\u0440\u0430\u0446\u0438\u044f \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u0430 \u0441 \u043e\u0448\u0438\u0431\u043a\u0430\u043c\u0438:" + e.getMessage());
                    }
                }
            };
            changeCardsStatusThread.start();
            Activator.getDefault().setLoadCursor(false);
        }
    }

    private class SetCardStatusAction
    extends Action {
        private CardStatus cardStatusInner;

        public String getText() {
            if (this.cardStatusInner != null) {
                return ItemsText.accountingCardStatusItem.get(this.cardStatusInner);
            }
            return "\u043d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u043e";
        }

        public SetCardStatusAction(CardStatus cardStatusInner) {
            this.cardStatusInner = cardStatusInner;
        }

        public CardStatus getCardStatusInner() {
            return this.cardStatusInner;
        }
    }
}

